/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.io.IOException;
import java.net.URI;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInput;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.IActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionSequenceElement;
import org.pentaho.actionsequence.dom.actions.EmailAction;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;
import org.pentaho.commons.connection.IPentahoStreamSource;

public class EmailAttachment
implements IActionSequenceElement {
    Element attachmentElement;
    IActionParameterMgr actionInputProvider;
    EmailAction emailAction;
    public static final String ATTACHMENT_NAME_ATTRIBUTE = "name-param";
    public static final String ATTACHMENT_CONTENT_ATTRIBUTE = "input-param";
    public static final String ATTACHMENT_RESOURCE_ATTRIBUTE = "resource-param";
    public static final String ATTACHMENT_NAME_PREFIX = "attach_name_";
    public static final String ATTACHMENT_RESOURCE_PREFIX = "attach_resource_";
    public static final String ELEMENT_NAME = "attachment-ref";
    public static final String OLD_ATTACHMENT_ELEMENT = "attach";
    public static final String OLD_ATTACHMENT_NAME_ELEMENT = "attach-name";

    EmailAttachment(EmailAction emailAction) {
        this.emailAction = emailAction;
        this.actionInputProvider = emailAction.actionParameterMgr;
    }

    EmailAttachment(EmailAction emailAction, IActionInputVariable attachment) {
        this.attachmentElement = DocumentHelper.makeElement((Branch)emailAction.getElement(), (String)"component-definition").addElement(ELEMENT_NAME);
        this.actionInputProvider = emailAction.actionParameterMgr;
        this.setName(attachment.getVariableName());
        this.setContentParam(attachment);
    }

    EmailAttachment(EmailAction emailAction, String name, URI uri, String mimeType) {
        this.attachmentElement = DocumentHelper.makeElement((Branch)emailAction.getElement(), (String)"component-definition").addElement(ELEMENT_NAME);
        this.actionInputProvider = emailAction.actionParameterMgr;
        this.setName(name);
        this.setContentResource(uri, mimeType);
    }

    EmailAttachment(Element attachmentElement, IActionParameterMgr actionInputProvider) {
        this.attachmentElement = attachmentElement;
        this.actionInputProvider = actionInputProvider;
    }

    public void delete() {
        EmailAction emailAction = this.getEmailAction();
        Attribute attribute = this.attachmentElement.attribute(ATTACHMENT_NAME_ATTRIBUTE);
        if (attribute != null) {
            emailAction.setActionInputValue(attribute.getValue().trim(), (IActionInputSource)null);
        }
        if ((attribute = this.attachmentElement.attribute(ATTACHMENT_CONTENT_ATTRIBUTE)) != null) {
            emailAction.setActionInputValue(attribute.getValue().trim(), (IActionInputSource)null);
        }
        if ((attribute = this.attachmentElement.attribute(ATTACHMENT_RESOURCE_ATTRIBUTE)) != null) {
            IActionResource actionResource = emailAction.getResource(attribute.getValue().trim());
            actionResource.setURI(null);
        }
        this.attachmentElement.detach();
    }

    public IActionSequenceDocument getDocument() {
        ActionSequenceDocument doc = null;
        if (this.attachmentElement != null && this.attachmentElement.getDocument() != null) {
            doc = new ActionSequenceDocument(this.attachmentElement.getDocument(), this.actionInputProvider);
        }
        return doc;
    }

    public Element getElement() {
        return this.attachmentElement;
    }

    public EmailAction getEmailAction() {
        return this.emailAction != null ? this.emailAction : new EmailAction(this.attachmentElement.getParent().getParent(), this.actionInputProvider);
    }

    void convertToNewAttachmentStyle() {
        Element actionElement = this.emailAction.getElement();
        this.attachmentElement = DocumentHelper.makeElement((Branch)actionElement, (String)"component-definition/attachment-ref");
        Element oldAttachmentElement = (Element)actionElement.selectSingleNode("component-definition/attach");
        String attachmentParam = oldAttachmentElement.getText();
        oldAttachmentElement.detach();
        this.attachmentElement.addAttribute(ATTACHMENT_CONTENT_ATTRIBUTE, attachmentParam);
        String attachmentNameParam = null;
        String attachmentName = null;
        Element oldAttachmentNameElement = (Element)actionElement.selectSingleNode("component-definition/attach-name");
        if (oldAttachmentNameElement != null) {
            attachmentName = oldAttachmentNameElement.getText();
            oldAttachmentNameElement.detach();
        } else {
            attachmentNameParam = OLD_ATTACHMENT_NAME_ELEMENT;
        }
        if (attachmentName != null) {
            this.attachmentElement.addAttribute(ATTACHMENT_NAME_ATTRIBUTE, this.getUniqueNameParam());
            this.emailAction.setActionInputValue(this.attachmentElement.attribute(ATTACHMENT_NAME_ATTRIBUTE).getValue().trim(), new ActionInputConstant(attachmentName, this.actionInputProvider));
        } else {
            this.attachmentElement.addAttribute(ATTACHMENT_NAME_ATTRIBUTE, attachmentNameParam);
        }
        this.emailAction = null;
    }

    public void setName(String name) {
        if (this.isDeprecatedAttachmentStyle()) {
            this.convertToNewAttachmentStyle();
        }
        if (this.attachmentElement.attribute(ATTACHMENT_NAME_ATTRIBUTE) == null) {
            this.attachmentElement.addAttribute(ATTACHMENT_NAME_ATTRIBUTE, this.getUniqueNameParam());
        }
        this.getEmailAction().setActionInputValue(this.attachmentElement.attribute(ATTACHMENT_NAME_ATTRIBUTE).getValue().trim(), new ActionInputConstant(name.trim(), this.actionInputProvider));
    }

    public String getName() {
        String paramName = this.isDeprecatedAttachmentStyle() ? OLD_ATTACHMENT_NAME_ELEMENT : this.attachmentElement.attribute(ATTACHMENT_NAME_ATTRIBUTE).getValue().trim();
        Object name = null;
        if (paramName != null) {
            name = this.getEmailAction().getInput(paramName).getValue();
        }
        if (name != null && this.actionInputProvider != null) {
            name = this.actionInputProvider.replaceParameterReferences(name.toString());
        }
        return name != null ? name.toString() : null;
    }

    public void setNameParam(IActionInputVariable variable) {
        if (this.isDeprecatedAttachmentStyle()) {
            this.convertToNewAttachmentStyle();
        }
        if (variable != null) {
            if (this.attachmentElement.attribute(ATTACHMENT_NAME_ATTRIBUTE) == null) {
                this.attachmentElement.addAttribute(ATTACHMENT_NAME_ATTRIBUTE, this.getUniqueNameParam());
            }
            String paramName = this.attachmentElement.attribute(ATTACHMENT_NAME_ATTRIBUTE).getValue().trim();
            this.getEmailAction().setActionInputValue(paramName, variable);
        }
    }

    public ActionInput getNameParam() {
        String paramName;
        ActionInput actionInput = null;
        String string = paramName = this.isDeprecatedAttachmentStyle() ? OLD_ATTACHMENT_NAME_ELEMENT : this.attachmentElement.attribute(ATTACHMENT_NAME_ATTRIBUTE).getValue().trim();
        if (paramName != null) {
            actionInput = this.getEmailAction().getInputParam(paramName);
        }
        return actionInput;
    }

    public void setContentParam(IActionInputVariable variable) {
        if (this.isDeprecatedAttachmentStyle()) {
            this.convertToNewAttachmentStyle();
        }
        if (variable != null) {
            Attribute resourceAttribute = this.attachmentElement.attribute(ATTACHMENT_RESOURCE_ATTRIBUTE);
            if (resourceAttribute != null) {
                this.getEmailAction().setResourceUri(resourceAttribute.getValue(), null, null);
                this.attachmentElement.addAttribute(ATTACHMENT_CONTENT_ATTRIBUTE, null);
            }
            this.attachmentElement.addAttribute(ATTACHMENT_CONTENT_ATTRIBUTE, variable.getVariableName());
            this.getEmailAction().setActionInputValue(variable.getVariableName(), variable);
        }
    }

    public ActionInput getContentParam() {
        ActionInput actionInput = null;
        if (this.isDeprecatedAttachmentStyle()) {
            Element oldAttachmentElement = (Element)this.getEmailAction().getElement().selectSingleNode("component-definition/attach");
            String attachmentParam = oldAttachmentElement.getText();
            actionInput = this.getEmailAction().getInputParam(attachmentParam);
        } else {
            Attribute attribute = this.attachmentElement.attribute(ATTACHMENT_CONTENT_ATTRIBUTE);
            if (attribute != null) {
                actionInput = this.getEmailAction().getInputParam(attribute.getValue().trim());
            }
        }
        return actionInput;
    }

    public IActionResource getContentResource() {
        Attribute attribute;
        IActionResource actionResource = null;
        if (!this.isDeprecatedAttachmentStyle() && (attribute = this.attachmentElement.attribute(ATTACHMENT_RESOURCE_ATTRIBUTE)) != null) {
            actionResource = this.getEmailAction().getResource(attribute.getValue().trim());
        }
        return actionResource;
    }

    public IActionResource setContentResource(URI uri, String mimeType) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        IActionResource actionResource = null;
        if (this.isDeprecatedAttachmentStyle()) {
            this.convertToNewAttachmentStyle();
        }
        if (uri != null) {
            ActionInput actionInput = this.getContentParam();
            if (actionInput != null) {
                actionInput.delete();
            }
            this.attachmentElement.addAttribute(ATTACHMENT_CONTENT_ATTRIBUTE, null);
            Attribute resourceAttribute = this.attachmentElement.attribute(ATTACHMENT_RESOURCE_ATTRIBUTE);
            if (resourceAttribute == null) {
                this.attachmentElement.addAttribute(ATTACHMENT_RESOURCE_ATTRIBUTE, this.getUniqueResourceName());
                resourceAttribute = this.attachmentElement.attribute(ATTACHMENT_RESOURCE_ATTRIBUTE);
            }
            actionResource = this.getEmailAction().setResourceUri(resourceAttribute.getValue(), uri, mimeType);
        }
        return actionResource;
    }

    private String getUniqueResourceName() {
        String name = null;
        boolean isUnique = false;
        int i = 1;
        while (!isUnique) {
            name = ATTACHMENT_RESOURCE_PREFIX + i;
            isUnique = this.getEmailAction().getResource(name) == null;
            ++i;
        }
        return name;
    }

    private String getUniqueNameParam() {
        String name = null;
        boolean isUnique = false;
        EmailAction emailAction = this.getEmailAction();
        int i = 1;
        while (!isUnique) {
            name = ATTACHMENT_NAME_PREFIX + i;
            isUnique = emailAction.getInputParam(name) == null && emailAction.getComponentDefElement(name) == null;
            ++i;
        }
        return name;
    }

    boolean isDeprecatedAttachmentStyle() {
        return this.emailAction != null;
    }

    public IPentahoStreamSource getContent() throws IOException {
        ActionInput contentParam;
        IPentahoStreamSource dataSrc = null;
        IActionResource actionResource = null;
        Attribute attribute = this.getElement().attribute(ATTACHMENT_RESOURCE_ATTRIBUTE);
        if (attribute != null) {
            actionResource = this.getEmailAction().getResource(attribute.getValue().trim());
        }
        if (actionResource != null) {
            dataSrc = actionResource.getDataSource();
        } else if (this.actionInputProvider != null && (contentParam = this.getContentParam()) != null) {
            dataSrc = this.actionInputProvider.getDataSource(contentParam);
        }
        return dataSrc;
    }
}

