/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.net.URI;
import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class HQLConnectionAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.component.HQLLookupRule";
    public static final String PREPARED_COMPONENT_ELEMENT = "prepared_component";
    public static final String DEFAULT_CONNECTION_NAME = "shared_connection";
    public static final String PROPERTY = "property";
    public static final String CLASSNAMES = "classNames";
    public static final String HIBERNATE_CONFIG = "hibernateConfig";
    public static final String HQL_CONNECTION_TYPE = "hql-connection";
    public static final String TIMEOUT = "timeout";
    public static final String MAXROWS = "max_rows";
    protected static final String[] EXPECTED_INPUTS = new String[]{"classNames"};
    protected static final String[] EXPECTED_RESOURCES = new String[]{"hibernateConfig"};

    public HQLConnectionAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public HQLConnectionAction() {
        this(COMPONENT_NAME);
    }

    protected HQLConnectionAction(String componentName) {
        super(componentName);
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && HQLConnectionAction.hasComponentName(element, COMPONENT_NAME);
    }

    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.setOutputConnectionName(DEFAULT_CONNECTION_NAME);
    }

    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public String[] getReservedOutputNames() {
        return new String[]{PREPARED_COMPONENT_ELEMENT};
    }

    public String[] getReservedResourceNames() {
        return EXPECTED_RESOURCES;
    }

    public void setOutputConnectionName(String name) {
        this.setOutput(PREPARED_COMPONENT_ELEMENT, name, HQL_CONNECTION_TYPE);
    }

    public String getOutputConnectionName() {
        return this.getPublicOutputName(PREPARED_COMPONENT_ELEMENT);
    }

    public IActionOutput getOutputConnectionParam() {
        return this.getOutput(PREPARED_COMPONENT_ELEMENT);
    }

    public IActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(CLASSNAMES);
        if (validationError != null) {
            if (validationError.errorCode == 2) {
                validationError.errorMsg = "Database connection input parameter references unknown variable.";
                errors.add(validationError);
            } else if (validationError.errorCode == 3) {
                validationError.errorMsg = "Database connection input parameter is uninitialized.";
                errors.add(validationError);
            }
        }
        if ((validationError = this.validateInput(HIBERNATE_CONFIG)) != null) {
            if (validationError.errorCode == 2) {
                validationError.errorMsg = "Database connection input parameter references unknown variable.";
                errors.add(validationError);
            } else if (validationError.errorCode == 3) {
                validationError.errorMsg = "Database connection input parameter is uninitialized.";
                errors.add(validationError);
            }
        }
        if ((validationError = this.validateOutput(PREPARED_COMPONENT_ELEMENT)) != null) {
            if (validationError.errorCode == 4) {
                validationError.errorMsg = "Missing output connection name.";
            }
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    public void setClassNames(IActionInputSource value) {
        this.setActionInputValue(CLASSNAMES, value);
    }

    public IActionInput getClassNames() {
        return this.getInput(CLASSNAMES);
    }

    public IActionResource setHibernateConfig(URI uri, String mimeType) {
        return this.setResourceUri(HIBERNATE_CONFIG, uri, mimeType);
    }

    public IActionResource getHibernateConfigResource() {
        return this.getResource(HIBERNATE_CONFIG);
    }

    public void setQueryTimeout(IActionInputSource value) {
        this.setActionInputValue(TIMEOUT, value);
    }

    public IActionInput getQueryTimeout() {
        return this.getInput(TIMEOUT);
    }

    public void setMaxRows(IActionInputSource value) {
        this.setActionInputValue(MAXROWS, value);
    }

    public IActionInput getMaxRows() {
        return this.getInput(MAXROWS);
    }
}

