/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.net.URI;
import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class JasperReportAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.jasper.JasperReportsComponent";
    public static final String OUTPUT_TYPE_ELEMENT = "output-type";
    public static final String REPORT_OUTPUT_ELEMENT = "report-output";
    public static final String DRIVER_ELEMENT = "driver";
    public static final String CONNECTION_ELEMENT = "connection";
    public static final String USER_ID_ELEMENT = "user-id";
    public static final String PASSWORD_ELEMENT = "password";
    public static final String JNDI_ELEMENT = "jndi";
    public static final String REPORT_DEFINITION_ELEMENT = "report-definition";
    public static final String OUTPUT_REPORT = "output-report";
    public static final String[] EXPECTED_RESOURCES = new String[]{"report-definition"};
    protected static final String[] EXPECTED_INPUTS = new String[]{"output-type", "driver", "connection", "user-id", "password", "jndi"};

    public JasperReportAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public JasperReportAction() {
        super(COMPONENT_NAME);
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && JasperReportAction.hasComponentName(element, COMPONENT_NAME);
    }

    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.setComponentDefinition(OUTPUT_TYPE_ELEMENT, "html");
    }

    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public String[] getReservedOutputNames() {
        IActionOutput[] actionOutputs;
        String expectedOutput = REPORT_OUTPUT_ELEMENT;
        if (this.getOutput(expectedOutput) == null && (actionOutputs = this.getOutputs("content")).length > 0) {
            expectedOutput = actionOutputs[0].getName();
        }
        return new String[]{expectedOutput};
    }

    public String[] getReservedResourceNames() {
        return EXPECTED_RESOURCES;
    }

    public void setConnection(IActionInputSource value) {
        this.setActionInputValue(CONNECTION_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
        }
    }

    public IActionInput getConnection() {
        return this.getInput(CONNECTION_ELEMENT);
    }

    public void setUserId(IActionInputSource value) {
        this.setActionInputValue(USER_ID_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
        }
    }

    public IActionInput getUserId() {
        return this.getInput(USER_ID_ELEMENT);
    }

    public void setDriver(IActionInputSource value) {
        this.setActionInputValue(DRIVER_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
        }
    }

    public IActionInput getDriver() {
        return this.getInput(DRIVER_ELEMENT);
    }

    public void setPassword(IActionInputSource value) {
        this.setActionInputValue(PASSWORD_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
        }
    }

    public IActionInput getPassword() {
        return this.getInput(PASSWORD_ELEMENT);
    }

    public void setJndi(IActionInputSource value) {
        this.setActionInputValue(JNDI_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setDriver(null);
            this.setConnection(null);
            this.setUserId(null);
            this.setPassword(null);
        }
    }

    public IActionInput getJndi() {
        return this.getInput(JNDI_ELEMENT);
    }

    public void setOutputType(IActionInputSource value) {
        this.setActionInputValue(OUTPUT_TYPE_ELEMENT, value);
    }

    public IActionInput getOutputType() {
        return this.getInput(OUTPUT_TYPE_ELEMENT);
    }

    public void setOutputReport(String publicOutputName) {
        this.setOutput(REPORT_OUTPUT_ELEMENT, publicOutputName, "content");
        if (publicOutputName != null && publicOutputName.trim().length() > 0) {
            IActionOutput[] actionOutputs = this.getOutputs();
            for (int i = 0; i < actionOutputs.length; ++i) {
                if (!actionOutputs[i].getType().equals("content") || actionOutputs[i].getName().equals(REPORT_OUTPUT_ELEMENT)) continue;
                actionOutputs[i].delete();
            }
        }
    }

    public IActionOutput getOutputReport() {
        IActionOutput[] actionOutputs;
        String privateOutputName = REPORT_OUTPUT_ELEMENT;
        if (this.getOutput(privateOutputName) == null && (actionOutputs = this.getOutputs("content")).length > 0) {
            privateOutputName = actionOutputs[0].getName();
        }
        return this.getOutput(REPORT_OUTPUT_ELEMENT);
    }

    public IActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(DRIVER_ELEMENT);
        if (validationError == null) {
            validationError = this.validateInput(CONNECTION_ELEMENT);
            if (validationError != null) {
                switch (validationError.errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing database connection input parameter.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Database connection input parameter references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Database connection input parameter is uninitialized.";
                    }
                }
                errors.add(validationError);
            }
            if ((validationError = this.validateInput(USER_ID_ELEMENT)) != null) {
                switch (validationError.errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing database login input parameter.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Database login input parameter references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Database login input parameter is uninitialized.";
                    }
                }
                errors.add(validationError);
            }
        } else if (validationError.errorCode == 1) {
            validationError = this.validateInput(JNDI_ELEMENT);
            if (validationError != null) {
                switch (validationError.errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing database connection input parameter.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Database connection input parameter references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Database connection input parameter is uninitialized.";
                    }
                }
                errors.add(validationError);
            }
        } else if (validationError.errorCode == 2) {
            validationError.errorMsg = "Database driver input parameter references unknown variable.";
            errors.add(validationError);
        }
        if ((validationError = this.validateInput(OUTPUT_TYPE_ELEMENT)) != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing report format input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Report format input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Report format input parameter is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        if ((validationError = this.validateResource(REPORT_DEFINITION_ELEMENT)) != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing report definition input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Report definition input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Report definition input parameter is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    public IActionResource setReportDefinition(URI uri, String mimeType) {
        return this.setResourceUri(REPORT_DEFINITION_ELEMENT, uri, mimeType);
    }

    public IActionResource getReportDefinition() {
        return this.getResource(REPORT_DEFINITION_ELEMENT);
    }
}

