/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.net.URI;
import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.IActionSequenceDocument;
import org.pentaho.actionsequence.dom.IActionSequenceResource;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class KettleJobAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "KettleComponent";
    public static final String JOB_FILE_ELEMENT = "job-file";
    public static final String REPOSITORY_DIRECTORY = "directory";
    public static final String REPOSITORY_JOB = "job";
    public static final String LOGGING_LEVEL = "logging-level";
    public static final String KETTLE_LOGGING_LEVEL = "kettle-logging-level";
    public static final String EXECUTION_STATUS_OUTPUT_ELEMENT = "kettle-execution-status";
    public static final String EXECUTION_LOG_OUTPUT_ELEMENT = "kettle-execution-log";
    public static final String OUTPUT_EXECUTION_LOG = "output-execution-log";
    public static final String OUTPUT_EXECUTION_STATUS = "output-execution-status";
    public static final String[] LOGGING_LEVEL_VALUES = new String[]{"minimal", "basic", "detail", "error", "rowlevel", "debug", "none"};
    public static final String[] EXPECTED_RESOURCES = new String[]{"job-file"};
    protected static final String[] EXPECTED_INPUTS = new String[]{"directory", "job", "logging-level", "kettle-logging-level"};
    protected static final String[] EXPECTED_OUTPUTS = new String[]{"kettle-execution-status", "kettle-execution-log"};

    public KettleJobAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public KettleJobAction() {
        super(COMPONENT_NAME);
    }

    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.addResource(JOB_FILE_ELEMENT);
    }

    public static boolean accepts(Element element) {
        boolean result = false;
        if (ActionDefinition.accepts(element) && KettleJobAction.hasComponentName(element, COMPONENT_NAME)) {
            result = element.selectSingleNode("action-resources/job-file") != null || element.selectSingleNode("action-inputs/job") != null || element.selectSingleNode("component-definition/job") != null;
        }
        return result;
    }

    public String[] getReservedResourceNames() {
        return EXPECTED_RESOURCES;
    }

    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public void setJob(IActionInputSource value) {
        this.setActionInputValue(REPOSITORY_JOB, value);
    }

    public IActionInput getJob() {
        return this.getInput(REPOSITORY_JOB);
    }

    public void setDirectory(IActionInputSource value) {
        this.setActionInputValue(REPOSITORY_DIRECTORY, value);
    }

    public IActionInput getDirectory() {
        return this.getInput(REPOSITORY_DIRECTORY);
    }

    public void setOutputExecutionLog(String publicOutputName) {
        this.setOutput(EXECUTION_LOG_OUTPUT_ELEMENT, publicOutputName, "string");
    }

    public IActionOutput getOutputExecutionLog() {
        return this.getOutput(EXECUTION_LOG_OUTPUT_ELEMENT);
    }

    public void setOutputExecutionStatus(String publicOutputName) {
        this.setOutput(EXECUTION_STATUS_OUTPUT_ELEMENT, publicOutputName, "string");
    }

    public IActionOutput getOutputExecutionStatus() {
        return this.getOutput(EXECUTION_STATUS_OUTPUT_ELEMENT);
    }

    public ActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(REPOSITORY_DIRECTORY);
        if (validationError == null) {
            validationError = this.validateResource(JOB_FILE_ELEMENT);
            if (validationError != null) {
                switch (validationError.errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing job file location input parameter.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Job file location input parameter references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Job file location input parameter is uninitialized.";
                    }
                }
                errors.add(validationError);
            }
        } else if (validationError.errorCode == 1) {
            validationError = this.validateInput(JOB_FILE_ELEMENT);
            if (validationError != null) {
                switch (validationError.errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing job file location input parameter.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Job file location input parameter references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Job file location input parameter is uninitialized.";
                    }
                }
                errors.add(validationError);
            }
        } else if (validationError.errorCode == 2) {
            validationError.errorMsg = "Repository directory input parameter references unknown variable.";
            errors.add(validationError);
        } else if (validationError.errorCode == 3) {
            validationError.errorMsg = "Repository directory input parameter is uninitialized.";
            errors.add(validationError);
        } else {
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    public IActionResource setJobFile(URI uri, String mimeType) {
        IActionResource actionResource = null;
        if (uri == null) {
            actionResource = this.getResource(JOB_FILE_ELEMENT);
            if (actionResource != null) {
                IActionSequenceResource actionSequenceResource;
                IActionSequenceDocument actionSequenceDocument = this.getDocument();
                IActionResource[] actionResources = actionSequenceDocument.getReferencesTo(actionSequenceResource = actionSequenceDocument.getResource(actionResource.getPublicName()));
                if (actionResources.length == 1 && actionResources[0].equals(actionResource)) {
                    actionSequenceResource.delete();
                } else {
                    actionResource.setMapping("NULL_MAPPING");
                }
            }
            actionResource = null;
        } else {
            actionResource = this.setResourceUri(JOB_FILE_ELEMENT, uri, mimeType);
        }
        return actionResource;
    }

    public IActionResource getJobFile() {
        return this.getResource(JOB_FILE_ELEMENT);
    }

    public void setLoggingLevel(IActionInputSource value) {
        this.setActionInputValue(LOGGING_LEVEL, value);
    }

    public IActionInput getLoggingLevel() {
        return this.getInput(LOGGING_LEVEL);
    }

    public void setKettleLoggingLevel(IActionInputSource value) {
        this.setActionInputValue(KETTLE_LOGGING_LEVEL, value);
    }

    public IActionInput getKettleLoggingLevel() {
        return this.getInput(KETTLE_LOGGING_LEVEL);
    }
}

