/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class MdxConnectionAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.component.MDXLookupRule";
    public static final String CONNECTION_ELEMENT = "connection";
    public static final String CONNECTION_PROPS = "connection-properties";
    public static final String USER_ID_ELEMENT = "user-id";
    public static final String PASSWORD_ELEMENT = "password";
    public static final String DRIVER_ELEMENT = "driver";
    public static final String JNDI_ELEMENT = "jndi";
    public static final String LOCATION_ELEMENT = "location";
    public static final String MDX_CONNECTION_ELEMENT = "mdx-connection-string";
    public static final String CATALOG_ELEMENT = "catalog";
    public static final String CATALOG_RESOURCE = "catalog-resource";
    public static final String ROLE_ELEMENT = "role";
    public static final String PREPARED_COMPONENT_ELEMENT = "prepared_component";
    public static final String DEFAULT_CONNECTION_NAME = "shared_olap_connection";
    public static final String DEFAULT_LOCATION = "mondrian";
    public static final String OUTPUT_CONNECTION = "output-connection";
    public static final String PROPERTY = "property";
    public static final String KEY_NODE = "key";
    public static final String VALUE_NODE = "value";
    public static final String EXTENDED_COLUMN_NAMES_ELEMENT = "extended_column_names";
    protected static final String[] EXPECTED_INPUTS = new String[]{"location", "connection", "user-id", "password", "driver", "mdx-connection-string", "role", "jndi"};
    protected static final String[] EXPECTED_RESOURCES = new String[]{"catalog"};

    public MdxConnectionAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public MdxConnectionAction() {
        this(COMPONENT_NAME);
    }

    protected MdxConnectionAction(String componentName) {
        super(componentName);
    }

    public void setExtendedColumnNames(IActionInputSource value) {
        this.setActionInputValue(EXTENDED_COLUMN_NAMES_ELEMENT, value);
    }

    public IActionInput getExtendedColumnNames() {
        return this.getInput(EXTENDED_COLUMN_NAMES_ELEMENT);
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && MdxConnectionAction.hasComponentName(element, COMPONENT_NAME);
    }

    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.setJndi(new ActionInputConstant("", this.actionParameterMgr));
        this.setLocation(new ActionInputConstant(DEFAULT_LOCATION, this.actionParameterMgr));
        this.setOutputConnection(DEFAULT_CONNECTION_NAME);
    }

    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public String[] getReservedOutputNames() {
        return new String[]{PREPARED_COMPONENT_ELEMENT};
    }

    public String[] getReservedResourceNames() {
        return EXPECTED_RESOURCES;
    }

    public void setLocation(IActionInputSource value) {
        this.setActionInputValue(LOCATION_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setMdxConnectionString(null);
        }
    }

    public IActionInput getLocation() {
        return this.getInput(LOCATION_ELEMENT);
    }

    public void setUserId(IActionInputSource value) {
        this.setActionInputValue(USER_ID_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setMdxConnectionString(null);
            this.setJndi(null);
            this.setConnectionProps(null);
            this.setLocation(new ActionInputConstant(DEFAULT_LOCATION, this.actionParameterMgr));
        }
    }

    public IActionInput getUserId() {
        return this.getInput(USER_ID_ELEMENT);
    }

    public void setPassword(IActionInputSource value) {
        this.setActionInputValue(PASSWORD_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setMdxConnectionString(null);
            this.setJndi(null);
            this.setConnectionProps(null);
            this.setLocation(new ActionInputConstant(DEFAULT_LOCATION, this.actionParameterMgr));
        }
    }

    public IActionInput getPassword() {
        return this.getInput(PASSWORD_ELEMENT);
    }

    public void setDriver(IActionInputSource value) {
        this.setActionInputValue(DRIVER_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setMdxConnectionString(null);
            this.setJndi(null);
            this.setConnectionProps(null);
            this.setLocation(new ActionInputConstant(DEFAULT_LOCATION, this.actionParameterMgr));
        }
    }

    public IActionInput getDriver() {
        return this.getInput(DRIVER_ELEMENT);
    }

    public void setMdxConnectionString(IActionInputSource value) {
        this.setActionInputValue(MDX_CONNECTION_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
            this.setConnection(null);
            this.setConnectionProps(null);
            this.setLocation(null);
            this.setUserId(null);
            this.setPassword(null);
            this.setDriver(null);
            this.setRole(null);
        }
    }

    public IActionInput getMdxConnectionString() {
        return this.getInput(MDX_CONNECTION_ELEMENT);
    }

    public void setRole(IActionInputSource value) {
        this.setActionInputValue(ROLE_ELEMENT, value);
    }

    public IActionInput getRole() {
        return this.getInput(ROLE_ELEMENT);
    }

    public void setConnection(IActionInputSource value) {
        this.setActionInputValue(CONNECTION_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setJndi(null);
            this.setMdxConnectionString(null);
            this.setConnectionProps(null);
        }
    }

    public IActionInput getConnection() {
        return this.getInput(CONNECTION_ELEMENT);
    }

    public void setConnectionProps(IActionInputSource value) {
        if (value instanceof IActionInputVariable) {
            throw new IllegalArgumentException();
        }
        if (value == null || ((ActionInputConstant)value).getValue() == null) {
            this.clearComponentDef(CONNECTION_PROPS);
        } else {
            this.clearComponentDef(CONNECTION_PROPS);
            Properties properties = (Properties)((ActionInputConstant)value).getValue();
            Element compDefElement = (Element)this.actionDefElement.selectSingleNode("component-definition");
            Element connectionPropsElement = compDefElement.addElement(CONNECTION_PROPS);
            for (Map.Entry<Object, Object> mapEntry : properties.entrySet()) {
                Element propElement = connectionPropsElement.addElement(PROPERTY);
                propElement.addElement(KEY_NODE).setText(mapEntry.getKey().toString());
                propElement.addElement(VALUE_NODE).setText(mapEntry.getValue().toString());
            }
            this.setDriver(null);
            this.setUserId(null);
            this.setPassword(null);
            this.setJndi(null);
            this.setMdxConnectionString(null);
            this.setConnection(null);
        }
    }

    public IActionInput getConnectionProps() {
        ActionInputConstant actionInput = IActionInput.NULL_INPUT;
        Element connectionPropsElement = this.getComponentDefElement(CONNECTION_PROPS);
        if (connectionPropsElement != null) {
            Properties properties = new Properties();
            List propertyElements = connectionPropsElement.selectNodes(PROPERTY);
            for (Element propElement : propertyElements) {
                Element keyElement = propElement.element(KEY_NODE);
                Element valueElement = propElement.element(VALUE_NODE);
                if (keyElement == null) continue;
                properties.put(keyElement.getText(), valueElement != null ? valueElement.getText() : null);
            }
            actionInput = new ActionInputConstant(properties, this.actionParameterMgr);
        }
        return actionInput;
    }

    private void clearComponentDef(String key) {
        Element element = this.getComponentDefElement(key);
        if (element != null) {
            element.detach();
        }
    }

    public void setJndi(IActionInputSource value) {
        this.setActionInputValue(JNDI_ELEMENT, value);
        if (value instanceof IActionInputVariable || value != null && ((ActionInputConstant)value).getValue() != null) {
            this.setMdxConnectionString(null);
            this.setConnection(null);
            this.setUserId(null);
            this.setPassword(null);
            this.setDriver(null);
            this.setConnectionProps(null);
            this.setLocation(new ActionInputConstant(DEFAULT_LOCATION, this.actionParameterMgr));
        }
    }

    public IActionInput getJndi() {
        return this.getInput(JNDI_ELEMENT);
    }

    public void setOutputConnection(String publicOutputName) {
        this.setOutput(PREPARED_COMPONENT_ELEMENT, publicOutputName, "mdx-connection");
    }

    public IActionOutput getOutputConnection() {
        return this.getOutput(PREPARED_COMPONENT_ELEMENT);
    }

    public ActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(MDX_CONNECTION_ELEMENT);
        if (validationError != null) {
            if (validationError.errorCode == 2) {
                validationError.errorMsg = "Database connection input parameter references unknown variable.";
                errors.add(validationError);
            } else if (validationError.errorCode == 3) {
                validationError.errorMsg = "Database connection input parameter is uninitialized.";
                errors.add(validationError);
            } else if (validationError.errorCode == 1) {
                validationError = this.validateResource(CATALOG_ELEMENT);
                if (validationError != null) {
                    switch (validationError.errorCode) {
                        case 1: {
                            validationError.errorMsg = "Missing mondrian schema input parameter.";
                            break;
                        }
                        case 2: {
                            validationError.errorMsg = "Mondrian schema input parameter references unknown variable.";
                            break;
                        }
                        case 3: {
                            validationError.errorMsg = "Mondrian schema input parameter is uninitialized.";
                        }
                    }
                    errors.add(validationError);
                }
                validationError = this.validateInput(CONNECTION_ELEMENT);
                if (validationError.errorCode == 1) {
                    validationError = this.validateInput(JNDI_ELEMENT);
                    if (validationError != null) {
                        switch (validationError.errorCode) {
                            case 1: {
                                validationError.errorMsg = "Missing database connection input parameter.";
                                break;
                            }
                            case 2: {
                                validationError.errorMsg = "Database connection input parameter references unknown variable.";
                                break;
                            }
                            case 3: {
                                validationError.errorMsg = "Database connection input parameter in unitialized.";
                            }
                        }
                        errors.add(validationError);
                    }
                } else if (validationError.errorCode == 2) {
                    validationError.errorMsg = "Database connection input parameter references unknown variable.";
                    errors.add(validationError);
                } else if (validationError.errorCode == 3) {
                    validationError.errorMsg = "Database connection input parameter is uninitialized.";
                    errors.add(validationError);
                }
            }
        }
        if ((validationError = this.validateOutput(PREPARED_COMPONENT_ELEMENT)) != null) {
            if (validationError.errorCode == 4) {
                validationError.errorMsg = "Missing output connection name.";
            }
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    public IActionResource setCatalogResource(URI uri, String mimeType) {
        return this.setResourceUri(CATALOG_ELEMENT, uri, mimeType);
    }

    public IActionResource getCatalogResource() {
        return this.getResource(CATALOG_ELEMENT);
    }

    public void setCatalog(IActionInputSource value) {
        this.setActionInputValue(CATALOG_ELEMENT, value);
    }

    public IActionInput getCatalog() {
        return this.getInput(CATALOG_ELEMENT);
    }
}

