/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;
import org.pentaho.actionsequence.dom.actions.MdxConnectionAction;

public class MdxQueryAction
extends MdxConnectionAction {
    public static final String COMPONENT_NAME = "org.pentaho.component.MDXLookupRule";
    public static final String CONNECTION_ELEMENT = "connection";
    public static final String USER_ID_ELEMENT = "user-id";
    public static final String PASSWORD_ELEMENT = "password";
    public static final String JNDI_ELEMENT = "jndi";
    public static final String LOCATION_ELEMENT = "location";
    public static final String MDX_CONNECTION_ELEMENT = "mdx-connection-string";
    public static final String QUERY_ELEMENT = "query";
    public static final String QUERY_RESULTS_ELEMENT = "query-results";
    public static final String CATALOG_ELEMENT = "catalog";
    public static final String ROLE_ELEMENT = "role";
    public static final String PREPARED_COMPONENT_ELEMENT = "prepared_component";
    public static final String DEFAULT_QUERY_RESULTS_NAME = "query_result";
    public static final String MDX_CONNECTION = "mdx-connection";
    public static final String OUTPUT_RESULT_SET = "output-result-set";
    public static final String OUTPUT_PREPARED_STATEMENT = "output-prepared_statement";
    protected static final String[] EXPECTED_INPUTS = new String[]{"location", "connection", "user-id", "password", "mdx-connection-string", "role", "query", "jndi"};
    protected static final String[] EXPECTED_RESOURCES = new String[]{"catalog"};

    public MdxQueryAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public MdxQueryAction() {
        super(COMPONENT_NAME);
    }

    protected void initNewActionDefinition() {
        this.setJndi(new ActionInputConstant("", this.actionParameterMgr));
        this.setQuery(new ActionInputConstant("", this.actionParameterMgr));
        this.setLocation(new ActionInputConstant("mondrian", this.actionParameterMgr));
        this.setOutputResultSet(DEFAULT_QUERY_RESULTS_NAME);
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && MdxQueryAction.hasComponentName(element, COMPONENT_NAME) && (element.selectSingleNode("component-definition/query") != null || element.selectSingleNode("action-inputs/query") != null);
    }

    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public String[] getReservedOutputNames() {
        IActionOutput[] actionOutputs;
        String expectedOutput = QUERY_RESULTS_ELEMENT;
        if (this.getOutput(expectedOutput) == null && (actionOutputs = this.getOutputs("result-set")).length > 0) {
            expectedOutput = actionOutputs[0].getName();
        }
        return new String[]{expectedOutput};
    }

    public void setUserId(IActionInputSource value) {
        super.setUserId(value);
        if (value instanceof IActionInputVariable || value instanceof ActionInputConstant && ((ActionInputConstant)value).getValue() != null) {
            this.setMdxConnection(null);
        }
    }

    public void setPassword(IActionInputSource value) {
        super.setPassword(value);
        if (value instanceof IActionInputVariable || value instanceof ActionInputConstant && ((ActionInputConstant)value).getValue() != null) {
            this.setMdxConnection(null);
        }
    }

    public void setMdxConnectionString(IActionInputSource value) {
        super.setMdxConnectionString(value);
        if (value instanceof IActionInputVariable || value instanceof ActionInputConstant && ((ActionInputConstant)value).getValue() != null) {
            this.setMdxConnection(null);
        }
    }

    public void setConnection(IActionInputSource value) {
        super.setConnection(value);
        if (value instanceof IActionInputVariable || value instanceof ActionInputConstant && ((ActionInputConstant)value).getValue() != null) {
            this.setMdxConnection(null);
        }
    }

    public void setJndi(IActionInputSource value) {
        super.setJndi(value);
        if (value instanceof IActionInputVariable || value instanceof ActionInputConstant && ((ActionInputConstant)value).getValue() != null) {
            this.setMdxConnection(null);
        }
    }

    public void setQuery(IActionInputSource value) {
        this.setActionInputValue(QUERY_ELEMENT, value);
    }

    public IActionInput getQuery() {
        return this.getInput(QUERY_ELEMENT);
    }

    public void setOutputResultSet(String publicOutputName) {
        this.setOutput(QUERY_RESULTS_ELEMENT, publicOutputName, "result-set");
        if (publicOutputName != null && publicOutputName.trim().length() > 0) {
            this.setOutputPreparedStatement(null);
        }
    }

    public IActionOutput getOutputResultSet() {
        IActionOutput[] allOutputs;
        IActionOutput actionOutput = this.getOutput(QUERY_RESULTS_ELEMENT);
        if (actionOutput == null && (allOutputs = this.getOutputs()).length > 0) {
            actionOutput = allOutputs[0];
        }
        return actionOutput;
    }

    public void setOutputPreparedStatement(String publicOutputName) {
        this.setOutput(PREPARED_COMPONENT_ELEMENT, publicOutputName, "mdx-query");
        if (publicOutputName != null && publicOutputName.trim().length() > 0) {
            this.setOutputResultSet(null);
        }
    }

    public IActionOutput getOutputPreparedStatement() {
        return this.getOutput(PREPARED_COMPONENT_ELEMENT);
    }

    public void setMdxConnection(IActionInputVariable variable) {
        this.setActionInputValue(PREPARED_COMPONENT_ELEMENT, variable);
        if (variable != null) {
            this.setMdxConnectionString(null);
            this.setConnection(null);
            this.setUserId(null);
            this.setPassword(null);
            this.setJndi(null);
            this.setLocation(null);
        }
    }

    public IActionInput getMdxConnection() {
        return this.getInput(PREPARED_COMPONENT_ELEMENT);
    }

    public ActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(MDX_CONNECTION_ELEMENT);
        if (validationError != null) {
            if (validationError.errorCode == 2) {
                validationError.errorMsg = "Database connection input parameter references unknown variable.";
                errors.add(validationError);
            } else if (validationError.errorCode == 3) {
                validationError.errorMsg = "Database connection input parameter is uninitialized.";
                errors.add(validationError);
            } else if (validationError.errorCode == 1) {
                validationError = this.validateResource(CATALOG_ELEMENT);
                if (validationError != null) {
                    switch (validationError.errorCode) {
                        case 1: {
                            validationError.errorMsg = "Missing mondrian schema input parameter.";
                            break;
                        }
                        case 2: {
                            validationError.errorMsg = "Mondrian schema input parameter references unknown variable.";
                            break;
                        }
                        case 3: {
                            validationError.errorMsg = "Mondrian schema input parameter is uninitialized.";
                        }
                    }
                    errors.add(validationError);
                }
                validationError = this.validateInput(CONNECTION_ELEMENT);
                if (validationError.errorCode == 1) {
                    validationError = this.validateInput(JNDI_ELEMENT);
                    if (validationError.errorCode == 1) {
                        validationError = this.validateInput(PREPARED_COMPONENT_ELEMENT);
                        if (validationError != null) {
                            switch (validationError.errorCode) {
                                case 1: {
                                    validationError.errorMsg = "Missing database connection input parameter.";
                                    break;
                                }
                                case 2: {
                                    validationError.errorMsg = "Database connection input parameter references unknown variable.";
                                    break;
                                }
                                case 3: {
                                    validationError.errorMsg = "Database connection input parameter is uninitialized.";
                                }
                            }
                            errors.add(validationError);
                        }
                    } else if (validationError.errorCode == 2) {
                        validationError.errorMsg = "Database connection input parameter references unknown variable.";
                        errors.add(validationError);
                    } else if (validationError.errorCode == 3) {
                        validationError.errorMsg = "Database connection input parameter is uninitialized.";
                        errors.add(validationError);
                    }
                } else if (validationError.errorCode == 2) {
                    validationError.errorMsg = "Database connection input parameter references unknown variable.";
                    errors.add(validationError);
                } else if (validationError.errorCode == 3) {
                    validationError.errorMsg = "Database connection input parameter is uninitialized.";
                    errors.add(validationError);
                }
            }
        }
        if ((validationError = this.validateInput(QUERY_ELEMENT)) != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing query input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Query input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Query input parameter is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        if ((validationError = this.validateOutput(PREPARED_COMPONENT_ELEMENT)) != null && (validationError = this.validateOutput(QUERY_RESULTS_ELEMENT)) != null) {
            validationError.errorMsg = "Missing query results output parameter.";
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }
}

