/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInput;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionInputVariable;
import org.pentaho.actionsequence.dom.IActionSequenceElement;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class PrintParamAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.component.UtilityComponent";
    public static final String PRINT_PARAMS_COMMAND = "print";
    public static final String DELIMITER_ELEMENT = "delimiter";
    public static final String PRINT_PARAMS_XPATH = "print/arg";
    public static final String PRINT_PARAM_PREFIX = "printParam";

    public PrintParamAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public PrintParamAction() {
        super(COMPONENT_NAME);
    }

    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.setComponentDefinition(PRINT_PARAMS_COMMAND, "");
    }

    public static boolean accepts(Element element) {
        boolean accepts = false;
        if (ActionDefinition.accepts(element) && PrintParamAction.hasComponentName(element, COMPONENT_NAME)) {
            accepts = element.selectNodes("component-definition/print").size() == 1 && element.selectSingleNode("component-definition/format") == null && element.selectSingleNode("component-definition/getmapvalues") == null && element.selectSingleNode("component-definition/copy") == null;
        }
        return accepts;
    }

    public boolean accepts(IActionSequenceElement actionDef) {
        return actionDef instanceof PrintParamAction;
    }

    public void setDelimiter(ActionInputConstant value) {
        String delimiter;
        String string = delimiter = value != null ? value.getStringValue() : null;
        if (delimiter != null) {
            delimiter = "\"" + delimiter + "\"";
        }
        this.setComponentDefinition("print/delimiter", delimiter);
    }

    public ActionInputConstant getDelimiter() {
        ActionInputConstant actionInputConstant = IActionInput.NULL_INPUT;
        String delimiter = this.getComponentDefinitionValue("print/delimiter");
        if (delimiter != null) {
            if (delimiter.startsWith("\"") && delimiter.endsWith("\"")) {
                delimiter = delimiter.length() < 3 ? "" : delimiter.substring(1, delimiter.length() - 1);
            }
            actionInputConstant = new ActionInputConstant(delimiter, this.actionParameterMgr);
        }
        return actionInputConstant;
    }

    public IActionInput[] getInputsToPrint() {
        ArrayList<IActionInput> printParams = new ArrayList<IActionInput>();
        Element[] elements = this.getComponentDefElements(PRINT_PARAMS_XPATH);
        for (int i = 0; i < elements.length; ++i) {
            String printParamName = elements[i].getText();
            IActionInput key = this.getInput(printParamName);
            if (key == IActionInput.NULL_INPUT) continue;
            printParams.add(key);
        }
        return printParams.toArray(new IActionInput[0]);
    }

    public void addInputToPrint(IActionInputSource inputSource) {
        IActionInput[] oldPrintParams = this.getInputsToPrint();
        for (int i = 0; i < oldPrintParams.length; ++i) {
            if (!(oldPrintParams[i] instanceof ActionInput)) continue;
            ((ActionInput)oldPrintParams[i]).delete();
        }
        this.setComponentDefinition(PRINT_PARAMS_XPATH, new String[0]);
        ArrayList<String> printParamNames = new ArrayList<String>();
        for (int i = 0; i < oldPrintParams.length; ++i) {
            if (oldPrintParams[i] instanceof ActionInputConstant && oldPrintParams[i].getValue() != null) {
                String printParamName = this.getUniqueNameParam();
                printParamNames.add(printParamName);
                this.setActionInputValue(printParamName, (ActionInputConstant)oldPrintParams[i]);
                continue;
            }
            if (!(oldPrintParams[i] instanceof ActionInput)) continue;
            ActionInput actionInput = (ActionInput)oldPrintParams[i];
            printParamNames.add(actionInput.getName());
            this.setActionInputValue(actionInput.getName(), actionInput);
        }
        if (inputSource instanceof IActionInputVariable) {
            IActionInputVariable actionVariable = (IActionInputVariable)inputSource;
            printParamNames.add(actionVariable.getVariableName());
            this.setActionInputValue(actionVariable.getVariableName(), actionVariable);
        } else if (inputSource instanceof ActionInputConstant && ((ActionInputConstant)inputSource).getValue() != null) {
            String printParamName = this.getUniqueNameParam();
            printParamNames.add(printParamName);
            this.setActionInputValue(printParamName, (ActionInputConstant)inputSource);
        }
        if (printParamNames.size() > 0) {
            this.setComponentDefinition(PRINT_PARAMS_XPATH, printParamNames.toArray(new String[0]));
        }
    }

    public void setInputsToPrint(IActionInput[] values) {
        IActionInput[] oldPrintParams = this.getInputsToPrint();
        for (int i = 0; i < oldPrintParams.length; ++i) {
            if (!(oldPrintParams[i] instanceof ActionInput)) continue;
            ((ActionInput)oldPrintParams[i]).delete();
        }
        this.setComponentDefinition(PRINT_PARAMS_XPATH, new String[0]);
        ArrayList<String> printParamNames = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] instanceof IActionInputVariable) {
                IActionInputVariable actionVariable = (IActionInputVariable)((Object)values[i]);
                printParamNames.add(actionVariable.getVariableName());
                this.setActionInputValue(actionVariable.getVariableName(), actionVariable);
                continue;
            }
            if (values[i] instanceof ActionInputConstant && values[i].getValue() != null) {
                String printParamName = this.getUniqueNameParam();
                printParamNames.add(printParamName);
                this.setActionInputValue(printParamName, (ActionInputConstant)values[i]);
                continue;
            }
            if (!(values[i] instanceof ActionInput)) continue;
            ActionInput actionInput = (ActionInput)values[i];
            printParamNames.add(actionInput.getName());
            this.setActionInputValue(actionInput.getName(), actionInput);
        }
        if (printParamNames.size() > 0) {
            this.setComponentDefinition(PRINT_PARAMS_XPATH, printParamNames.toArray(new String[0]));
        }
    }

    private String getUniqueNameParam() {
        String name = null;
        boolean isUnique = false;
        int i = 1;
        while (!isUnique) {
            name = PRINT_PARAM_PREFIX + i;
            isUnique = this.getInputParam(name) == null && this.getComponentDefElement(name) == null;
            ++i;
        }
        return name;
    }
}

