/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.net.URI;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class PrinterAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.component.PrintComponent";
    public static final String PRINTER_NAME = "printer-name";
    public static final String COPIES_ELEMENT = "copies";
    public static final String PRINT_FILE = "printFile";
    public static final String FILE_TO_PRINT = "file-to-print";
    public static final String REPORT_OUTPUT = "report-output";
    public static final String DEFAULT_PRINTER = "default-printer";
    protected static final String[] EXPECTED_RESOURCES = new String[]{"printFile"};
    protected static final String[] EXPECTED_INPUTS = new String[]{"printer-name", "copies", "printFile"};

    public PrinterAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public PrinterAction() {
        super(COMPONENT_NAME);
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && PrinterAction.hasComponentName(element, COMPONENT_NAME);
    }

    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public String[] getReservedResourceNames() {
        return EXPECTED_RESOURCES;
    }

    public void setPrintfile(IActionInputSource value) {
        this.setActionInputValue(PRINT_FILE, value);
    }

    public IActionInput getPrintfile() {
        return this.getInput(PRINT_FILE);
    }

    public IActionResource setResourcesPrintFile(URI uri, String mimeType) {
        return this.setResourceUri(PRINT_FILE, uri, mimeType);
    }

    public IActionResource getResourcesPrintFile() {
        return this.getResource(PRINT_FILE);
    }

    public void setCopies(IActionInputSource value) {
        this.setActionInputValue(COPIES_ELEMENT, value);
    }

    public IActionInput getCopies() {
        return this.getInput(COPIES_ELEMENT);
    }

    public void setPrinterName(IActionInputSource value) {
        this.setActionInputValue(PRINTER_NAME, value);
    }

    public IActionInput getPrinterName() {
        return this.getInput(PRINTER_NAME);
    }

    public void setReportOutput(IActionInputSource value) {
        this.setActionInputValue(REPORT_OUTPUT, value);
    }

    public IActionInput getReportOutput() {
        return this.getInput(REPORT_OUTPUT);
    }

    public void setDefaultPrinter(IActionInputSource value) {
        this.setActionInputValue(DEFAULT_PRINTER, value);
    }

    public IActionInput getDefaultPrinter() {
        return this.getInput(DEFAULT_PRINTER);
    }

    public IActionResource setResourcesFileToPrint(URI uri, String mimeType) {
        return this.setResourceUri(FILE_TO_PRINT, uri, mimeType);
    }

    public IActionResource getResourcesFileToPrint() {
        return this.getResource(FILE_TO_PRINT);
    }

    public void setOutputPrinterName(String publicOutputName) {
        this.setOutput(PRINTER_NAME, publicOutputName, "string");
    }

    public IActionOutput getOutputPrinterName() {
        return this.getOutput(PRINTER_NAME);
    }

    public void setOutputDefaultPrinter(String publicOutputName) {
        this.setOutput(DEFAULT_PRINTER, publicOutputName, "string");
    }

    public IActionOutput getOutputDefaultPrinter() {
        return this.getOutput(DEFAULT_PRINTER);
    }
}

