/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.AbstractRelationalDbAction;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class SqlDataAction
extends AbstractRelationalDbAction {
    public static final String QUERY_RESULT_OUTPUT_NAME = "query-result";
    public static final String COMPONENT_NAME = "SQLDataComponent";
    public static final String DEFAULT_QUERY_RESULTS_NAME = "query_result";
    public static final String SQL_CONNECTION = "sql-connection";
    private static final String[] EXPECTED_OUTPUTS = new String[0];
    protected static final String[] EXPECTED_INPUTS = new String[]{"driver", "connection", "user-id", "password", "jndi", "query", "live"};

    public SqlDataAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public SqlDataAction() {
        super(COMPONENT_NAME);
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && SqlDataAction.hasComponentName(element, COMPONENT_NAME) && (element.selectSingleNode("component-definition/query") != null || element.selectSingleNode("action-inputs/query") != null);
    }

    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.setJndi(new ActionInputConstant("", this.actionParameterMgr));
        this.setQuery(new ActionInputConstant("", this.actionParameterMgr));
        this.setLive(new ActionInputConstant(true, this.actionParameterMgr));
    }

    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public String[] getReservedOutputNames() {
        return EXPECTED_OUTPUTS;
    }

    public IActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput("connection");
        if (validationError == null) {
            validationError = this.validateInput("driver");
            if (validationError != null) {
                switch (validationError.errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing database driver input parameter.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Database driver input parameter references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Database driver input parameter is uninitialized.";
                    }
                }
                errors.add(validationError);
            }
            if ((validationError = this.validateInput("user-id")) != null) {
                switch (validationError.errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing database login input parameter.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Database login input parameter references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Database login input parameter is uninitialized.";
                    }
                }
                errors.add(validationError);
            }
        } else if (validationError.errorCode == 1) {
            validationError = this.validateInput("jndi");
            if (validationError != null) {
                if (validationError.errorCode == 1) {
                    validationError = this.validateInput("prepared_component");
                    if (validationError != null) {
                        switch (validationError.errorCode) {
                            case 1: {
                                validationError.errorMsg = "Missing database connection input parameter.";
                                break;
                            }
                            case 2: {
                                validationError.errorMsg = "Database connection input parameter references unknown variable.";
                                break;
                            }
                            case 3: {
                                validationError.errorMsg = "Database connection input parameter is uninitialized.";
                            }
                        }
                        errors.add(validationError);
                    }
                } else if (validationError.errorCode == 2) {
                    validationError.errorMsg = "Database connection input parameter references unknown variable.";
                    errors.add(validationError);
                } else if (validationError.errorCode == 3) {
                    validationError.errorMsg = "Database connection input parameter is uninitialized.";
                    errors.add(validationError);
                }
            }
        } else if (validationError.errorCode == 2) {
            validationError.errorMsg = "Database connection input parameter references unknown variable.";
            errors.add(validationError);
        } else if (validationError.errorCode == 3) {
            validationError.errorMsg = "Database connection input parameter is uninitialized.";
            errors.add(validationError);
        } else {
            errors.add(validationError);
        }
        if ((validationError = this.validateInput("query")) != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing query input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Query input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Query input parameter is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    public String getQueryType() {
        return "sql-query";
    }
}

