/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.AbstractRelationalDbAction;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class SqlQueryAction
extends AbstractRelationalDbAction {
    public static final String QUERY_RESULT_OUTPUT_NAME = "query-result";
    public static final String COMPONENT_NAME = "org.pentaho.component.SQLLookupRule";
    public static final String DEFAULT_QUERY_RESULTS_NAME = "query_result";
    public static final String SQL_CONNECTION = "sql-connection";
    protected static final String[] EXPECTED_INPUTS = new String[]{"driver", "connection", "user-id", "password", "jndi", "query", "live"};

    public SqlQueryAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public SqlQueryAction() {
        super(COMPONENT_NAME);
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && SqlQueryAction.hasComponentName(element, COMPONENT_NAME) && (element.selectSingleNode("component-definition/query") != null || element.selectSingleNode("action-inputs/query") != null);
    }

    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.setJndi(new ActionInputConstant("", this.actionParameterMgr));
        this.setQuery(new ActionInputConstant("", this.actionParameterMgr));
        this.setOutputResultSet(DEFAULT_QUERY_RESULTS_NAME);
        this.setLive(new ActionInputConstant(true, this.actionParameterMgr));
    }

    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public String[] getReservedOutputNames() {
        IActionOutput[] actionOutputs;
        String expectedOutput = QUERY_RESULT_OUTPUT_NAME;
        String compDefVal = this.getComponentDefinitionValue("output-name");
        if (compDefVal != null) {
            expectedOutput = compDefVal;
        } else if (this.getOutput(expectedOutput) == null && (actionOutputs = this.getOutputs("result-set")).length > 0) {
            expectedOutput = actionOutputs[0].getName();
        }
        return new String[]{expectedOutput};
    }

    public IActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput("connection");
        if (validationError == null) {
            validationError = this.validateInput("driver");
            if (validationError != null) {
                switch (validationError.errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing database driver input parameter.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Database driver input parameter references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Database driver input parameter is uninitialized.";
                    }
                }
                errors.add(validationError);
            }
            if ((validationError = this.validateInput("user-id")) != null) {
                switch (validationError.errorCode) {
                    case 1: {
                        validationError.errorMsg = "Missing database login input parameter.";
                        break;
                    }
                    case 2: {
                        validationError.errorMsg = "Database login input parameter references unknown variable.";
                        break;
                    }
                    case 3: {
                        validationError.errorMsg = "Database login input parameter is uninitialized.";
                    }
                }
                errors.add(validationError);
            }
        } else if (validationError.errorCode == 1) {
            validationError = this.validateInput("jndi");
            if (validationError != null) {
                if (validationError.errorCode == 1) {
                    validationError = this.validateInput("prepared_component");
                    if (validationError != null) {
                        switch (validationError.errorCode) {
                            case 1: {
                                validationError.errorMsg = "Missing database connection input parameter.";
                                break;
                            }
                            case 2: {
                                validationError.errorMsg = "Database connection input parameter references unknown variable.";
                                break;
                            }
                            case 3: {
                                validationError.errorMsg = "Database connection input parameter is uninitialized.";
                            }
                        }
                        errors.add(validationError);
                    }
                } else if (validationError.errorCode == 2) {
                    validationError.errorMsg = "Database connection input parameter references unknown variable.";
                    errors.add(validationError);
                } else if (validationError.errorCode == 3) {
                    validationError.errorMsg = "Database connection input parameter is uninitialized.";
                    errors.add(validationError);
                }
            }
        } else if (validationError.errorCode == 2) {
            validationError.errorMsg = "Database connection input parameter references unknown variable.";
            errors.add(validationError);
        } else if (validationError.errorCode == 3) {
            validationError.errorMsg = "Database connection input parameter is uninitialized.";
            errors.add(validationError);
        } else {
            errors.add(validationError);
        }
        if (validationError != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing query input parameter.";
                    validationError = this.validateInput("query");
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Query input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Query input parameter is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        if ((validationError = this.validateOutput("prepared_component")) != null && (validationError = this.validateOutput(QUERY_RESULT_OUTPUT_NAME)) != null) {
            validationError.errorMsg = "Missing query results output parameter.";
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    public String getQueryType() {
        return "sql-query";
    }
}

