/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom.actions;

import java.net.URI;
import java.util.ArrayList;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.ActionSequenceValidationError;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionInputSource;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.IActionSequenceValidationError;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class XQueryAction
extends ActionDefinition {
    public static final String COMPONENT_NAME = "org.pentaho.component.XQueryLookupRule";
    public static final String DOCUMENT_ELEMENT = "document";
    public static final String QUERY_ELEMENT = "query";
    public static final String QUERY_RESULT_ELEMENT = "query-result";
    public static final String SOURCE_XML = "source-xml";
    public static final String PREPARED_COMPONENT_ELEMENT = "prepared_component";
    public static final String OUTPUT_RESULT_SET = "output-result-set";
    public static final String OUTPUT_PREPARED_STATEMENT = "output-prepared_statement";
    public static final String DEFAULT_QUERY_RESULTS_NAME = "query_result";
    public static final String XML_DOCUMENT = "xml-document";
    public static final String LIVE_CONNECTION_ELEMENT = "live";
    public static final String TIMEOUT = "timeout";
    public static final String MAXROWS = "max_rows";
    protected static final String[] EXPECTED_RESOURCES = new String[]{"document"};
    protected static final String[] EXPECTED_INPUTS = new String[]{"document", "query"};

    public XQueryAction(Element actionDefElement, IActionParameterMgr actionInputProvider) {
        super(actionDefElement, actionInputProvider);
    }

    public XQueryAction() {
        super(COMPONENT_NAME);
    }

    public static boolean accepts(Element element) {
        return ActionDefinition.accepts(element) && XQueryAction.hasComponentName(element, COMPONENT_NAME) && (element.selectSingleNode("component-definition/query") != null || element.selectSingleNode("action-inputs/query") != null);
    }

    public String[] getReservedInputNames() {
        return EXPECTED_INPUTS;
    }

    public String[] getReservedOutputNames() {
        IActionOutput[] actionOutputs;
        String expectedOutput = QUERY_RESULT_ELEMENT;
        if (this.getOutput(expectedOutput) == null && (actionOutputs = this.getOutputs("result-set")).length > 0) {
            expectedOutput = actionOutputs[0].getName();
        }
        return new String[]{expectedOutput};
    }

    public String[] getReservedResourceNames() {
        return EXPECTED_RESOURCES;
    }

    public void setSharedConnection(IActionInputSource value) {
        if (value instanceof ActionInputConstant) {
            throw new IllegalArgumentException();
        }
        this.setActionInputValue(PREPARED_COMPONENT_ELEMENT, value);
    }

    public IActionInput getSharedConnection() {
        return this.getInput(PREPARED_COMPONENT_ELEMENT);
    }

    public void setSourceXml(IActionInputSource value) {
        this.setActionInputValue(DOCUMENT_ELEMENT, value);
    }

    public IActionInput getSourceXml() {
        return this.getInput(DOCUMENT_ELEMENT);
    }

    public void setQuery(IActionInputSource value) {
        if (value == null || value instanceof ActionInputConstant && ((ActionInputConstant)value).getValue() == null) {
            value = new ActionInputConstant("", null);
        }
        this.setActionInputValue(QUERY_ELEMENT, value);
    }

    public IActionInput getQuery() {
        return this.getInput(QUERY_ELEMENT);
    }

    public void setLive(IActionInputSource value) {
        this.setActionInputValue(LIVE_CONNECTION_ELEMENT, value);
    }

    public IActionInput getLive() {
        return this.getInput(LIVE_CONNECTION_ELEMENT);
    }

    public void setOutputResultSet(String publicOutputName) {
        this.setOutput(QUERY_RESULT_ELEMENT, publicOutputName, "result-set");
        if (publicOutputName != null && publicOutputName.trim().length() > 0) {
            this.setOutputPreparedStatement(null);
        }
    }

    public IActionOutput getOutputResultSet() {
        IActionOutput actionOutput = this.getOutput(QUERY_RESULT_ELEMENT);
        if (actionOutput == null) {
            IActionOutput[] outputs = this.getOutputs();
            for (int i = 0; i < outputs.length; ++i) {
                if (outputs[i].getName().equals(PREPARED_COMPONENT_ELEMENT)) continue;
                actionOutput = outputs[i];
                break;
            }
        }
        return actionOutput;
    }

    public void setOutputPreparedStatement(String publicOutputName) {
        this.setOutput(PREPARED_COMPONENT_ELEMENT, publicOutputName, "xquery");
        if (publicOutputName != null && publicOutputName.trim().length() > 0) {
            this.setOutputResultSet(null);
            IActionOutput[] actionOutputs = this.getOutputs();
            for (int i = 0; i < actionOutputs.length; ++i) {
                if (actionOutputs[i].getType().equals("xquery")) continue;
                actionOutputs[i].delete();
            }
        }
    }

    public IActionOutput getOutputPreparedStatement() {
        return this.getOutput(PREPARED_COMPONENT_ELEMENT);
    }

    public IActionSequenceValidationError[] validate() {
        ArrayList<ActionSequenceValidationError> errors = new ArrayList<ActionSequenceValidationError>();
        ActionSequenceValidationError validationError = this.validateInput(DOCUMENT_ELEMENT);
        if (validationError != null) {
            if (validationError.errorCode == 1) {
                validationError = this.validateResource(DOCUMENT_ELEMENT);
                if (validationError != null) {
                    switch (validationError.errorCode) {
                        case 1: {
                            validationError.errorMsg = "Missing source XML input parameter.";
                            break;
                        }
                        case 2: {
                            validationError.errorMsg = "Source XML input parameter references unknown variable.";
                            break;
                        }
                        case 3: {
                            validationError.errorMsg = "Source XML input parameter is uninitialized.";
                        }
                    }
                    errors.add(validationError);
                }
            } else if (validationError.errorCode == 2) {
                validationError.errorMsg = "Source XML input parameter references unknown variable.";
                errors.add(validationError);
            } else if (validationError.errorCode == 3) {
                validationError.errorMsg = "Source XML input parameter is uninitialized.";
                errors.add(validationError);
            }
        }
        if ((validationError = this.validateInput(QUERY_ELEMENT)) != null) {
            switch (validationError.errorCode) {
                case 1: {
                    validationError.errorMsg = "Missing query input parameter.";
                    break;
                }
                case 2: {
                    validationError.errorMsg = "Query input parameter references unknown variable.";
                    break;
                }
                case 3: {
                    validationError.errorMsg = "Query input parameter is uninitialized.";
                }
            }
            errors.add(validationError);
        }
        if ((validationError = this.validateOutput(PREPARED_COMPONENT_ELEMENT)) != null && (validationError = this.validateOutput(QUERY_RESULT_ELEMENT)) != null) {
            validationError.errorMsg = "Missing query results output parameter.";
            errors.add(validationError);
        }
        return errors.toArray(new ActionSequenceValidationError[0]);
    }

    protected void initNewActionDefinition() {
        super.initNewActionDefinition();
        this.setQuery(new ActionInputConstant("", null));
        this.setOutputResultSet(DEFAULT_QUERY_RESULTS_NAME);
    }

    public IActionResource setXmlDocument(URI uri, String mimeType) {
        return this.setResourceUri(DOCUMENT_ELEMENT, uri, mimeType);
    }

    public IActionResource getXmlDocument() {
        return this.getResource(DOCUMENT_ELEMENT);
    }

    public void setQueryTimeout(IActionInputSource value) {
        this.setActionInputValue(TIMEOUT, value);
    }

    public IActionInput getQueryTimeout() {
        return this.getInput(TIMEOUT);
    }

    public void setMaxRows(IActionInputSource value) {
        this.setActionInputValue(MAXROWS, value);
    }

    public IActionInput getMaxRows() {
        return this.getInput(MAXROWS);
    }
}

