/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.hl7mllpin;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.MLLPTransport;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.steps.hl7input.common.MLLPSocketCache;
import org.pentaho.di.trans.steps.hl7input.common.MLLPSocketCacheEntry;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JobEntry(id="HL7MLLPInput", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.Utility", i18nPackageName="org.pentaho.di.job.entries.hl7mllpin", image="mllp-in.png", name="HL7MLLPInput.Name", description="HL7MLLPInput.TooltipDesc")
public class HL7MLLPInput
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = HL7MLLPInput.class;
    private String server;
    private String port;
    private String messageVariableName;
    private String messageTypeVariableName;
    private String versionVariableName;

    public HL7MLLPInput(String name) {
        super(name, "");
        this.setID(-1L);
        this.messageVariableName = "MESSAGE";
        this.messageTypeVariableName = "MESSAGE_TYPE";
        this.versionVariableName = "MESSAGE_VERSION";
    }

    public HL7MLLPInput() {
        this("");
    }

    public Object clone() {
        HL7MLLPInput je = (HL7MLLPInput)super.clone();
        return je;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(128);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"server", (String)this.server));
        retval.append("      ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XMLHandler.addTagValue((String)"message_variable", (String)this.messageVariableName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"type_variable", (String)this.messageTypeVariableName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"version_variable", (String)this.versionVariableName));
        return retval.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.server = XMLHandler.getTagValue((Node)entrynode, (String)"server");
            this.port = XMLHandler.getTagValue((Node)entrynode, (String)"port");
            this.messageVariableName = XMLHandler.getTagValue((Node)entrynode, (String)"message_variable");
            this.messageTypeVariableName = XMLHandler.getTagValue((Node)entrynode, (String)"type_variable");
            this.versionVariableName = XMLHandler.getTagValue((Node)entrynode, (String)"version_variable");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry from XML node", (Throwable)xe);
        }
    }

    public void loadRep(Repository rep, ObjectId idJobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, idJobentry, databases, slaveServers);
            this.server = rep.getJobEntryAttributeString(idJobentry, "server");
            this.port = rep.getJobEntryAttributeString(idJobentry, "port");
            this.messageVariableName = rep.getJobEntryAttributeString(idJobentry, "message_variable");
            this.messageTypeVariableName = rep.getJobEntryAttributeString(idJobentry, "type_variable");
            this.versionVariableName = rep.getJobEntryAttributeString(idJobentry, "version_variable");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry from the repository for id_jobentry=" + idJobentry, (Throwable)dbe);
        }
    }

    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "server", this.server);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "port", this.port);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "message_variable", this.messageVariableName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "type_variable", this.messageTypeVariableName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "version_variable", this.versionVariableName);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'ftp' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        try {
            MLLPTransport transport;
            String serverName = this.environmentSubstitute(this.server);
            int portNumber = Integer.parseInt(this.environmentSubstitute(this.port));
            String messageVariable = this.environmentSubstitute(this.messageVariableName);
            String messageTypeVariable = this.environmentSubstitute(this.messageTypeVariableName);
            String versionVariable = this.environmentSubstitute(this.versionVariableName);
            MLLPSocketCacheEntry entry = MLLPSocketCache.getInstance().getServerSocketStreamSource(serverName, portNumber);
            if (entry.getJobListener() != null) {
                this.parentJob.addJobListener(entry.getJobListener());
            }
            MLLPTransport mLLPTransport = transport = entry.getTransport();
            synchronized (mLLPTransport) {
                Transportable transportable = transport.doReceive();
                String message = transportable.getMessage();
                this.logDetailed("Received message: " + message);
                this.parentJob.setVariable(messageVariable, message);
                GenericParser parser = new GenericParser();
                NoValidation validationContext = new NoValidation();
                parser.setValidationContext((ValidationContext)validationContext);
                Message msg = parser.parse(message);
                Structure structure = msg.get("MSH");
                String messageType = null;
                String version = msg.getVersion();
                if (structure instanceof ca.uhn.hl7v2.model.v21.segment.MSH) {
                    messageType = ((ca.uhn.hl7v2.model.v21.segment.MSH)structure).getMESSAGETYPE().encode();
                } else if (structure instanceof ca.uhn.hl7v2.model.v22.segment.MSH) {
                    messageType = ((ca.uhn.hl7v2.model.v22.segment.MSH)structure).getMessageType().encode();
                } else if (structure instanceof ca.uhn.hl7v2.model.v23.segment.MSH) {
                    messageType = ((ca.uhn.hl7v2.model.v23.segment.MSH)structure).getMessageType().encode();
                } else if (structure instanceof MSH) {
                    messageType = ((MSH)structure).getMessageType().getMessageStructure().getValue();
                } else if (structure instanceof ca.uhn.hl7v2.model.v24.segment.MSH) {
                    messageType = ((ca.uhn.hl7v2.model.v24.segment.MSH)structure).getMessageType().getMessageStructure().getValue();
                } else if (structure instanceof ca.uhn.hl7v2.model.v25.segment.MSH) {
                    messageType = ((ca.uhn.hl7v2.model.v25.segment.MSH)structure).getMessageType().getMessageStructure().getValue();
                } else if (structure instanceof ca.uhn.hl7v2.model.v251.segment.MSH) {
                    messageType = ((ca.uhn.hl7v2.model.v251.segment.MSH)structure).getMessageType().getMessageStructure().getValue();
                } else if (structure instanceof ca.uhn.hl7v2.model.v26.segment.MSH) {
                    messageType = ((ca.uhn.hl7v2.model.v26.segment.MSH)structure).getMessageType().getMessageStructure().getValue();
                } else {
                    this.logError("This job entry does not support the HL7 dialect used. Found MSH class: " + structure.getClass().getName());
                }
                if (!Const.isEmpty((String)messageTypeVariable)) {
                    this.parentJob.setVariable(messageTypeVariable, messageType);
                }
                if (!Const.isEmpty((String)versionVariable)) {
                    this.parentJob.setVariable(versionVariable, version);
                }
            }
            result.setNrErrors(0L);
            result.setResult(true);
        }
        catch (Exception e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"HL7MLLPInput.Exception.UnexpectedError", (String[])new String[0]), (Throwable)e);
            result.setNrErrors(1L);
            result.setResult(false);
        }
        return result;
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getMessageVariableName() {
        return this.messageVariableName;
    }

    public void setMessageVariableName(String messageVariableName) {
        this.messageVariableName = messageVariableName;
    }

    public String getMessageTypeVariableName() {
        return this.messageTypeVariableName;
    }

    public void setMessageTypeVariableName(String messageTypeVariableName) {
        this.messageTypeVariableName = messageTypeVariableName;
    }

    public String getVersionVariableName() {
        return this.versionVariableName;
    }

    public void setVersionVariableName(String versionVariableName) {
        this.versionVariableName = versionVariableName;
    }
}

