/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.hl7input;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.hl7input.HL7InputData;
import org.pentaho.di.trans.steps.hl7input.HL7InputMeta;
import org.pentaho.di.trans.steps.hl7input.common.HL7KettleParser;
import org.pentaho.di.trans.steps.hl7input.common.HL7Value;

public class HL7Input
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = HL7InputMeta.class;
    private HL7InputMeta meta;
    private HL7InputData data;

    public HL7Input(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (HL7InputMeta)smi;
        this.data = (HL7InputData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.data.messageFieldIndex = this.getInputRowMeta().indexOfValue(this.meta.getMessageField());
            if (this.data.messageFieldIndex < 0) {
                throw new KettleException("Unable to find field [" + this.meta.getMessageField() + "] in the input fields.");
            }
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this);
            this.data.parser = new GenericParser();
            this.data.parser.setValidationContext((ValidationContext)new NoValidation());
        }
        String messageString = this.getInputRowMeta().getString(r, this.data.messageFieldIndex);
        try {
            Message message = this.data.parser.parse(messageString);
            List<HL7Value> values = HL7KettleParser.extractValues(message);
            for (HL7Value value : values) {
                Object[] output = RowDataUtil.createResizedCopy((Object[])r, (int)this.data.outputRowMeta.size());
                int outputIndex = this.getInputRowMeta().size();
                output[outputIndex++] = value.getParentGroup();
                output[outputIndex++] = value.getGroupName();
                output[outputIndex++] = value.getVersion();
                output[outputIndex++] = value.getStructureName();
                output[outputIndex++] = value.getStructureNumber();
                output[outputIndex++] = value.getFieldName();
                output[outputIndex++] = value.getCoordinate();
                output[outputIndex++] = value.getDataType();
                output[outputIndex++] = value.getDescription();
                output[outputIndex++] = value.getValue();
                this.putRow(this.data.outputRowMeta, output);
            }
        }
        catch (Exception e) {
            throw new KettleException("Error parsing message", (Throwable)e);
        }
        if (this.checkFeedback(this.getLinesWritten()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"HL7Input.Log.LineNumber", (String[])new String[0]) + this.getLinesWritten());
        }
        return true;
    }
}

