/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.uifoundation.component.xml.XmlComponent;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public abstract class AbstractChartComponent
extends XmlComponent {
    private static final long serialVersionUID = -3700747149855352376L;
    public static final String CHART_NODE_NAME = "chart";
    public static final String URLTEMPLATE_NODE_NAME = "url-template";
    public static final String PARAM2_NODE_NAME = "series-name";
    public static final int FILENAME_INDEX = 0;
    public static final int FILENAME_WITHOUT_EXTENSION_INDEX = 1;
    protected String definitionPath;
    protected int width = -1;
    protected int height = -1;
    protected String title;
    protected Object values;
    protected boolean byRow = true;
    protected String solution;
    protected String actionPath;
    protected String actionName;
    protected String actionOutput;
    protected String instanceId = null;
    protected IRuntimeContext context;
    protected String urlTemplate = null;
    protected List<String> outerParamNames = new ArrayList<String>();
    protected String paramName;
    protected static int chartCount = 0;
    protected static Log logger = null;

    protected AbstractChartComponent(String definitionPath, int width, int height, IPentahoUrlFactory urlFactory, List messages) {
        this(urlFactory, messages);
        this.definitionPath = definitionPath;
        this.width = width;
        this.height = height;
        ActionInfo info = ActionInfo.parseActionString((String)definitionPath);
        if (info != null) {
            this.setSourcePath(info.getSolutionName() + File.separator + info.getPath());
        }
    }

    protected AbstractChartComponent(String definitionPath, IPentahoUrlFactory urlFactory, ArrayList messages) {
        this(urlFactory, messages);
        this.definitionPath = definitionPath;
        ActionInfo info = ActionInfo.parseActionString((String)definitionPath);
        if (info != null) {
            this.setSourcePath(info.getSolutionName() + File.separator + info.getPath());
        }
    }

    protected AbstractChartComponent(IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages, null);
        this.setXsl("text/html", "Chart.xsl");
        logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    public abstract boolean setDataAction(String var1);

    public void setDataAction(String solution, String actionPath, String actionName, String actionOutput) {
        this.solution = solution;
        this.actionPath = actionPath;
        this.actionName = actionName;
        this.actionOutput = actionOutput;
    }

    public IPentahoResultSet getActionData() {
        ISolutionEngine solutionEngine = (ISolutionEngine)PentahoSystem.get(ISolutionEngine.class, (IPentahoSession)this.getSession());
        solutionEngine.setLoggingLevel(2);
        solutionEngine.init(this.getSession());
        HashMap parameterProviders = this.getParameterProviders();
        OutputStream outputStream = null;
        SimpleOutputHandler outputHandler = null;
        outputHandler = new SimpleOutputHandler(outputStream, false);
        ArrayList messages = new ArrayList();
        String processId = ((Object)((Object)this)).getClass().getName();
        this.context = solutionEngine.execute(this.solution, this.actionPath, this.actionName, processId, false, true, this.instanceId, false, (Map)parameterProviders, (IOutputHandler)outputHandler, null, this.urlFactory, messages);
        if (this.context == null) {
            return null;
        }
        if (this.actionOutput != null) {
            if (this.context.getOutputNames().contains(this.actionOutput)) {
                IActionParameter output = this.context.getOutputParameter(this.actionOutput);
                IPentahoResultSet results = output.getValueAsResultSet();
                if (results != null) {
                    results = results.memoryCopy();
                }
                return results;
            }
            return null;
        }
        for (Object objAp : this.context.getOutputNames()) {
            IActionParameter output = (IActionParameter)objAp;
            if (!output.getType().equalsIgnoreCase("resultset")) continue;
            IPentahoResultSet results = output.getValueAsResultSet();
            if (results != null) {
                results = results.memoryCopy();
            }
            return results;
        }
        return null;
    }

    public Log getLogger() {
        return logger;
    }

    protected String[] createTempFile() {
        String solutionDir = "system/tmp/";
        String fileNamePrefix = "tmp_chart_";
        String extension = ".png";
        String fileName = null;
        String filePathWithoutExtension = null;
        try {
            File file = PentahoSystem.getApplicationContext().createTempFile(this.getSession(), fileNamePrefix, extension, true);
            fileName = file.getName();
            filePathWithoutExtension = solutionDir + fileName.substring(0, fileName.indexOf(46));
        }
        catch (IOException e) {
            this.getLogger().error((Object)Messages.getErrorString("AbstractChartComponent.ERROR_0001_CANT_CREATE_TEMP_CHART"), (Throwable)e);
        }
        String[] value = new String[]{fileName, filePathWithoutExtension};
        return value;
    }

    protected void applyOuterURLTemplateParam() {
        if (this.outerParamNames == null) {
            return;
        }
        for (String outerParamName : this.outerParamNames) {
            Object value = null;
            if (this.context != null && this.context.getInputNames().contains(outerParamName)) {
                value = this.context.getInputParameterValue(outerParamName);
            }
            if (value == null) {
                return;
            }
            try {
                if (value.getClass().isArray()) {
                    if (Array.getLength(value) <= 0) continue;
                    String[] encodedVals = new String[Array.getLength(value)];
                    for (int i = 0; i < Array.getLength(value); ++i) {
                        encodedVals[i] = URLEncoder.encode(Array.get(value, i).toString(), LocaleHelper.getSystemEncoding());
                    }
                    this.urlTemplate = TemplateUtil.applyTemplate((String)this.urlTemplate, (String)outerParamName, (String[])encodedVals);
                    continue;
                }
                String encodedVal = URLEncoder.encode(value.toString(), LocaleHelper.getSystemEncoding());
                this.urlTemplate = TemplateUtil.applyTemplate((String)this.urlTemplate, (String)outerParamName, (String)encodedVal);
            }
            catch (UnsupportedEncodingException e) {
                this.getLogger().error((Object)Messages.getErrorString("AbstractChartComponent.ERROR_0002_URL_ENCODE_FAILED"), (Throwable)e);
            }
        }
    }

    public void dispose() {
        if (this.context != null) {
            this.context.dispose();
        }
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getActionOutput() {
        return this.actionOutput;
    }

    public void setActionOutput(String actionOutput) {
        this.actionOutput = actionOutput;
    }

    public String getActionPath() {
        return this.actionPath;
    }

    public void setActionPath(String actionPath) {
        this.actionPath = actionPath;
    }

    public IRuntimeContext getContext() {
        return this.context;
    }

    public void setContext(IRuntimeContext context) {
        this.context = context;
    }

    public String getDefinitionPath() {
        return this.definitionPath;
    }

    public void setDefinitionPath(String definitionPath) {
        this.definitionPath = definitionPath;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getSolution() {
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrlTemplate() {
        return this.urlTemplate;
    }

    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    public Object getValues() {
        return this.values;
    }

    public void setValues(Object values) {
        this.values = values;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setLogger(Log logger) {
        AbstractChartComponent.logger = logger;
    }

    public boolean isByRow() {
        return this.byRow;
    }

    public void setByRow(boolean byRow) {
        this.byRow = byRow;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public void addOuterParamName(String outerParamName) {
        this.outerParamNames.add(outerParamName);
    }
}

