/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.jfree.data.general.Dataset;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.SolutionURIResolver;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.uifoundation.chart.AbstractChartComponent;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

public abstract class AbstractJFreeChartComponent
extends AbstractChartComponent {
    private static final long serialVersionUID = 1244685089926020547L;
    private static final int DEFAULT_HEIGHT = 125;
    private static final int DEFAULT_WIDTH = 125;
    protected int chartType;
    protected Dataset dataDefinition;

    protected AbstractJFreeChartComponent(int chartType, String definitionPath, int width, int height, IPentahoUrlFactory urlFactory, List messages) {
        this(urlFactory, messages);
        this.chartType = chartType;
        this.definitionPath = definitionPath;
        this.width = width;
        this.height = height;
        ActionInfo info = ActionInfo.parseActionString((String)definitionPath);
        if (info != null) {
            this.setSourcePath(info.getSolutionName() + File.separator + info.getPath());
        }
    }

    protected AbstractJFreeChartComponent(String definitionPath, IPentahoUrlFactory urlFactory, ArrayList messages) {
        this(urlFactory, messages);
        this.definitionPath = definitionPath;
        ActionInfo info = ActionInfo.parseActionString((String)definitionPath);
        if (info != null) {
            this.setSourcePath(info.getSolutionName() + File.separator + info.getPath());
        }
    }

    protected AbstractJFreeChartComponent(IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages);
        AbstractChartComponent.logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    }

    public abstract Dataset createChart(Document var1);

    public Dataset getDataDefinitiont() {
        return this.dataDefinition;
    }

    public void setDataDefinition(Dataset dataSet) {
        this.dataDefinition = dataSet;
    }

    public int getChartType() {
        return this.chartType;
    }

    public void setChartType(int chartType) {
        this.chartType = chartType;
    }

    public boolean setDataAction(String chartDefinition) {
        ActionSequenceResource resource = new ActionSequenceResource("", 1, "text/xml", chartDefinition);
        try {
            Document dataActionDocument = AbstractJFreeChartComponent.getResourceAsDocument(this.getSession(), (IActionSequenceResource)resource);
            if (dataActionDocument == null) {
                return false;
            }
            Node dataNode = dataActionDocument.selectSingleNode("chart/data");
            if (dataNode == null) {
                return false;
            }
            this.chartType = (int)XmlDom4JHelper.getNodeText((String)"chart-type", (Node)dataNode, (long)-1L);
            this.solution = XmlDom4JHelper.getNodeText((String)"data-solution", (Node)dataNode);
            this.actionPath = XmlDom4JHelper.getNodeText((String)"data-path", (Node)dataNode);
            this.actionName = XmlDom4JHelper.getNodeText((String)"data-action", (Node)dataNode);
            this.actionOutput = XmlDom4JHelper.getNodeText((String)"data-output", (Node)dataNode);
            this.byRow = XmlDom4JHelper.getNodeText((String)"data-orientation", (Node)dataNode, (String)"rows").equals("rows");
            if (this.width == 0) {
                this.width = (int)XmlDom4JHelper.getNodeText((String)"chart/width", (Node)dataActionDocument, (long)125L);
            }
            if (this.height == 0) {
                this.height = (int)XmlDom4JHelper.getNodeText((String)"chart/height", (Node)dataActionDocument, (long)125L);
            }
        }
        catch (Exception e) {
            this.error(Messages.getString("CategoryDatasetChartComponent.ERROR_0001_INVALID_CHART_DEFINITION", chartDefinition), e);
            return false;
        }
        return true;
    }

    public static Document getResourceAsDocument(IPentahoSession userSession, IActionSequenceResource actionResource) throws IOException {
        byte[] xmlBytes = ((ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession)).getResourceAsBytes(actionResource, false, 1);
        if (xmlBytes == null) {
            return null;
        }
        try {
            return XmlDom4JHelper.getDocFromString((String)new String(xmlBytes), (EntityResolver)new SolutionURIResolver(userSession));
        }
        catch (XmlParseException xpe) {
            return null;
        }
    }
}

