/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.jfree.data.general.Dataset;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.uifoundation.chart.DialWidgetDefinition;
import org.pentaho.platform.uifoundation.chart.JFreeChartEngine;
import org.pentaho.platform.uifoundation.chart.WidgetDefinition;
import org.pentaho.platform.uifoundation.component.xml.XmlComponent;
import org.pentaho.platform.uifoundation.messages.Messages;

public class DashboardWidgetComponent
extends XmlComponent {
    private static final long serialVersionUID = 3060729271469984040L;
    public static final int TYPE_DIAL = 1;
    public static final int TYPE_THERMOMETER = 2;
    private static final Log logger = LogFactory.getLog(DashboardWidgetComponent.class);
    private int type;
    private double value = 1.0;
    private String definitionPath;
    private String title = "";
    private String units = "";
    private int width;
    private int height;

    public DashboardWidgetComponent(int type, String definitionPath, int width, int height, IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages, null);
        this.type = type;
        this.definitionPath = definitionPath;
        this.width = width;
        this.height = height;
        ActionInfo info = ActionInfo.parseActionString((String)definitionPath);
        if (info != null) {
            this.setSourcePath(info.getSolutionName() + File.separator + info.getPath());
        }
        this.setXsl("text/html", "DialWidget.xsl");
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public Log getLogger() {
        return logger;
    }

    public boolean validate() {
        return true;
    }

    public Document getXmlContent() {
        DialWidgetDefinition widget = null;
        if (this.type == 1) {
            ActionSequenceResource resource = new ActionSequenceResource(this.title, 1, "text/xml", this.definitionPath);
            Document dialDefinition = null;
            try {
                dialDefinition = ((ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession())).getResourceAsDocument((IActionSequenceResource)resource, 1);
            }
            catch (IOException e) {
                this.error(Messages.getErrorString("Widget.ERROR_0002_INVALID_RESOURCE", this.definitionPath), e);
            }
            if (dialDefinition == null) {
                this.error(Messages.getErrorString("Widget.ERROR_0002_INVALID_RESOURCE", this.definitionPath));
                return null;
            }
            widget = new DialWidgetDefinition(dialDefinition, 0.0, this.width, this.height, this.getSession());
            if (widget != null) {
                widget.setValue(new Double(this.value));
            } else {
                this.error(Messages.getString("Widget.ERROR_0001_COULD_NOT_CREATE"));
                return null;
            }
        }
        if (widget == null) {
            this.error(Messages.getString("Widget.ERROR_0001_COULD_NOT_CREATE"));
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String solutionDir = "system/tmp/";
        String fileNamePrefix = "tmp_pie_";
        String extension = ".png";
        String fileName = null;
        String filePathWithoutExtension = null;
        try {
            File file = PentahoSystem.getApplicationContext().createTempFile(this.getSession(), fileNamePrefix, extension, true);
            fileName = file.getName();
            filePathWithoutExtension = solutionDir + fileName.substring(0, fileName.indexOf(46));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String dialTitle = "";
        JFreeChartEngine.saveChart((Dataset)widget, dialTitle, this.units, filePathWithoutExtension, this.width, this.height, 1, printWriter, (ILogger)this);
        Document result = DocumentHelper.createDocument();
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        this.setXslProperty("baseUrl", requestContext.getContextPath());
        this.setXslProperty("fullyQualifiedServerUrl", PentahoSystem.getApplicationContext().getFullyQualifiedServerURL());
        Element root = result.addElement("widget");
        root.addElement("title").setText(this.title);
        root.addElement("units").setText(this.units);
        root.addElement("width").setText(Integer.toString(this.width));
        root.addElement("height").setText(Integer.toString(this.height));
        Element valueNode = root.addElement("value");
        valueNode.setText(Double.toString(this.value));
        valueNode.addAttribute("in-image", Boolean.toString(((WidgetDefinition)widget).getValueFont() != null));
        root.addElement("image").setText(fileName);
        return result;
    }

    public void dispose() {
    }
}

