/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.io.Serializable;
import java.util.Date;
import org.jfree.chart.imagemap.StandardURLTagFragmentGenerator;
import org.jfree.data.general.Dataset;
import org.jfree.data.xy.XYDataset;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.uifoundation.chart.CategoryDatasetChartDefinition;
import org.pentaho.platform.uifoundation.chart.XYZSeriesCollectionChartDefinition;

public class PentahoChartURLTagFragmentGenerator
extends StandardURLTagFragmentGenerator {
    private static final String SERIES_TAG = "series=";
    private static final String CATEGORY_TAG = "category=";
    private static final String ITEM_TAG = "item=";
    String urlFragment;
    Dataset dataset;
    String parameterName;
    String seriesName;
    String urlTarget;
    boolean useBaseUrl;
    IPentahoResultSet data;
    int i = 0;

    public PentahoChartURLTagFragmentGenerator(String urlFragment, Dataset dataset, String parameterName, String outerParameterName) {
        this.urlFragment = urlFragment;
        this.dataset = dataset;
        this.parameterName = parameterName;
        this.seriesName = outerParameterName;
        this.urlTarget = "pentaho_popup";
        this.useBaseUrl = true;
    }

    public PentahoChartURLTagFragmentGenerator(String urlFragment, String urlTarget, boolean useBaseUrl, Dataset dataset, String parameterName, String outerParameterName) {
        this.urlFragment = urlFragment;
        this.dataset = dataset;
        this.parameterName = parameterName;
        this.seriesName = outerParameterName;
        this.urlTarget = urlTarget;
        this.useBaseUrl = useBaseUrl;
    }

    public PentahoChartURLTagFragmentGenerator(String urlTemplate, Dataset dataDefinition, String paramName) {
        this(urlTemplate, dataDefinition, paramName, "");
    }

    public String generateURLFragment(String urlText) {
        if (this.urlFragment != null) {
            String urlTemplate = " href=\"";
            boolean isScript = this.urlFragment.startsWith("javascript:");
            if (!isScript && this.useBaseUrl) {
                urlTemplate = urlTemplate + PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
            }
            urlTemplate = urlTemplate + this.urlFragment.replaceAll("\"", "%22") + "\"";
            String value = null;
            String itemValue = null;
            value = this.retrieveValue(CATEGORY_TAG, urlText);
            if (value != null) {
                urlTemplate = TemplateUtil.applyTemplate((String)urlTemplate, (String)this.parameterName, (String)value);
            }
            if ((value = this.retrieveValue(SERIES_TAG, urlText)) != null) {
                if (this.dataset instanceof CategoryDatasetChartDefinition || this.dataset instanceof XYZSeriesCollectionChartDefinition) {
                    urlTemplate = TemplateUtil.applyTemplate((String)urlTemplate, (String)this.seriesName, (String)value);
                } else if (this.dataset instanceof XYDataset) {
                    XYDataset set = (XYDataset)this.dataset;
                    Comparable seriesKey = set.getSeriesKey(Integer.parseInt(value));
                    urlTemplate = TemplateUtil.applyTemplate((String)urlTemplate, (String)this.seriesName, (String)seriesKey.toString());
                    itemValue = this.retrieveValue(ITEM_TAG, urlText);
                    if (itemValue != null) {
                        int itemVal = Integer.parseInt(itemValue);
                        int val = Integer.parseInt(value);
                        Serializable x = null;
                        Number xNum = set.getX(val, itemVal);
                        x = xNum instanceof Long ? new Date((Long)xNum) : xNum;
                        urlTemplate = TemplateUtil.applyTemplate((String)urlTemplate, (String)this.parameterName, (String)x.toString());
                        Serializable y = null;
                        Number yNum = set.getY(val, itemVal);
                        y = yNum instanceof Long ? new Date((Long)yNum) : yNum;
                        urlTemplate = TemplateUtil.applyTemplate((String)urlTemplate, (String)"ITEM", (String)y.toString());
                    }
                }
            }
            if (!isScript) {
                urlTemplate = urlTemplate + " target=\"" + this.urlTarget + "\"";
            }
            return urlTemplate;
        }
        return super.generateURLFragment(urlText);
    }

    private String retrieveValue(String tag, String urlText) {
        String returnValue = null;
        if (urlText.contains(tag)) {
            int startIdx = urlText.indexOf(tag) + tag.length();
            int endIdx = urlText.indexOf(38, startIdx) != -1 ? urlText.indexOf(38, startIdx) : urlText.length();
            returnValue = urlText.substring(startIdx, endIdx).trim();
        }
        return returnValue;
    }
}

