/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.chart;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.imagemap.ImageMapUtilities;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.uifoundation.chart.AbstractChartComponent;
import org.pentaho.platform.uifoundation.chart.AbstractJFreeChartComponent;
import org.pentaho.platform.uifoundation.chart.JFreeChartEngine;
import org.pentaho.platform.uifoundation.chart.PieDatasetChartDefinition;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class PieDatasetChartComponent
extends AbstractJFreeChartComponent {
    private static final long serialVersionUID = -6268840271596447555L;
    protected String paramName2 = null;
    protected String dataAction = null;

    public PieDatasetChartComponent(int chartType, String definitionPath, int width, int height, IPentahoUrlFactory urlFactory, List messages) {
        super(chartType, definitionPath, width, height, urlFactory, messages);
        this.setXsl("text/html", "Chart.xsl");
    }

    public PieDatasetChartComponent(String definitionPath, IPentahoUrlFactory urlFactory, ArrayList messages) {
        super(definitionPath, urlFactory, messages);
        this.setXsl("text/html", "Chart.xsl");
    }

    public PieDatasetChartComponent(IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages);
        this.setXsl("text/html", "Chart.xsl");
    }

    public Dataset createChart(Document doc) {
        Node paramName2Node;
        if (this.solution != null) {
            this.values = this.getActionData();
        }
        if (this.values == null) {
            return null;
        }
        Node chartAttributes = doc.selectSingleNode("//chart");
        PieDatasetChartDefinition chartDefinition = new PieDatasetChartDefinition((IPentahoResultSet)this.values, this.byRow, chartAttributes, this.getSession());
        this.setTitle(chartDefinition.getTitle());
        Node urlTemplateNode = chartAttributes.selectSingleNode("url-template");
        if (urlTemplateNode != null) {
            this.setUrlTemplate(urlTemplateNode.getText());
        }
        if ((paramName2Node = chartAttributes.selectSingleNode("series-name")) != null) {
            this.paramName2 = paramName2Node.getText();
        }
        if (this.width == -1) {
            this.setWidth(chartDefinition.getWidth());
        }
        if (this.height == -1) {
            this.setHeight(chartDefinition.getHeight());
        }
        return chartDefinition;
    }

    public Document getXmlContent() {
        Document result = DocumentHelper.createDocument();
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        this.setXslProperty("baseUrl", requestContext.getContextPath());
        this.setXslProperty("fullyQualifiedServerUrl", PentahoSystem.getApplicationContext().getFullyQualifiedServerURL());
        ActionSequenceResource resource = new ActionSequenceResource(this.title, 1, "text/xml", this.definitionPath);
        Document chartDefinition = null;
        String mapName = "chart" + AbstractChartComponent.chartCount++;
        try {
            chartDefinition = AbstractJFreeChartComponent.getResourceAsDocument(this.getSession(), (IActionSequenceResource)resource);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (chartDefinition == null) {
            Element errorElement = result.addElement("error");
            errorElement.addElement("title").setText(Messages.getString("ABSTRACTCHARTEXPRESSION.ERROR_0001_ERROR_GENERATING_CHART"));
            String message = Messages.getString("CHARTS.ERROR_0001_CHART_DEFINIION_MISSING", this.definitionPath);
            errorElement.addElement("message").setText(message);
            this.error(message);
            return result;
        }
        this.dataDefinition = this.createChart(chartDefinition);
        if (this.dataDefinition == null) {
            Element errorElement = result.addElement("error");
            errorElement.addElement("title").setText(Messages.getString("ABSTRACTCHARTEXPRESSION.ERROR_0001_ERROR_GENERATING_CHART"));
            String message = Messages.getString("CHARTS.ERROR_0002_CHART_DATA_MISSING", this.solution + "/" + this.actionPath + "/" + this.actionName);
            errorElement.addElement("message").setText(message);
            return result;
        }
        PrintWriter printWriter = new PrintWriter(new StringWriter());
        String chartTitle = "";
        try {
            if (this.height == -1) {
                this.height = Integer.parseInt(chartDefinition.selectSingleNode("/chart/height").getText());
            }
            if (this.width == -1) {
                this.width = Integer.parseInt(chartDefinition.selectSingleNode("/chart/width").getText());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (chartDefinition.selectSingleNode("/chart/urlTemplate") != null) {
            this.urlTemplate = chartDefinition.selectSingleNode("/chart/urlTemplate").getText();
        }
        if (chartDefinition.selectSingleNode("/chart/paramName") != null) {
            this.paramName = chartDefinition.selectSingleNode("/chart/paramName").getText();
        }
        Element root = result.addElement("charts");
        DefaultPieDataset chartDataDefinition = (DefaultPieDataset)this.dataDefinition;
        String[] tempFileInfo = this.createTempFile();
        String fileName = tempFileInfo[0];
        String filePathWithoutExtension = tempFileInfo[1];
        ChartRenderingInfo info = new ChartRenderingInfo((EntityCollection)new StandardEntityCollection());
        JFreeChartEngine.saveChart((Dataset)chartDataDefinition, chartTitle, "", filePathWithoutExtension, this.width, this.height, 1, printWriter, info, (ILogger)this);
        this.applyOuterURLTemplateParam();
        this.populateInfo(info);
        Element chartElement = root.addElement("chart");
        chartElement.addElement("mapName").setText(mapName);
        chartElement.addElement("width").setText(Integer.toString(this.width));
        chartElement.addElement("height").setText(Integer.toString(this.height));
        String mapString = ImageMapUtilities.getImageMap((String)mapName, (ChartRenderingInfo)info);
        chartElement.addElement("imageMap").setText(mapString);
        chartElement.addElement("image").setText(fileName);
        return result;
    }

    private void populateInfo(ChartRenderingInfo info) {
        ArrayList keyListArray = null;
        int keyListIndex = 0;
        for (ChartEntity entity : info.getEntityCollection()) {
            String drillURL;
            String encodedVal;
            if (entity instanceof PieSectionEntity) {
                PieSectionEntity pieSectionEntity = (PieSectionEntity)entity;
                String value = pieSectionEntity.getSectionKey().toString();
                if (this.paramName == null) {
                    pieSectionEntity.setURLText(value);
                    continue;
                }
                try {
                    encodedVal = URLEncoder.encode(value, LocaleHelper.getSystemEncoding());
                    drillURL = TemplateUtil.applyTemplate((String)this.urlTemplate, (String)this.paramName, (String)encodedVal);
                    pieSectionEntity.setURLText(drillURL);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!(entity instanceof CategoryItemEntity)) continue;
            CategoryItemEntity categoryItemEntity = (CategoryItemEntity)entity;
            if (keyListArray == null) {
                keyListArray = new ArrayList(categoryItemEntity.getDataset().getRowKeys());
            }
            String category = categoryItemEntity.getCategory().toString();
            if (this.paramName == null) {
                categoryItemEntity.setURLText(category);
                continue;
            }
            try {
                encodedVal = URLEncoder.encode(category, LocaleHelper.getSystemEncoding());
                drillURL = TemplateUtil.applyTemplate((String)this.urlTemplate, (String)this.paramName, (String)encodedVal);
                if (keyListIndex >= keyListArray.size()) {
                    keyListIndex = 0;
                }
                encodedVal = URLEncoder.encode(keyListArray.get(keyListIndex).toString(), LocaleHelper.getSystemEncoding());
                ++keyListIndex;
                drillURL = TemplateUtil.applyTemplate((String)drillURL, (String)this.paramName2, (String)encodedVal);
                categoryItemEntity.setURLText(drillURL);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean validate() {
        return false;
    }
}

