/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.uifoundation.component.BaseUIComponent;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class ActionComponent
extends BaseUIComponent {
    private static final long serialVersionUID = 1217363866006312765L;
    private static final Log logger = LogFactory.getLog(ActionComponent.class);
    private String solutionName;
    private String actionPath;
    private String actionName;
    private String instanceId;
    private int outputPreference;

    public ActionComponent(String solutionName, String actionPath, String actionName, String instanceId, int outputPreference, IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages, solutionName + File.separator + actionPath);
        this.solutionName = solutionName;
        this.actionName = actionName;
        this.actionPath = actionPath;
        this.instanceId = instanceId;
        this.outputPreference = outputPreference;
    }

    public ActionComponent(String actionString, String instanceId, int outputPreference, IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages, null);
        ActionInfo info = ActionInfo.parseActionString((String)actionString);
        if (info != null) {
            this.solutionName = info.getSolutionName();
            this.actionPath = info.getPath();
            this.actionName = info.getActionName();
        }
        this.setSourcePath(this.solutionName + File.separator + this.actionPath);
        this.instanceId = instanceId;
        this.outputPreference = outputPreference;
    }

    public Log getLogger() {
        return logger;
    }

    public boolean validate() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteArrayOutputStream getContentAsStream(String mimeType) {
        IPentahoSession userSession = this.getSession();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SimpleOutputHandler outputHandler = new SimpleOutputHandler((OutputStream)outputStream, true);
        outputHandler.setOutputPreference(this.outputPreference);
        ISolutionEngine solutionEngine = (ISolutionEngine)PentahoSystem.get(ISolutionEngine.class, (IPentahoSession)this.getSession());
        solutionEngine.setLoggingLevel(this.getLoggingLevel());
        solutionEngine.init(userSession);
        IRuntimeContext context = null;
        try {
            context = solutionEngine.execute(this.solutionName, this.actionPath, this.actionName, Messages.getString("BaseTest.DEBUG_JUNIT_TEST"), false, true, this.instanceId, false, (Map)this.getParameterProviders(), (IOutputHandler)outputHandler, null, this.urlFactory, this.getMessages());
        }
        finally {
            if (context != null) {
                context.dispose();
            }
        }
        return outputStream;
    }

    public String getContent(String mimeType) {
        ByteArrayOutputStream outputStream = this.getContentAsStream(mimeType);
        String result = "";
        try {
            result = outputStream.toString(LocaleHelper.getSystemEncoding());
        }
        catch (Exception e) {
            return outputStream.toString();
        }
        return result;
    }
}

