/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.uifoundation.component.BaseUIComponent;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.web.HttpUtil;

public class HtmlComponent
extends BaseUIComponent {
    private static final long serialVersionUID = -7404173000559758744L;
    public static final int TYPE_URL = 1;
    public static final int TYPE_SOLUTION_FILE = 2;
    private String location;
    private String errorMessage;
    private int type;
    private static final Log logger = LogFactory.getLog(HtmlComponent.class);

    public Log getLogger() {
        return logger;
    }

    public HtmlComponent(int type, String location, String errorMessage, IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages, null);
        this.type = type;
        this.location = location;
        this.errorMessage = errorMessage;
    }

    public boolean validate() {
        return true;
    }

    public String getContent(String mimeType) {
        if ("text/html".equals(mimeType)) {
            if (this.type == 1) {
                return this.getUrl(this.location);
            }
            if (this.type == 2) {
                return this.getFile(this.location);
            }
        }
        return null;
    }

    private String getFile(String solutionPath) {
        ActionSequenceResource resource = new ActionSequenceResource("", 1, "text/html", solutionPath);
        try {
            return ((ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession())).getResourceAsString((IActionSequenceResource)resource, 1);
        }
        catch (Exception e) {
            if (this.errorMessage != null) {
                return this.errorMessage;
            }
            this.error(Messages.getErrorString("Html.ERROR_0001_COULD_NOT_GET_CONTENT", solutionPath));
            return Messages.getErrorString("Html.ERROR_0001_COULD_NOT_GET_CONTENT", solutionPath);
        }
    }

    private String getUrl(String url) {
        StringBuffer content = new StringBuffer();
        try {
            if (this.getSession() != null && this.getSession().getAttribute("pentaho-HtmlComponent-failed-url-" + url) != null) {
                return this.errorMessage;
            }
            this.debug(Messages.getString("Html.DEBUG_GETTING_CONTENT", url));
            if (HttpUtil.getURLContent((String)url, (StringBuffer)content)) {
                return content.toString();
            }
            this.getSession().setAttribute("pentaho-HtmlComponent-failed-url-" + url, (Object)"");
            return this.errorMessage;
        }
        catch (Exception e) {
            if (this.errorMessage != null) {
                return this.errorMessage;
            }
            this.error(Messages.getErrorString("Html.ERROR_0001_COULD_NOT_GET_CONTENT", url));
            return Messages.getErrorString("Html.ERROR_0001_COULD_NOT_GET_CONTENT", url);
        }
    }
}

