/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component.xml;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.ui.UIException;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.uifoundation.component.xml.FilterPanel;
import org.pentaho.platform.uifoundation.component.xml.FilterPanelException;
import org.pentaho.platform.uifoundation.component.xml.XmlComponent;
import org.pentaho.platform.uifoundation.messages.Messages;

public class FilterPanelComponent
extends XmlComponent {
    private static final Log log = LogFactory.getLog(FilterPanelComponent.class);
    private static final long serialVersionUID = 700681534058825526L;
    private static final Log logger = LogFactory.getLog(FilterPanelComponent.class);
    private String definitionPath;
    private FilterPanel filterPanel;
    private String xslName;
    private Map defaultValues;

    public FilterPanelComponent(String definitionPath, String xslName, IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages, null);
        ActionInfo info;
        this.definitionPath = definitionPath;
        if (xslName == null) {
            xslName = "FilterPanelDefault.xsl";
        }
        if ((info = ActionInfo.parseActionString((String)definitionPath)) != null) {
            this.setSourcePath(info.getSolutionName() + File.separator + info.getPath());
        }
        this.xslName = xslName;
        this.defaultValues = new HashMap();
    }

    public void setDefaultValue(String filterName, String[] defaultValue) {
        this.defaultValues.put(filterName, defaultValue);
    }

    public Log getLogger() {
        return logger;
    }

    public boolean validate() {
        return true;
    }

    public List getFilters() {
        return this.filterPanel.getFilters();
    }

    public boolean init() {
        if (this.filterPanel == null) {
            ActionSequenceResource resource = new ActionSequenceResource("", 1, "text/xml", this.definitionPath);
            Document filterDocument = null;
            try {
                filterDocument = ((ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession())).getResourceAsDocument((IActionSequenceResource)resource, 1);
            }
            catch (IOException e) {
                logger.error((Object)Messages.getString("FilterPanelComponent.ERROR_0002_CREATE_XML"), (Throwable)e);
                return false;
            }
            try {
                this.filterPanel = this.getFilterPanel(filterDocument);
            }
            catch (FilterPanelException e) {
                logger.error((Object)Messages.getString("FilterPanelComponent.ERROR_0003_CREATE"), (Throwable)((Object)e));
                return false;
            }
        }
        return true;
    }

    public Document getXmlContent() {
        boolean ok = this.filterPanel.populate(this.getParameterProviders(), this.defaultValues);
        if (!ok) {
            String msg = Messages.getString("FilterPanelComponent.ERROR_0001_POPULATE");
            log.error((Object)msg);
            throw new UIException(msg);
        }
        String actionUrl = this.urlFactory.getActionUrlBuilder().getUrl();
        Document xForm = this.filterPanel.getXForm(actionUrl);
        this.setXsl("text/html", this.xslName);
        return xForm;
    }

    private FilterPanel getFilterPanel(Document filterDocument) throws FilterPanelException {
        FilterPanel newFilterPanel = new FilterPanel(this.getSession(), filterDocument, (ILogger)this);
        return newFilterPanel;
    }
}

