/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component.xml;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.solution.dbbased.DbBasedSolutionRepository;
import org.pentaho.platform.uifoundation.component.xml.XmlComponent;
import org.pentaho.platform.uifoundation.messages.Messages;

public class LoadDBRepositoryUIComponent
extends XmlComponent {
    private static final String PATH_STR = "path";
    private static final String ROOT = "root";
    private static final String RESULT = "result";
    private static final String TYPE_ATTRIBUTE = "result-type";
    private static final String SUCCESS = "success";
    private static final String FAILURE = "failed";
    private static final String SHOW_INPUT = "show-input";
    private static final String ORPHANED = "orphaned-files";
    private static final String FILENAME = "file-name";
    private static final String ORPHANHANDLING = "orphan-handling";
    private static final String PATHTITLE = "path-title";
    private static final String DELETETITLE = "delete-title";
    IPentahoSession session = null;
    private static final Log logger = LogFactory.getLog(LoadDBRepositoryUIComponent.class);
    private static final long serialVersionUID = 1L;

    public LoadDBRepositoryUIComponent(IPentahoUrlFactory urlFactory, List messages, IPentahoSession session) {
        super(urlFactory, messages, null);
        this.session = session;
        this.setXsl("text/html", "LoadDBRepository.xsl");
        this.setXslProperty("baseUrl", urlFactory.getDisplayUrlBuilder().getUrl());
    }

    private Document doLoad(String solutionRoot, boolean deleteOrphans) {
        Document document = DocumentHelper.createDocument();
        document.setName(PATH_STR);
        Element root = document.addElement(ROOT);
        Element result = root.addElement(RESULT);
        boolean usingDbRepository = true;
        try {
            ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.session);
            if (!(repository instanceof DbBasedSolutionRepository)) {
                usingDbRepository = false;
                repository = new DbBasedSolutionRepository();
            }
            List orphanedFiles = ((DbBasedSolutionRepository)repository).loadSolutionFromFileSystem(this.session, solutionRoot, deleteOrphans);
            result.addAttribute(TYPE_ATTRIBUTE, SUCCESS);
            if (usingDbRepository) {
                result.addText(Messages.getString("LoadDBRepositoryUIComponent.INFO_0001_SUCCESS"));
            } else {
                result.addText(Messages.getString("LoadDBRepositoryUIComponent.INFO_0002_SUCCESS_NEED_CONFIG"));
            }
            if (orphanedFiles != null && orphanedFiles.size() > 0) {
                Iterator iter = orphanedFiles.iterator();
                Element orphans = result.addElement(ORPHANED);
                orphans.addElement(ORPHANHANDLING).addText(deleteOrphans ? Messages.getString("LoadDBRepositoryUIComponent.INFO_0004_ORPHANED_DELETED") : Messages.getString("LoadDBRepositoryUIComponent.INFO_0005_ORPHANED_IGNORED"));
                while (iter.hasNext()) {
                    orphans.addElement(FILENAME).addText((String)iter.next());
                }
            }
        }
        catch (Exception e) {
            result.addAttribute(TYPE_ATTRIBUTE, FAILURE);
            result.addText(Messages.getString("LoadDBRepositoryUIComponent.ERROR_0001_LOAD_ERROR") + solutionRoot);
            e.printStackTrace();
        }
        return document;
    }

    protected Document showInputPage() {
        Document document = DocumentHelper.createDocument();
        document.setName(PATH_STR);
        Element root = document.addElement(RESULT);
        root.addAttribute(TYPE_ATTRIBUTE, SHOW_INPUT);
        root.addElement(PATHTITLE).addText(Messages.getString("LoadDBRepositoryUIComponent.INFO_0003_ENTER_PATH"));
        root.addElement(DELETETITLE).addText(Messages.getString("LoadDBRepositoryUIComponent.INFO_0006_DELETE_ORPHANS_TITLE"));
        return document;
    }

    public Document getXmlContent() {
        String solutionRoot = this.getParameter(PATH_STR, null);
        if (solutionRoot == null || solutionRoot.length() < 1) {
            return this.showInputPage();
        }
        boolean deleteOrphans = "on".equalsIgnoreCase(this.getParameter("delete", "off"));
        return this.doLoad(solutionRoot, deleteOrphans);
    }

    public Log getLogger() {
        return logger;
    }

    public boolean validate() {
        return true;
    }
}

