/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component.xml;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.ui.INavigationComponent;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.uifoundation.component.xml.XmlComponent;
import org.pentaho.platform.uifoundation.messages.Messages;

public class NavigationComponent
extends XmlComponent
implements INavigationComponent {
    private static final long serialVersionUID = 851537694797388747L;
    private static final Log logger = LogFactory.getLog(NavigationComponent.class);

    public Log getLogger() {
        return logger;
    }

    public NavigationComponent() {
        super(null, null, null);
        SimpleParameterProvider parameters = new SimpleParameterProvider();
        this.setParameterProvider("options", (IParameterProvider)parameters);
    }

    public boolean validate() {
        return true;
    }

    public Document getXmlContent() {
        ISolutionRepository repository;
        String hrefUrl = this.getParameter("hrefurl", "");
        String onClick = this.getParameter("onclick", "");
        String solutionParamName = this.getParameter("solutionparam", "");
        String pathParamName = this.getParameter("pathparam", "");
        String options = this.getParameter("options", "");
        String path = this.getParameter(pathParamName, null);
        String allowNavigation = this.getParameter("navigate", "true");
        this.setXslProperty("href", hrefUrl);
        this.setXslProperty("onClick", onClick);
        this.setXslProperty("solutionParam", solutionParamName);
        this.setXslProperty("pathParam", pathParamName);
        this.setXslProperty("options", options);
        this.setXslProperty("navigate", allowNavigation);
        this.setXslProperty("baseUrl", this.urlFactory.getDisplayUrlBuilder().getUrl());
        if ("".equals(path)) {
            path = null;
        }
        if (path != null) {
            this.setXslProperty("path", path);
        }
        if ((repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession())) == null) {
            this.error(Messages.getErrorString("NavigationComponent.ERROR_0001_BAD_SOLUTION_REPOSITORY"));
            return null;
        }
        String solution = this.getParameter(solutionParamName, null);
        if ("".equals(solution)) {
            solution = null;
        }
        Document document = repository.getNavigationUIDocument(solution, path, 1);
        String startingXSLName = this.getXsl("text/html");
        String xslName = repository.getXSLName(document, solution, startingXSLName);
        this.setXslProperty("solution", solution);
        if (xslName == null) {
            xslName = "files-list.xsl";
        }
        this.setXsl("text/html", xslName);
        return document;
    }

    public void setHrefUrl(String hrefUrl) {
        SimpleParameterProvider parameters = (SimpleParameterProvider)this.getParameterProviders().get("options");
        parameters.setParameter("hrefurl", hrefUrl);
    }

    public void setOnClick(String onClick) {
        SimpleParameterProvider parameters = (SimpleParameterProvider)this.getParameterProviders().get("options");
        parameters.setParameter("onClick", onClick);
    }

    public void setAllowNavigation(Boolean allowNavigation) {
        SimpleParameterProvider parameters = (SimpleParameterProvider)this.getParameterProviders().get("options");
        parameters.setParameter("navigate", allowNavigation.toString());
    }

    public void setSolutionParamName(String solutionParamName) {
        SimpleParameterProvider parameters = (SimpleParameterProvider)this.getParameterProviders().get("options");
        parameters.setParameter("solutionparam", solutionParamName);
    }

    public void setPathParamName(String solutionPathName) {
        SimpleParameterProvider parameters = (SimpleParameterProvider)this.getParameterProviders().get("options");
        parameters.setParameter("pathparam", solutionPathName);
    }

    public void setOptions(String options) {
        SimpleParameterProvider parameters = (SimpleParameterProvider)this.getParameterProviders().get("options");
        parameters.setParameter("options", options);
    }
}

