/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.SolutionHelper;
import org.pentaho.platform.uifoundation.component.xml.XmlComponent;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class PMDUIComponent
extends XmlComponent {
    private static final long serialVersionUID = -911457505257919399L;
    private static final Log logger = LogFactory.getLog(PMDUIComponent.class);
    public static final int ACTION_LIST_DOMAINS = 1;
    public static final int ACTION_LIST_MODELS = 2;
    public static final int ACTION_MODELS_DETAIL = 3;
    public static final int ACTION_LOAD_MODEL = 4;
    public static final int ACTION_LOOKUP = 5;
    private int action;
    private String domainName;
    private String modelId;
    private String columnId;
    private IParameterProvider parameters;

    public PMDUIComponent(IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages, "");
    }

    public Log getLogger() {
        return logger;
    }

    public boolean validate() {
        return true;
    }

    public IMetadataDomainRepository getMetadataRepository() {
        return (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, (IPentahoSession)this.getSession());
    }

    public Document getXmlContent() {
        if (this.action == 2) {
            return this.listModels();
        }
        if (this.action == 4) {
            return this.loadModel();
        }
        if (this.action == 5) {
            return this.getLookup();
        }
        throw new RuntimeException(Messages.getErrorString("PMDUIComponent.ERROR_0002_ILLEGAL_ACTION", String.valueOf(this.action)));
    }

    private Document listModels() {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("metadata");
        Element modelsNode = root.addElement("models");
        if (this.domainName == null) {
            try {
                for (String domain : this.getMetadataRepository().getDomainIds()) {
                    this.addThinDomainModels(domain, modelsNode, root);
                }
            }
            catch (Throwable t) {
                this.error(Messages.getString("PMDUIComponent.ERROR_0001_GET_MODEL_LIST"));
                t.printStackTrace();
                root.addElement("message").setText(Messages.getString("PMDUIComponent.USER_NO_DOMAIN_SPECIFIED"));
            }
        } else {
            this.addThinDomainModels(this.domainName, modelsNode, root);
        }
        return doc;
    }

    private void addThinDomainModels(String domain, Element modelsNode, Element root) {
        IMetadataDomainRepository repo = this.getMetadataRepository();
        Domain domainObject = repo.getDomain(domain);
        String locale = LocaleHelper.getClosestLocale((String)LocaleHelper.getLocale().toString(), (String[])domainObject.getLocaleCodes());
        for (LogicalModel model : domainObject.getLogicalModels()) {
            String modelDescription;
            String modelName;
            String vis = (String)model.getProperty("visible");
            if (vis != null) {
                String[] visibleContexts = vis.split(",");
                boolean visibleToContext = false;
                for (String context : visibleContexts) {
                    if (!"adhoc".equals(context.trim())) continue;
                    visibleToContext = true;
                    break;
                }
                if (!visibleToContext) continue;
            }
            Element modelNode = modelsNode.addElement("model");
            modelNode.addElement("domain_id").setText(domain);
            if (model.getId() != null) {
                modelNode.addElement("model_id").setText(model.getId());
            }
            if ((modelName = model.getName(locale)) != null) {
                modelNode.addElement("model_name").setText(modelName);
            }
            if (model.getDescription() == null || (modelDescription = model.getDescription(locale)) == null) continue;
            modelNode.addElement("model_description").setText(modelDescription);
        }
    }

    private Document loadModel() {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("metadata");
        if (this.domainName == null) {
            root.addElement("message").setText(Messages.getString("PMDUIComponent.USER_NO_DOMAIN_SPECIFIED"));
            return doc;
        }
        if (this.modelId == null) {
            root.addElement("message").setText(Messages.getString("PMDUIComponent.USER_NO_MODEL_SPECIFIED"));
            return doc;
        }
        Element modelNode = root.addElement("model");
        Domain domain = this.getMetadataRepository().getDomain(this.domainName);
        if (domain == null) {
            root.addElement("message").setText(Messages.getString("PMDUIComponent.USER_DOMAIN_LOADING_ERROR", this.domainName));
            return doc;
        }
        String locale = LocaleHelper.getClosestLocale((String)LocaleHelper.getLocale().toString(), (String[])domain.getLocaleCodes());
        LogicalModel model = domain.findLogicalModel(this.modelId);
        if (model == null) {
            root.addElement("message").setText(Messages.getString("PMDUIComponent.USER_MODEL_LOADING_ERROR", this.modelId));
            this.error(Messages.getString("PMDUIComponent.USER_MODEL_LOADING_ERROR", this.modelId));
            return doc;
        }
        modelNode.addElement("domain_id").setText(this.domainName);
        if (model.getId() != null) {
            modelNode.addElement("model_id").setText(model.getId());
        }
        if (model.getName(locale) != null) {
            modelNode.addElement("model_name").setText(model.getName(locale));
        }
        if (model.getDescription(locale) != null) {
            modelNode.addElement("model_description").setText(model.getDescription(locale));
        }
        for (Category category : model.getCategories()) {
            Element tableNode = modelNode.addElement("view");
            if (category.getId() != null) {
                tableNode.addElement("view_id").setText(category.getId());
            }
            if (category.getName(locale) != null) {
                tableNode.addElement("view_name").setText(category.getName(locale));
            }
            if (category.getDescription(locale) != null) {
                tableNode.addElement("view_description").setText(category.getDescription(locale));
            }
            for (LogicalColumn column : category.getLogicalColumns()) {
                Boolean hidden = (Boolean)column.getProperty("hidden");
                if (hidden != null && hidden.booleanValue()) continue;
                this.addColumn(column, tableNode, locale);
            }
        }
        return doc;
    }

    public void addColumn(LogicalColumn column, Element tableNode, String locale) {
        DataType dataType;
        Element columnNode = tableNode.addElement("column");
        if (column.getId() != null) {
            columnNode.addElement("column_id").setText(column.getId());
        }
        if (column.getName(locale) != null) {
            columnNode.addElement("column_name").setText(column.getName(locale));
        }
        if (column.getDescription(locale) != null) {
            columnNode.addElement("column_description").setText(column.getDescription(locale));
        }
        if (column.getFieldType() != null) {
            String desc = column.getFieldType().getDescription();
            desc = org.pentaho.pms.messages.Messages.getString((String)desc);
            columnNode.addElement("column_field_type").setText(desc);
        }
        if ((dataType = column.getDataType()) != null) {
            columnNode.addElement("column_type").setText(dataType.getName());
        }
        if (column.getProperty("lookup") != null) {
            columnNode.addElement("column_lookup").setText("true");
        }
    }

    public Document getLookup() {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("metadata");
        if (this.domainName == null) {
            root.addElement("message").setText(Messages.getString("PMDUIComponent.USER_NO_DOMAIN_SPECIFIED"));
            return doc;
        }
        if (this.modelId == null) {
            root.addElement("message").setText(Messages.getString("PMDUIComponent.USER_NO_MODEL_SPECIFIED"));
            return doc;
        }
        if (this.columnId == null) {
            root.addElement("message").setText(Messages.getString("PMDUIComponent.USER_NO_COLUMN_SPECIFIED"));
            return doc;
        }
        Domain domain = this.getMetadataRepository().getDomain(this.domainName);
        String locale = LocaleHelper.getClosestLocale((String)LocaleHelper.getLocale().toString(), (String[])domain.getLocaleCodes());
        LogicalModel model = domain.findLogicalModel(this.modelId);
        if (model == null) {
            root.addElement("message").setText(Messages.getString("PMDUIComponent.USER_MODEL_LOADING_ERROR", this.modelId));
            return doc;
        }
        LogicalColumn column = model.findLogicalColumn(this.columnId);
        if (column == null) {
            root.addElement("message").setText(Messages.getString("PMDUIComponent.USER_COLUMN_NOT_FOUND"));
            return doc;
        }
        Category view = null;
        block0: for (Category category : model.getCategories()) {
            for (LogicalColumn col : category.getLogicalColumns()) {
                if (!col.getId().equals(column.getId())) continue;
                view = category;
                continue block0;
            }
        }
        if (view == null) {
            root.addElement("message").setText(Messages.getString("PMDUIComponent.USER_VIEW_NOT_FOUND"));
            return doc;
        }
        String mql = "<mql><domain_type>relational</domain_type><domain_id>" + this.domainName + "</domain_id><model_id>" + this.modelId + "</model_id>";
        if (column.getProperty("lookup") == null) {
            mql = mql + "<selection><view>" + view.getId() + "</view><column>" + column.getId() + "</column></selection>";
            mql = mql + "<orders><order><direction>asc</direction><view_id>" + view.getId() + "</view_id><column_id>" + column.getId() + "</column_id></order></orders>";
        } else {
            String lookup = (String)column.getProperty("lookup");
            StringTokenizer tokenizer1 = new StringTokenizer(lookup, ";");
            while (tokenizer1.hasMoreTokens()) {
                StringTokenizer tokenizer2 = new StringTokenizer(tokenizer1.nextToken(), ".");
                if (tokenizer2.countTokens() != 2) continue;
                String lookupViewId = tokenizer2.nextToken();
                String lookupColumnId = tokenizer2.nextToken();
                mql = mql + "<selection><view>" + lookupViewId + "</view><column>" + lookupColumnId + "</column></selection>";
            }
        }
        mql = mql + "</mql>";
        ArrayList messages = new ArrayList();
        SimpleParameterProvider lookupParameters = new SimpleParameterProvider();
        lookupParameters.setParameter("mql", mql);
        IRuntimeContext runtime = SolutionHelper.doAction((String)"system", (String)"metadata", (String)"PickList.xaction", (String)"lookup-list", (IParameterProvider)lookupParameters, (IPentahoSession)this.getSession(), messages, (ILogger)this);
        IPentahoResultSet results = null;
        if (runtime != null && runtime.getStatus() == 6 && runtime.getOutputNames().contains("data")) {
            Element rowElement;
            results = runtime.getOutputParameter("data").getValueAsResultSet();
            Object[][] columnHeaders = results.getMetaData().getColumnHeaders();
            boolean hasColumnHeaders = columnHeaders != null;
            Element dataElement = root.addElement("data");
            if (hasColumnHeaders) {
                for (int rowNo = 0; rowNo < columnHeaders.length; ++rowNo) {
                    rowElement = dataElement.addElement("COLUMN-HDR-ROW");
                    for (int columnNo = 0; columnNo < columnHeaders[rowNo].length; ++columnNo) {
                        Object nameAttr = results.getMetaData().getAttribute(rowNo, columnNo, "name");
                        if (nameAttr != null && nameAttr instanceof LocalizedString) {
                            LocalizedString str = (LocalizedString)nameAttr;
                            String name = str.getLocalizedString(locale);
                            if (name != null) {
                                rowElement.addElement("COLUMN-HDR-ITEM").setText(name);
                                continue;
                            }
                            rowElement.addElement("COLUMN-HDR-ITEM").setText(columnHeaders[rowNo][columnNo].toString());
                            continue;
                        }
                        rowElement.addElement("COLUMN-HDR-ITEM").setText(columnHeaders[rowNo][columnNo].toString());
                    }
                }
            }
            Object[] row = results.next();
            while (row != null) {
                rowElement = dataElement.addElement("DATA-ROW");
                for (Object element : row) {
                    if (element == null) {
                        rowElement.addElement("DATA-ITEM").setText("");
                        continue;
                    }
                    rowElement.addElement("DATA-ITEM").setText(element.toString());
                }
                row = results.next();
            }
        }
        return doc;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public int getAction() {
        return this.action;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public IParameterProvider getParameters() {
        return this.parameters;
    }

    public void setParameters(IParameterProvider parameters) {
        this.parameters = parameters;
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public String getColumnId() {
        return this.columnId;
    }

    public void setColumnId(String columnId) {
        this.columnId = columnId;
    }
}

