/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component.xml;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.platform.api.engine.IAclSolutionFile;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IPermissionMask;
import org.pentaho.platform.api.engine.IPermissionRecipient;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.IUserDetailsRoleListService;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SimplePermissionMask;
import org.pentaho.platform.engine.security.SimpleRole;
import org.pentaho.platform.engine.security.SimpleUser;
import org.pentaho.platform.engine.security.acls.PentahoAclEntry;
import org.pentaho.platform.repository.hibernate.HibernateUtil;
import org.pentaho.platform.uifoundation.component.xml.XmlComponent;
import org.pentaho.platform.uifoundation.messages.Messages;

public class PropertiesPanelUIComponent
extends XmlComponent {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(PropertiesPanelUIComponent.class);
    private static final String TYPE_PARAM = "type";
    private static final String ACTION_PARAM = "action";
    private static final String ADD_NAME_PARAM = "add_name";
    private static final String PATH_PARAM = "path";
    private static final String LIST_ACTION = "list";
    private static final String ADD_BTN_PARAM = "addBtn";
    private static final String UPDATE_BTN_PARAM = "updateBtn";
    private static final String ROLE_TYPE = "role";
    private static final String PERM_TYPE = "perm";
    private static final String ROLE_PREFIX = "role_";
    private static final String PERMISSION_PREFIX = "perm_";
    private static final String USER_TYPE = "user";
    private static final String USER_PREFIX = "user_";
    private static final String PERMISSION_SEPERATOR = "#";
    private static final String DELETE_PREFIX = "delete_";
    private static final String NO_FILE_PATH_NODE_NAME = "no-file-path";
    private static final String SET_PERMISSIONS_DENIED_NAME = "set-permissions-denied";
    private static final String NO_ACLS_NODE_NAME = "no-acls";
    private static final String INPUT_PAGE_NODE_NAME = "input-page";
    private static final String FILE_PATH_NODE_NAME = "file-path";
    private static final String IS_DIR_NODE_NAME = "is-directory";
    private static final String RECIPIENTS_NODE_NAME = "recipients";
    private static final String ROLE_NODE_NAME = "role";
    private static final String USER_NODE_NAME = "user";
    private static final String PERMISSION_NAMES_NODE_NAME = "permission-names";
    private static final String NAME_NODE_NAME = "name";
    private static final String ACCESS_CONTROL_LIST_NODE_NAME = "ac-list";
    private static final String ACCESS_CONTROL_NODE_NAME = "access-control";
    private static final String RECIPIENT_NODE_NAME = "recipient";
    private static final String PERMISSION_NODE_NAME = "permission";
    private static final String PERMITTED_NODE_NAME = "permitted";
    private static final String EMPTY_STRING = "";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String ON = "on";
    private static final String DISPLAY_PATH_NODE_NAME = "display-path";
    protected IPentahoSession session = null;
    protected String baseUrl = null;
    boolean includeUsers = PentahoSystem.getSystemSetting((String)"access-ui/include-users", (String)"true").equals("true");
    boolean includeRoles = PentahoSystem.getSystemSetting((String)"access-ui/include-roles", (String)"true").equals("true");
    protected ISolutionRepository repository;
    private List allUsersList;
    private List allRolesList;
    protected IUserDetailsRoleListService userDetailsRoleListService;

    public PropertiesPanelUIComponent(IPentahoUrlFactory urlFactory, List messages, IPentahoSession session) {
        super(urlFactory, messages, null);
        this.session = session;
        this.setXsl("text/html", "PropertiesPanel.xsl");
        this.setXslProperty("baseUrl", urlFactory.getDisplayUrlBuilder().getUrl());
        this.repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
        if (!this.repository.supportsAccessControls()) {
            this.error(Messages.getString("PropertiesPanelUIComponent.ERROR_0001_BAD_CONFIGURATION"));
        }
        this.userDetailsRoleListService = PentahoSystem.getUserDetailsRoleListService();
    }

    public Document getXmlContent() {
        if (!this.repository.supportsAccessControls()) {
            return this.noACLSPage();
        }
        String actionStr = this.getParameter(ACTION_PARAM, EMPTY_STRING);
        String pathStr = this.getParameter(PATH_PARAM, null);
        ISolutionFile file = null;
        try {
            HibernateUtil.beginTransaction();
            file = this.repository.getSolutionFile(pathStr, 1);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (actionStr == null || actionStr.equalsIgnoreCase(LIST_ACTION) || actionStr.equalsIgnoreCase(EMPTY_STRING)) {
            HibernateUtil.commitTransaction();
            if (file != null) {
                return this.showInputPage(file);
            }
            return this.noPathPage();
        }
        IParameterProvider request = (IParameterProvider)this.getParameterProviders().get("request");
        if (request.getParameter(ADD_BTN_PARAM) != null && !request.getParameter(ADD_BTN_PARAM).equals(EMPTY_STRING)) {
            this.doAddToAcls(file);
        }
        try {
            if (request.getParameter(UPDATE_BTN_PARAM) != null && !request.getParameter(UPDATE_BTN_PARAM).equals(EMPTY_STRING)) {
                this.doUpdateAcls(file);
            }
        }
        catch (PentahoAccessControlException e) {
            HibernateUtil.rollbackTransaction();
            return this.setPermissionsFailedPage(e.getLocalizedMessage());
        }
        HibernateUtil.commitTransaction();
        this.repository.resetRepository();
        if (file != null) {
            return this.showInputPage(file);
        }
        return this.noPathPage();
    }

    private void doUpdateAcls(ISolutionFile file) throws PentahoAccessControlException {
        IParameterProvider request = (IParameterProvider)this.getParameterProviders().get("request");
        LinkedHashMap<SimpleRole, SimplePermissionMask> permMap = new LinkedHashMap<SimpleRole, SimplePermissionMask>();
        Iterator it = request.getParameterNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!name.startsWith(USER_PREFIX) && !name.startsWith(ROLE_PREFIX)) continue;
            boolean isRole = name.startsWith(ROLE_PREFIX);
            name = name.replaceFirst(isRole ? ROLE_PREFIX : USER_PREFIX, EMPTY_STRING);
            String lineNumber = name.substring(name.lastIndexOf(95) + 1);
            if (this.isFlaggedForDelete(name = name.substring(0, name.lastIndexOf(95)))) continue;
            SimpleRole permissionRecipient = isRole ? new SimpleRole(name) : new SimpleUser(name);
            SimplePermissionMask permissionMask = new SimplePermissionMask();
            Iterator it1 = request.getParameterNames();
            while (it1.hasNext()) {
                String permNumber;
                String perm = (String)it1.next();
                if (!perm.startsWith(PERMISSION_PREFIX) || !(permNumber = (perm = perm.replaceFirst(PERMISSION_PREFIX, EMPTY_STRING)).substring(perm.lastIndexOf(95) + 1)).equals(lineNumber)) continue;
                perm = perm.substring(0, perm.lastIndexOf(95));
                permissionMask.addPermission(((Integer)PentahoAclEntry.getValidPermissionsNameMap().get(perm)).intValue());
            }
            permMap.put(permissionRecipient, permissionMask);
        }
        if (file instanceof IAclSolutionFile) {
            this.repository.setPermissions(file, permMap);
        }
    }

    private boolean isFlaggedForDelete(String name) {
        IParameterProvider request = (IParameterProvider)this.getParameterProviders().get("request");
        return ON.equalsIgnoreCase(request.getStringParameter(DELETE_PREFIX + name, null));
    }

    private void doAddToAcls(ISolutionFile file) {
        String[] names;
        IParameterProvider request = (IParameterProvider)this.getParameterProviders().get("request");
        for (String name : names = request.getStringArrayParameter(ADD_NAME_PARAM, new String[0])) {
            Object permissionRecipient = null;
            permissionRecipient = name.startsWith(ROLE_PREFIX) ? new SimpleRole(name.replaceFirst(ROLE_PREFIX, EMPTY_STRING)) : new SimpleUser(name.replaceFirst(USER_PREFIX, EMPTY_STRING));
            SimplePermissionMask permissionMask = new SimplePermissionMask();
            Iterator it = request.getParameterNames();
            while (it.hasNext()) {
                String paramName = it.next().toString();
                if (!paramName.startsWith(PERMISSION_PREFIX)) continue;
                String permKey = paramName.replaceFirst(PERMISSION_PREFIX, EMPTY_STRING);
                StringTokenizer tokenizer = new StringTokenizer(permKey, PERMISSION_SEPERATOR);
                String permName = tokenizer.nextToken();
                String perm = tokenizer.nextToken();
                if (!permName.equals("Untitled-0")) continue;
                permissionMask.addPermission(((Integer)PentahoAclEntry.getValidPermissionsNameMap().get(perm)).intValue());
            }
            if (!(file instanceof IAclSolutionFile)) continue;
            this.repository.addPermission(file, (IPermissionRecipient)permissionRecipient, (IPermissionMask)permissionMask);
        }
    }

    private Document noPathPage() {
        Document document = DocumentHelper.createDocument();
        document.addElement(NO_FILE_PATH_NODE_NAME).addText(Messages.getString("PropertiesPanelUIComponent.USER_NO_FILE_SELECTED"));
        return document;
    }

    private Document setPermissionsFailedPage(String msg) {
        Document document = DocumentHelper.createDocument();
        document.addElement(SET_PERMISSIONS_DENIED_NAME).addText(msg);
        return document;
    }

    private Document noACLSPage() {
        Document document = DocumentHelper.createDocument();
        document.addElement(NO_ACLS_NODE_NAME).addText(Messages.getString("PropertiesPanelUIComponent.ERROR_0001_BAD_CONFIGURATION"));
        return document;
    }

    protected Document showInputPage(ISolutionFile file) {
        List uList;
        List rList;
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(INPUT_PAGE_NODE_NAME).addText(file.getFullPath());
        root.addElement(FILE_PATH_NODE_NAME).addText(file.getFullPath());
        root.addElement(DISPLAY_PATH_NODE_NAME).addText(file.getFullPath().replaceFirst(this.repository.getRepositoryName(), EMPTY_STRING).replaceFirst("//", "/"));
        root.addElement(IS_DIR_NODE_NAME).addText(file.isDirectory() ? TRUE : FALSE);
        Element recipients = root.addElement(RECIPIENTS_NODE_NAME);
        Iterator iter = null;
        if (this.includeRoles && (rList = this.getAllRolesList()) != null) {
            iter = rList.iterator();
            while (iter.hasNext()) {
                recipients.addElement("role").addText(iter.next().toString());
            }
        }
        if (this.includeUsers && (uList = this.getAllUsersList()) != null) {
            iter = uList.iterator();
            while (iter.hasNext()) {
                recipients.addElement("user").addText(iter.next().toString());
            }
        }
        Map permissionsMap = PentahoAclEntry.getValidPermissionsNameMap();
        Iterator keyIter = permissionsMap.keySet().iterator();
        Element permNames = root.addElement(PERMISSION_NAMES_NODE_NAME);
        while (keyIter.hasNext()) {
            permNames.addElement(NAME_NODE_NAME).addText(keyIter.next().toString());
        }
        Element acListNode = root.addElement(ACCESS_CONTROL_LIST_NODE_NAME);
        TreeMap sortedMap = new TreeMap(new Comparator<IPermissionRecipient>(){

            @Override
            public int compare(IPermissionRecipient arg0, IPermissionRecipient arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        sortedMap.putAll(this.repository.getPermissions(file));
        for (Map.Entry mapEntry : sortedMap.entrySet()) {
            IPermissionRecipient permissionRecipient = mapEntry.getKey();
            Element acNode = acListNode.addElement(ACCESS_CONTROL_NODE_NAME);
            Element recipientNode = acNode.addElement(RECIPIENT_NODE_NAME);
            recipientNode.setText(permissionRecipient.getName());
            recipientNode.addAttribute(TYPE_PARAM, permissionRecipient instanceof SimpleRole ? "role" : "user");
            Iterator keyIterator = permissionsMap.keySet().iterator();
            while (keyIterator.hasNext()) {
                Element aPermission = acNode.addElement(PERMISSION_NODE_NAME);
                String permName = keyIterator.next().toString();
                aPermission.addElement(NAME_NODE_NAME).setText(permName);
                int permMask = (Integer)permissionsMap.get(permName);
                boolean isPermitted = false;
                aPermission.addElement(PERMITTED_NODE_NAME).addText(isPermitted ? TRUE : FALSE);
            }
        }
        return document;
    }

    public static void main(String[] args) {
    }

    public List getAllUsersList() {
        if (this.allUsersList == null) {
            this.allUsersList = this.userDetailsRoleListService.getAllUsers();
        }
        return this.allUsersList;
    }

    public List getAllRolesList() {
        if (this.allRolesList == null) {
            this.allRolesList = this.userDetailsRoleListService.getAllRoles();
        }
        return this.allRolesList;
    }

    public Log getLogger() {
        return logger;
    }

    public boolean validate() {
        return true;
    }
}

