/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component.xml;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.ISolutionFilter;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.uifoundation.component.xml.XmlComponent;
import org.pentaho.platform.uifoundation.messages.Messages;

public class SolutionTreeUIComponent
extends XmlComponent
implements ISolutionFilter {
    private static final long serialVersionUID = 1L;
    private static final Log logger = LogFactory.getLog(SolutionTreeUIComponent.class);
    protected IPentahoSession session = null;

    public SolutionTreeUIComponent(IPentahoUrlFactory urlFactory, List messages, IPentahoSession session) {
        super(urlFactory, messages, null);
        this.session = session;
        this.setXsl("text/html", "xmlTree.xsl");
        this.setXslProperty("baseUrl", urlFactory.getDisplayUrlBuilder().getUrl());
    }

    public boolean keepFile(ISolutionFile solutionFile, int actionOperation) {
        return SecurityHelper.canHaveACLS((ISolutionFile)solutionFile);
    }

    public Document getXmlContent() {
        if (SecurityHelper.isPentahoAdministrator((IPentahoSession)this.session)) {
            try {
                ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.session);
                return repository.getSolutionTree(60, (ISolutionFilter)this);
            }
            catch (Exception e) {
                Document document = DocumentHelper.createDocument();
                document.addElement("error").setText(Messages.getString("SolutionTreeUIComponent.ERROR_0001_PERMISSIONS_NOT_SUPPORTED"));
                return document;
            }
        }
        return null;
    }

    public Log getLogger() {
        return logger;
    }

    public boolean validate() {
        return true;
    }
}

