/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component.xml;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jfree.data.general.Dataset;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.uifoundation.chart.DialWidgetDefinition;
import org.pentaho.platform.uifoundation.chart.JFreeChartEngine;
import org.pentaho.platform.uifoundation.chart.WidgetDefinition;
import org.pentaho.platform.uifoundation.component.xml.XmlComponent;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;

public class WidgetGridComponent
extends XmlComponent {
    private static final long serialVersionUID = -3952161695550067971L;
    private String definitionPath;
    private int widgetWidth;
    private int widgetHeight;
    private String solution = null;
    private String actionPath = null;
    private String actionName = null;
    private String valueItem = null;
    private String nameItem = null;
    private int columns = 0;
    private String instanceId = null;
    private String actionOutput = null;
    private String urlTemplate = null;
    private String style = null;
    private IRuntimeContext context;
    private static final Log logger = LogFactory.getLog(WidgetGridComponent.class);

    public Log getLogger() {
        return logger;
    }

    public WidgetGridComponent(String definitionPath, IPentahoUrlFactory urlFactory, List messages) {
        super(urlFactory, messages, null);
        this.definitionPath = definitionPath;
        ActionInfo info = ActionInfo.parseActionString((String)definitionPath);
        if (info != null) {
            this.setSourcePath(info.getSolutionName() + File.separator + info.getPath());
        }
        this.setXsl("text/html", "DialWidget.xsl");
    }

    public void setWidgetWidth(int widgetWidth) {
        this.widgetWidth = widgetWidth;
    }

    public void setWidgetHeight(int widgetHeight) {
        this.widgetHeight = widgetHeight;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public boolean setDataAction(String widgetGridDataDefinition) {
        ActionSequenceResource resource = new ActionSequenceResource("", 1, "text/xml", widgetGridDataDefinition);
        try {
            Document dataActionDocument = ((ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession())).getResourceAsDocument((IActionSequenceResource)resource, 1);
            if (dataActionDocument == null) {
                return false;
            }
            Node dataNode = dataActionDocument.selectSingleNode("widgetgrid/data");
            this.solution = XmlDom4JHelper.getNodeText((String)"data-solution", (Node)dataNode);
            this.actionPath = XmlDom4JHelper.getNodeText((String)"data-path", (Node)dataNode);
            this.actionName = XmlDom4JHelper.getNodeText((String)"data-action", (Node)dataNode);
            this.actionOutput = XmlDom4JHelper.getNodeText((String)"data-output", (Node)dataNode);
            this.valueItem = XmlDom4JHelper.getNodeText((String)"data-value", (Node)dataNode);
            this.nameItem = XmlDom4JHelper.getNodeText((String)"data-name", (Node)dataNode);
            this.widgetWidth = (int)XmlDom4JHelper.getNodeText((String)"widgetgrid/width", (Node)dataActionDocument, (long)125L);
            this.widgetHeight = (int)XmlDom4JHelper.getNodeText((String)"widgetgrid/height", (Node)dataActionDocument, (long)125L);
            this.columns = (int)XmlDom4JHelper.getNodeText((String)"widgetgrid/columns", (Node)dataActionDocument, (long)2L);
            this.style = XmlDom4JHelper.getNodeText((String)"widgetgrid/style", (Node)dataActionDocument);
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("WidgetGrid.ERROR_0003_DEFINITION_NOT_VALID", widgetGridDataDefinition), e);
            return false;
        }
        return true;
    }

    public void setDataAction(String solution, String actionPath, String actionName, String actionOutput, String nameItem, String valueItem) {
        this.solution = solution;
        this.actionPath = actionPath;
        this.actionName = actionName;
        this.actionOutput = actionOutput;
        this.valueItem = valueItem;
        this.nameItem = nameItem;
    }

    public void setDrillUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    public boolean validate() {
        return true;
    }

    public Document getXmlContent() {
        IPentahoResultSet resultSet = null;
        if (this.solution != null) {
            resultSet = this.getActionData();
        }
        ActionSequenceResource resource = new ActionSequenceResource("", 1, "text/xml", this.definitionPath);
        Document dialDefinition = null;
        try {
            dialDefinition = ((ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.getSession())).getResourceAsDocument((IActionSequenceResource)resource, 1);
        }
        catch (IOException e) {
            // empty catch block
        }
        DialWidgetDefinition widgetDefinition = new DialWidgetDefinition(dialDefinition, 0.0, this.widgetWidth, this.widgetHeight, this.getSession());
        return this.createDials(resultSet, widgetDefinition);
    }

    protected Document createDials(IPentahoResultSet resultSet, WidgetDefinition widgetDefinition) {
        if (resultSet == null) {
            this.error(Messages.getErrorString("WidgetGrid.ERROR_0001_NO_RESULTS_FROM_ACTION"));
            return null;
        }
        if (this.valueItem == null) {
            this.error(Messages.getErrorString("WidgetGrid.ERROR_0002_NO_VALUE_ITEM"));
        }
        Document result = DocumentHelper.createDocument();
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        this.setXslProperty("baseUrl", requestContext.getContextPath());
        this.setXslProperty("fullyQualifiedServerUrl", PentahoSystem.getApplicationContext().getFullyQualifiedServerURL());
        Element root = result.addElement("widgets");
        IPentahoMetaData metaData = resultSet.getMetaData();
        Object[][] columnHeaders = metaData.getColumnHeaders();
        int nameColumnNo = -1;
        int valueColumnNo = -1;
        for (int idx = 0; idx < columnHeaders[0].length; ++idx) {
            if (columnHeaders[0][idx].toString().equalsIgnoreCase(this.nameItem)) {
                nameColumnNo = idx;
            }
            if (!columnHeaders[0][idx].toString().equalsIgnoreCase(this.valueItem)) continue;
            valueColumnNo = idx;
        }
        if (nameColumnNo == -1) {
            this.error(Messages.getErrorString("WidgetGrid.ERROR_0004_NAME_COLUMN_MISSING", this.nameItem));
            return null;
        }
        if (valueColumnNo == -1) {
            this.error(Messages.getErrorString("WidgetGrid.ERROR_0005_VALUE_COLUMN_MISSING", this.valueItem));
            return null;
        }
        Object[] row = resultSet.next();
        while (row != null) {
            String name = row[nameColumnNo].toString();
            try {
                double value = Double.parseDouble(row[valueColumnNo].toString());
                this.createDial(value, name, root, widgetDefinition);
            }
            catch (Exception e) {
                // empty catch block
            }
            row = resultSet.next();
        }
        this.setXslProperty("urlTarget", "pentaho_popup");
        this.setXslProperty("columns", Integer.toString(this.columns));
        if (this.style != null) {
            this.setXslProperty("style", this.style);
        }
        return result;
    }

    protected void createDial(double value, String name, Element root, WidgetDefinition widgetDefinition) {
        widgetDefinition.setValue(new Double(value));
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String units = "";
        String dialName = "";
        String solutionDir = "system/tmp/";
        String fileNamePrefix = "tmp_pie_";
        String extension = ".png";
        String fileName = null;
        String filePathWithoutExtension = null;
        try {
            File file = PentahoSystem.getApplicationContext().createTempFile(this.getSession(), fileNamePrefix, extension, true);
            fileName = file.getName();
            filePathWithoutExtension = solutionDir + fileName.substring(0, fileName.indexOf(46));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JFreeChartEngine.saveChart((Dataset)widgetDefinition, dialName, units, filePathWithoutExtension, this.widgetWidth, this.widgetHeight, 1, printWriter, (ILogger)this);
        Element widgetNode = root.addElement("widget");
        widgetNode.addElement("title").setText(name);
        widgetNode.addElement("units").setText(units);
        widgetNode.addElement("width").setText(Integer.toString(this.widgetWidth));
        widgetNode.addElement("height").setText(Integer.toString(this.widgetHeight));
        Element valueNode = widgetNode.addElement("value");
        valueNode.setText(Double.toString(value));
        valueNode.addAttribute("in-image", Boolean.toString(widgetDefinition.getValueFont() != null));
        root.addElement("image").setText(fileName);
        widgetNode.addElement("image").setText(fileName);
        String drillUrl = TemplateUtil.applyTemplate((String)this.urlTemplate, (String)this.nameItem, (String)name);
        drillUrl = TemplateUtil.applyTemplate((String)drillUrl, (IRuntimeContext)this.context);
        widgetNode.addElement("urlDrill").setText(drillUrl);
    }

    public void dispose() {
        if (this.context != null) {
            this.context.dispose();
        }
    }

    protected IPentahoResultSet getActionData() {
        ISolutionEngine solutionEngine = (ISolutionEngine)PentahoSystem.get(ISolutionEngine.class, (IPentahoSession)this.getSession());
        solutionEngine.setLoggingLevel(2);
        solutionEngine.init(this.getSession());
        HashMap parameterProviders = this.getParameterProviders();
        OutputStream outputStream = null;
        SimpleOutputHandler outputHandler = null;
        outputHandler = new SimpleOutputHandler(outputStream, false);
        ArrayList messages = new ArrayList();
        String processId = ((Object)((Object)this)).getClass().getName();
        this.context = solutionEngine.execute(this.solution, this.actionPath, this.actionName, processId, false, true, this.instanceId, false, (Map)parameterProviders, (IOutputHandler)outputHandler, null, this.urlFactory, messages);
        if (this.actionOutput != null) {
            if (this.context.getOutputNames().contains(this.actionOutput)) {
                IActionParameter output = this.context.getOutputParameter(this.actionOutput);
                IPentahoResultSet results = output.getValueAsResultSet();
                if (results != null) {
                    results = results.memoryCopy();
                }
                return results;
            }
            return null;
        }
        for (IActionParameter output : this.context.getOutputNames()) {
            if (!output.getType().equalsIgnoreCase("resultset")) continue;
            IPentahoResultSet results = output.getValueAsResultSet();
            if (results != null) {
                results = results.memoryCopy();
            }
            return results;
        }
        return null;
    }
}

