/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.component.xml;

import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.pentaho.platform.api.engine.IDocumentResourceLoader;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.ui.IXMLComponent;
import org.pentaho.platform.engine.services.SolutionURIResolver;
import org.pentaho.platform.uifoundation.component.BaseUIComponent;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.xml.XmlHelper;

public abstract class XmlComponent
extends BaseUIComponent
implements IXMLComponent {
    private static final Log log = LogFactory.getLog(XmlComponent.class);

    public XmlComponent(IPentahoUrlFactory urlFactory, List messages, String sourcePath) {
        super(urlFactory, messages, sourcePath);
    }

    public abstract Document getXmlContent();

    public String getContent(String mimeType) {
        if ("text/xml".equalsIgnoreCase(mimeType)) {
            Document content = this.getXmlContent();
            return content.asXML();
        }
        Document document = this.getXmlContent();
        if (document != null) {
            String xslName = (String)this.contentTypes.get(mimeType);
            if (xslName == null) {
                this.error(Messages.getString("BaseUI.ERROR_0002_XSL_NOT_FOUND") + mimeType);
                return null;
            }
            StringBuffer sb = null;
            try {
                sb = XmlHelper.transformXml((String)xslName, (String)this.getSourcePath(), (String)document.asXML(), (Map)this.getXslProperties(), (IDocumentResourceLoader)new SolutionURIResolver(this.getSession()));
            }
            catch (TransformerException e) {
                log.error((Object)Messages.getString("XmlComponent.ERROR_0000_XML_XFORM_FAILED"), (Throwable)e);
                return null;
            }
            if (sb == null) {
                log.error((Object)Messages.getString("XmlComponent.ERROR_0000_XML_XFORM_FAILED"));
                return null;
            }
            this.debug(sb.toString());
            return sb.toString();
        }
        return null;
    }
}

