/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.contentgen;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.pentaho.platform.api.engine.IDocumentResourceLoader;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.ui.INavigationComponent;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.SolutionURIResolver;
import org.pentaho.platform.uifoundation.contentgen.BaseXmlContentGenerator;
import org.pentaho.platform.uifoundation.messages.Messages;
import org.pentaho.platform.util.web.SimpleUrlFactory;
import org.pentaho.platform.util.xml.XmlHelper;

public class AdminContentGenerator
extends BaseXmlContentGenerator {
    private static final long serialVersionUID = 2272261269875005948L;

    public Log getLogger() {
        return LogFactory.getLog(AdminContentGenerator.class);
    }

    public String getContent() throws Exception {
        String header = Messages.getString("UI.USER_ADMIN_INTRO");
        String admin = this.getAdminLinks(this.userSession);
        String publish = this.getPublisherContent(this.userSession);
        StringBuilder sb = new StringBuilder();
        sb.append("<table class='content_table' border='0' cellpadding='0' cellspacing='0' height='100%''>\n");
        sb.append("<tr>\n");
        sb.append("<td colspan='2' class='content_pagehead'>\n");
        sb.append(header);
        sb.append("</td>\n");
        sb.append("</tr>\n");
        sb.append("<tr>\n");
        sb.append("<td class='contentcell_half_right' width='50%'>\n");
        sb.append(admin);
        sb.append(publish);
        sb.append("</td>\n");
        sb.append("</tr>\n");
        sb.append("</table>\n");
        return sb.toString();
    }

    private final String getAdminLinks(IPentahoSession userSession) {
        SimpleParameterProvider parameters = new SimpleParameterProvider();
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        String contextPath = requestContext.getContextPath();
        parameters.setParameter("solution", "admin");
        String navigateUrl = contextPath + "Navigate?";
        SimpleUrlFactory urlFactory = new SimpleUrlFactory(navigateUrl);
        ArrayList messages = new ArrayList();
        INavigationComponent navigate = (INavigationComponent)PentahoSystem.get(INavigationComponent.class, (IPentahoSession)userSession);
        navigate.setHrefUrl(contextPath);
        navigate.setOnClick("");
        navigate.setSolutionParamName("solution");
        navigate.setPathParamName("path");
        navigate.setAllowNavigation(new Boolean(false));
        navigate.setOptions("");
        navigate.setUrlFactory((IPentahoUrlFactory)urlFactory);
        navigate.setMessages(messages);
        navigate.validate(userSession, null);
        navigate.setParameterProvider("request", (IParameterProvider)parameters);
        navigate.setXsl("text/html", "admin-mini.xsl");
        String content = navigate.getContent("text/html");
        return content;
    }

    private final String getPublisherContent(IPentahoSession userSession) {
        Document publishersDocument = PentahoSystem.getPublishersDocument();
        if (publishersDocument != null) {
            HashMap parameters = new HashMap();
            try {
                StringBuffer sb = XmlHelper.transformXml((String)"publishers-mini.xsl", null, (String)publishersDocument.asXML(), parameters, (IDocumentResourceLoader)new SolutionURIResolver(userSession));
                return sb.toString();
            }
            catch (TransformerException e) {
                return Messages.getErrorString("PUBLISHERS.ERROR_0001_PUBLISHERS_ERROR");
            }
        }
        return Messages.getErrorString("PUBLISHERS.ERROR_0001_PUBLISHERS_ERROR");
    }
}

