/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.contentgen;

import java.io.OutputStream;
import org.pentaho.platform.api.engine.IMessageFormatter;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IUITemplater;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.BaseContentGenerator;
import org.pentaho.platform.uifoundation.messages.Messages;

public abstract class BaseXmlContentGenerator
extends BaseContentGenerator {
    private static final long serialVersionUID = 2272261269875005948L;
    protected IParameterProvider requestParameters;
    protected IParameterProvider sessionParameters;

    protected abstract String getContent() throws Exception;

    public void createContent() throws Exception {
        this.requestParameters = (IParameterProvider)this.parameterProviders.get("request");
        this.sessionParameters = (IParameterProvider)this.parameterProviders.get("session");
        String content = this.getContent();
        if (content == null) {
            StringBuffer buffer = new StringBuffer();
            ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)this.userSession)).formatErrorMessage("text/html", Messages.getErrorString("UI.ERROR_0001_CONTENT_ERROR"), this.messages, buffer);
            content = buffer.toString();
        }
        String intro = "";
        String footer = "";
        IUITemplater templater = (IUITemplater)PentahoSystem.get(IUITemplater.class, (IPentahoSession)this.userSession);
        if (templater != null) {
            String[] sections = templater.breakTemplate("template.html", "", this.userSession);
            if (sections != null && sections.length > 0) {
                intro = sections[0];
            }
            if (sections != null && sections.length > 1) {
                footer = sections[1];
            }
        } else {
            intro = Messages.getString("UI.ERROR_0002_BAD_TEMPLATE_OBJECT");
        }
        IContentItem contentItem = this.outputHandler.getOutputContentItem("response", "content", null, null, "text/html");
        OutputStream outputStream = contentItem.getOutputStream(null);
        outputStream.write(intro.getBytes());
        outputStream.write(content.getBytes());
        outputStream.write(footer.getBytes());
    }
}

