/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.uifoundation.contentgen;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.ui.INavigationComponent;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.uifoundation.contentgen.BaseXmlContentGenerator;

public class NavigationContentGenerator
extends BaseXmlContentGenerator {
    private static final long serialVersionUID = 2272261269875005948L;

    public Log getLogger() {
        return LogFactory.getLog(NavigationContentGenerator.class);
    }

    public String getContent() throws Exception {
        String solution = this.requestParameters.getStringParameter("solution", null);
        if ("".equals(solution)) {
            solution = null;
        }
        INavigationComponent navigate = (INavigationComponent)PentahoSystem.get(INavigationComponent.class, (IPentahoSession)this.userSession);
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        String contextPath = requestContext.getContextPath();
        navigate.setHrefUrl(contextPath);
        navigate.setOnClick("");
        navigate.setSolutionParamName("solution");
        navigate.setPathParamName("path");
        navigate.setAllowNavigation(new Boolean(solution != null));
        navigate.setOptions("");
        navigate.setUrlFactory(this.urlFactory);
        navigate.setMessages(this.messages);
        navigate.validate(this.userSession, null);
        navigate.setParameterProvider("request", this.requestParameters);
        navigate.setParameterProvider("session", this.sessionParameters);
        String view = this.requestParameters.getStringParameter("view", null);
        if (view != null) {
            if ("default".equals(view)) {
                this.userSession.removeAttribute("pentaho-ui-folder-style");
            } else {
                this.userSession.setAttribute("pentaho-ui-folder-style", (Object)view);
                navigate.setXsl("text/html", view);
            }
        } else {
            view = (String)this.userSession.getAttribute("pentaho-ui-folder-style");
            if (view != null) {
                navigate.setXsl("text/html", view);
            }
        }
        return navigate.getContent("text/html");
    }
}

