/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.buttons;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.gwt.widgets.client.utils.ButtonHelper;

public class CustomButton
extends Widget {
    private String baseStyleName = "customButton";
    private Command command;
    private boolean enabled = true;
    private Image image;
    private String text;
    private ButtonHelper.ButtonLabelType type;
    private List<ClickListener> listeners = new ArrayList<ClickListener>();
    HorizontalPanel buttonPanel;

    public CustomButton() {
    }

    public CustomButton(Image image, String text, ButtonHelper.ButtonLabelType type) {
        SimplePanel spacer = new SimplePanel();
        spacer.setWidth("10px");
        this.buttonPanel = new HorizontalPanel();
        this.buttonPanel.add((Widget)spacer);
        this.buttonPanel.add((Widget)ButtonHelper.createButtonElement(image, text, type));
        this.buttonPanel.add((Widget)spacer);
        this.setElement(this.buttonPanel.getElement());
        this.buttonPanel.setStylePrimaryName(this.baseStyleName);
        this.sinkEvents(124);
        this.sinkEvents(2);
    }

    public CustomButton(Image image, String text, ButtonHelper.ButtonLabelType type, String className) {
        SimplePanel spacer = new SimplePanel();
        spacer.setWidth("10px");
        this.buttonPanel = new HorizontalPanel();
        this.buttonPanel.add((Widget)spacer);
        this.buttonPanel.add((Widget)ButtonHelper.createButtonElement(image, text, type, className));
        this.buttonPanel.add((Widget)spacer);
        this.setElement(this.buttonPanel.getElement());
        this.buttonPanel.setStylePrimaryName(this.baseStyleName);
        this.sinkEvents(124);
        this.sinkEvents(2);
    }

    public CustomButton(Image image, String text, ButtonHelper.ButtonLabelType type, Command command) {
        this(image, text, type);
        this.setCommand(command);
    }

    private void setCommand(Command command) {
        this.command = command;
    }

    public void setStylePrimaryName(String style) {
        super.setStylePrimaryName(style);
        this.baseStyleName = style;
        this.buttonPanel.setStylePrimaryName(style);
    }

    public void addStyleDependentName(String style) {
        super.addStyleDependentName(style);
        this.buttonPanel.addStyleDependentName(style);
    }

    public void removeStyleDependentName(String style) {
        super.removeStyleDependentName(style);
        this.buttonPanel.removeStyleDependentName(style);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setEnabled(boolean enabled) {
        boolean prevVal = this.enabled;
        this.enabled = enabled;
        if (prevVal && enabled) {
            return;
        }
        if (prevVal && !enabled) {
            this.addStyleDependentName("disabled");
        } else {
            this.removeStyleDependentName("disabled");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void onBrowserEvent(Event event) {
        switch (event.getTypeInt()) {
            case 1: 
            case 2: 
            case 8: {
                if (!this.isEnabled()) break;
                this.fireClicked();
                if (this.command != null) {
                    this.command.execute();
                }
                event.cancelBubble(true);
                event.preventDefault();
                break;
            }
            case 16: {
                if (!this.isEnabled()) break;
                this.addStyleDependentName("hover");
                break;
            }
            case 32: {
                if (!this.isEnabled()) break;
                this.removeStyleDependentName("hover");
                break;
            }
            case 4: {
                if (!this.isEnabled()) break;
                this.addStyleDependentName("down");
            }
        }
    }

    private void fireClicked() {
        for (ClickListener listener : this.listeners) {
            listener.onClick((Widget)this);
        }
    }

    public void addClickListener(ClickListener listener) {
        this.listeners.add(listener);
    }

    public void removeClickListener(ClickListener listener) {
        this.listeners.remove(listener);
    }

    public void setFocus(boolean focus) {
        this.setFocus(focus);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public ButtonHelper.ButtonLabelType getType() {
        return this.type;
    }

    public void setType(ButtonHelper.ButtonLabelType type) {
        this.type = type;
    }

    public Command getCommand() {
        return this.command;
    }
}

