/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.buttons;

import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Image;

public class ImageButton
extends Image {
    private boolean isEnabled = true;
    private String enabledUrl;
    private String disabledUrl;

    public ImageButton(String enabledUrl, String disabledUrl, String tooltip) {
        this(enabledUrl, disabledUrl, tooltip, -1, -1);
    }

    public ImageButton() {
        this.setStyleName("image-button");
        this.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                if (ImageButton.this.isEnabled) {
                    ImageButton.this.setStyleName("image-button-pressed");
                } else {
                    ImageButton.this.setStyleName("disabled-image-button-pressed");
                }
            }
        });
        this.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                ImageButton.this.updateStyles();
            }
        });
        this.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (ImageButton.this.isEnabled) {
                    ImageButton.this.setStyleName("image-button-over");
                } else {
                    ImageButton.this.setStyleName("disabled-image-button-over");
                }
            }
        });
        this.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                ImageButton.this.updateStyles();
            }
        });
    }

    private void updateStyles() {
        if (this.isEnabled) {
            this.setStyleName("image-button");
        } else {
            this.setStyleName("disabled-image-button");
        }
    }

    public ImageButton(String enabledUrl, String disabledUrl, String tooltip, int width, int height) {
        super(enabledUrl);
        this.setSize(width + "px", height + "px");
        this.enabledUrl = enabledUrl;
        this.disabledUrl = disabledUrl;
        if (tooltip != null && tooltip.length() > 0) {
            this.setTitle(tooltip);
        }
    }

    public void setEnabledUrl(String url) {
        if (this.enabledUrl != null && this.enabledUrl.equals(url)) {
            return;
        }
        this.enabledUrl = url;
        if (this.isEnabled && !this.getUrl().equals(this.enabledUrl)) {
            this.setSrc(this.enabledUrl);
        } else if (!this.isEnabled && this.disabledUrl != null && !this.getUrl().equals(this.disabledUrl)) {
            this.setSrc(this.disabledUrl);
        }
    }

    public void setDisabledUrl(String url) {
        if (this.disabledUrl != null && this.disabledUrl.equals(url)) {
            return;
        }
        this.disabledUrl = url;
        if (this.isEnabled && this.enabledUrl != null && !this.getUrl().equals(this.enabledUrl)) {
            this.setSrc(this.enabledUrl);
        } else if (!this.isEnabled && !this.getUrl().equals(this.disabledUrl)) {
            this.setSrc(this.disabledUrl);
        }
    }

    public void onBrowserEvent(Event event) {
        super.onBrowserEvent(event);
        DOM.eventPreventDefault((Event)event);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        if (this.isEnabled == isEnabled) {
            return;
        }
        this.isEnabled = isEnabled;
        if (isEnabled) {
            this.setSrc(this.enabledUrl);
        } else if (this.disabledUrl != null) {
            this.setSrc(this.disabledUrl);
        }
    }

    private void setSrc(String src) {
        this.getElement().setAttribute("src", src);
    }

    public void setFocus(boolean focus) {
        this.setFocus(focus);
    }
}

