/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.buttons;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.gwt.widgets.client.utils.ElementUtils;

public class RoundedButton
extends Widget
implements HasClickHandlers {
    private String text = "";
    private String baseStyleName = "roundedbutton";
    private Label label = new Label();
    private Command command;
    private SimplePanel leftPanel = new SimplePanel();
    private SimplePanel rightPanel = new SimplePanel();
    private boolean enabled = true;
    private List<ClickListener> listeners = new ArrayList<ClickListener>();

    public RoundedButton() {
        this.createElement();
        this.setStylePrimaryName(this.baseStyleName);
        this.sinkEvents(124);
        this.sinkEvents(2);
    }

    public RoundedButton(String text) {
        this();
        this.setText(text);
    }

    public RoundedButton(String text, Command command) {
        this(text);
        this.command = command;
    }

    private void createElement() {
        HorizontalPanel hbox = new HorizontalPanel();
        this.setElement(hbox.getElement());
        hbox.setStyleName(this.baseStyleName);
        super.setStylePrimaryName(this.baseStyleName);
        this.leftPanel.setStylePrimaryName(this.getStylePrimaryName());
        this.leftPanel.addStyleDependentName("left");
        hbox.add((Widget)this.leftPanel);
        hbox.add((Widget)this.label);
        this.rightPanel.setStylePrimaryName(this.getStylePrimaryName());
        this.rightPanel.addStyleDependentName("right");
        hbox.add((Widget)this.rightPanel);
        this.leftPanel.setStylePrimaryName(this.getStylePrimaryName());
        this.rightPanel.setStylePrimaryName(this.getStylePrimaryName());
        this.label.getElement().getParentElement().setClassName(this.getStylePrimaryName() + "-slice");
        this.label.setStylePrimaryName(this.getStylePrimaryName());
        this.label.addStyleDependentName("label");
        ElementUtils.preventTextSelection((Element)this.label.getElement());
    }

    public void setStylePrimaryName(String style) {
        super.setStylePrimaryName(style);
        this.baseStyleName = style;
        this.label.setStylePrimaryName(style + "-label");
        this.rightPanel.setStylePrimaryName(style + "-right");
        this.leftPanel.setStylePrimaryName(style + "-left");
        this.label.getElement().getParentElement().setClassName(style + "-slice");
    }

    public void addStyleDependentName(String style) {
        super.addStyleDependentName(style);
        this.label.addStyleDependentName(style);
        this.rightPanel.addStyleDependentName(style);
        this.leftPanel.addStyleDependentName(style);
        this.label.getElement().getParentElement().setClassName(this.getStylePrimaryName() + "-slice-" + style);
    }

    public void removeStyleDependentName(String style) {
        super.removeStyleDependentName(style);
        this.label.removeStyleDependentName(style);
        this.rightPanel.removeStyleDependentName(style);
        this.leftPanel.removeStyleDependentName(style);
        this.label.getElement().getParentElement().setClassName(this.getStylePrimaryName() + "-slice");
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.label.setText(text);
    }

    public void setEnabled(boolean enabled) {
        boolean prevVal = this.enabled;
        this.enabled = enabled;
        if (prevVal && enabled) {
            return;
        }
        if (!enabled) {
            this.addStyleDependentName("disabled");
        } else if (enabled) {
            this.removeStyleDependentName("disabled");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void onBrowserEvent(Event event) {
        switch (event.getTypeInt()) {
            case 8: {
                if (!this.isEnabled()) break;
                this.fireClicked();
                if (this.command != null) {
                    this.command.execute();
                }
                this.removeStyleDependentName("over");
                event.cancelBubble(true);
                event.preventDefault();
                break;
            }
            case 2: {
                event.cancelBubble(true);
                event.preventDefault();
                break;
            }
            case 16: {
                if (!this.isEnabled()) break;
                this.addStyleDependentName("over");
                break;
            }
            case 32: {
                if (!this.isEnabled()) break;
                this.removeStyleDependentName("over");
            }
        }
    }

    public HandlerRegistration addClickHandler(ClickHandler handler) {
        return this.addDomHandler((EventHandler)handler, ClickEvent.getType());
    }

    private void fireClicked() {
        for (ClickListener listener : this.listeners) {
            listener.onClick((Widget)this);
        }
        NativeEvent evt = Document.get().createClickEvent(0, 0, 0, 0, 0, false, false, false, false);
        DomEvent.fireNativeEvent((NativeEvent)evt, (HasHandlers)this);
    }

    @Deprecated
    public void addClickListener(ClickListener listener) {
        this.listeners.add(listener);
    }

    @Deprecated
    public void removeClickListener(ClickListener listener) {
        this.listeners.remove(listener);
    }

    public void setFocus(boolean focus) {
        this.setFocus(focus);
    }
}

