/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.colorpicker;

public class Color {
    private float h;
    private float s;
    private float v;
    private float r;
    private float g;
    private float b;
    private String hex;

    public void setHSV(int h, int s, int v) throws Exception {
        if (h < 0 || h > 360) {
            throw new Exception();
        }
        if (s < 0 || s > 100) {
            throw new Exception();
        }
        if (v < 0 || v > 100) {
            throw new Exception();
        }
        this.h = h;
        this.s = (float)s / 100.0f;
        this.v = (float)v / 100.0f;
        this.HSVtoRGB(this.h, this.s, this.v);
        this.setHex();
    }

    public void setRGB(int r, int g, int b) throws Exception {
        if (r < 0 || r > 255) {
            throw new Exception();
        }
        if (g < 0 || g > 255) {
            throw new Exception();
        }
        if (b < 0 || b > 255) {
            throw new Exception();
        }
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.RGBtoHSV(this.r, this.g, this.b);
        this.setHex();
    }

    public void setHex(String hex) throws Exception {
        if (hex.length() != 6) {
            throw new Exception();
        }
        this.setRGB(Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16), Integer.parseInt(hex.substring(4, 6), 16));
    }

    private void setHex() {
        String hRed = Integer.toHexString(this.getRed());
        String hGreen = Integer.toHexString(this.getGreen());
        String hBlue = Integer.toHexString(this.getBlue());
        if (hRed.length() == 0) {
            hRed = "00";
        }
        if (hRed.length() == 1) {
            hRed = "0" + hRed;
        }
        if (hGreen.length() == 0) {
            hGreen = "00";
        }
        if (hGreen.length() == 1) {
            hGreen = "0" + hGreen;
        }
        if (hBlue.length() == 0) {
            hBlue = "00";
        }
        if (hBlue.length() == 1) {
            hBlue = "0" + hBlue;
        }
        this.hex = hRed + hGreen + hBlue;
    }

    public int getRed() {
        return (int)(this.r * 255.0f);
    }

    public int getGreen() {
        return (int)(this.g * 255.0f);
    }

    public int getBlue() {
        return (int)(this.b * 255.0f);
    }

    public int getHue() {
        return (int)this.h;
    }

    public int getSaturation() {
        return (int)(this.s * 100.0f);
    }

    public int getValue() {
        return (int)(this.v * 100.0f);
    }

    public String getHex() {
        return this.hex;
    }

    private void RGBtoHSV(float r, float g, float b) {
        float min = 0.0f;
        float max = 0.0f;
        float delta = 0.0f;
        min = this.MIN(r, g, b);
        this.v = max = this.MAX(r, g, b);
        delta = max - min;
        if (max == 0.0f) {
            this.s = 0.0f;
            this.h = 0.0f;
            return;
        }
        this.s = delta / max;
        if (delta == 0.0f) {
            this.h = 0.0f;
            return;
        }
        this.h = r == max ? (g - b) / delta : (g == max ? 2.0f + (b - r) / delta : 4.0f + (r - g) / delta);
        this.h *= 60.0f;
        if (this.h < 0.0f) {
            this.h += 360.0f;
        }
    }

    private void HSVtoRGB(float h, float s, float v) {
        if (s == 0.0f) {
            this.r = v;
            this.g = v;
            this.b = v;
            return;
        }
        int i = (int)Math.floor(h /= 60.0f);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i) {
            case 0: {
                this.r = v;
                this.g = t;
                this.b = p;
                break;
            }
            case 1: {
                this.r = q;
                this.g = v;
                this.b = p;
                break;
            }
            case 2: {
                this.r = p;
                this.g = v;
                this.b = t;
                break;
            }
            case 3: {
                this.r = p;
                this.g = q;
                this.b = v;
                break;
            }
            case 4: {
                this.r = t;
                this.g = p;
                this.b = v;
                break;
            }
            default: {
                this.r = v;
                this.g = p;
                this.b = q;
            }
        }
    }

    private float MAX(float a, float b, float c) {
        float max = -2.1474836E9f;
        if (a > max) {
            max = a;
        }
        if (b > max) {
            max = b;
        }
        if (c > max) {
            max = c;
        }
        return max;
    }

    private float MIN(float a, float b, float c) {
        float min = 2.1474836E9f;
        if (a < min) {
            min = a;
        }
        if (b < min) {
            min = b;
        }
        if (c < min) {
            min = c;
        }
        return min;
    }
}

