/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.colorpicker;

import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.CustomButton;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.colorpicker.Color;

public class ColorPalette
extends Composite
implements ClickListener,
KeyboardListener,
ChangeListener {
    protected String DEFAULT_COLOR = "FFFFFF";
    protected int cols = 12;
    protected int rows = 4;
    protected String colorBoxWidth = "5px";
    protected String colorBoxHeight = "5px";
    protected int horzSpacing = 5;
    protected int vertSpacing = 5;
    protected String colorBoxBorderColor = "D0D0D0";
    protected boolean advancedMode = false;
    protected Color[] colorArray = null;
    VerticalPanel mainPanel = new VerticalPanel();
    VerticalPanel palettePanel = null;

    public ColorPalette() throws Exception {
        this.mainPanel.setVisible(false);
        this.refreshPalette();
        this.refreshDisplay();
        this.mainPanel.setVisible(true);
    }

    protected void refreshDisplay() {
        CustomButton paletteItem = null;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                paletteItem = new CustomButton(){
                    {
                        this.setHTML("<div style=\"color: #ff0000; background-color: #ff0000;\">test</div>");
                    }
                };
                this.mainPanel.add((Widget)paletteItem);
            }
        }
    }

    protected void refreshPalette() throws Exception {
        Color[] tempColorArray = this.colorArray;
        int colorArrayIndex = 0;
        this.colorArray = new Color[this.cols * this.rows];
        if (tempColorArray != null && tempColorArray.length != this.cols * this.rows) {
            for (int i = 0; i < tempColorArray.length && colorArrayIndex < this.colorArray.length; ++i) {
                if (tempColorArray[i] == null) continue;
                this.colorArray[colorArrayIndex++] = tempColorArray[i];
            }
        }
        while (colorArrayIndex < this.colorArray.length) {
            this.colorArray[colorArrayIndex] = new Color();
            this.colorArray[colorArrayIndex].setHex(this.DEFAULT_COLOR);
            ++colorArrayIndex;
        }
    }

    public void onAttach() {
        super.onAttach();
    }

    public void onClick(Widget sender) {
    }

    public void onKeyDown(Widget sender, char keyCode, int modifiers) {
    }

    public void onKeyPress(Widget sender, char keyCode, int modifiers) {
        switch (keyCode) {
            case '\r': {
                break;
            }
            case '\u001b': {
                break;
            }
            case '&': {
                break;
            }
            case '(': {
                break;
            }
            case '%': {
                break;
            }
            case '\'': {
                break;
            }
            case '$': {
                break;
            }
        }
    }

    public void onKeyUp(Widget sender, char keyCode, int modifiers) {
    }

    public void onChange(Widget sender) {
    }
}

