/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.colorpicker;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.colorpicker.Color;
import org.pentaho.gwt.widgets.client.colorpicker.SliderBar;
import org.pentaho.gwt.widgets.client.colorpicker.SliderMap;

public class ColorPicker
extends Composite
implements ClickListener,
KeyboardListener,
ChangeListener {
    private HTML colorpreview;
    private SliderMap slidermap;
    private SliderBar sliderbar;
    private TextBox tbHue;
    private TextBox tbSaturation;
    private TextBox tbBrightness;
    private TextBox tbRed;
    private TextBox tbGreen;
    private TextBox tbBlue;
    private TextBox tbHexColor;
    private RadioButton rbHue;
    private RadioButton rbSaturation;
    private RadioButton rbBrightness;
    private RadioButton rbRed;
    private RadioButton rbGreen;
    private RadioButton rbBlue;
    private int colorMode;
    private int red = 255;
    private int green = 0;
    private int blue = 0;
    private int hue = 0;
    private int saturation = 100;
    private int brightness = 100;

    public ColorPicker() {
        HorizontalPanel panel = new HorizontalPanel();
        FlexTable table = new FlexTable();
        this.slidermap = new SliderMap(this);
        panel.add((Widget)this.slidermap);
        panel.setCellWidth((Widget)this.slidermap, "258px");
        panel.setCellHeight((Widget)this.slidermap, "258px");
        this.sliderbar = new SliderBar(this);
        panel.add((Widget)this.sliderbar);
        panel.setCellWidth((Widget)this.sliderbar, "40px");
        panel.setCellHeight((Widget)this.sliderbar, "258px");
        this.colorpreview = new HTML("");
        this.colorpreview.setWidth("50px");
        this.colorpreview.setHeight("50px");
        DOM.setStyleAttribute((Element)this.colorpreview.getElement(), (String)"border", (String)"1px solid black");
        this.rbHue = new RadioButton("color", "H:");
        this.rbHue.addClickListener((ClickListener)this);
        this.rbSaturation = new RadioButton("color", "S:");
        this.rbSaturation.addClickListener((ClickListener)this);
        this.rbBrightness = new RadioButton("color", "V:");
        this.rbBrightness.addClickListener((ClickListener)this);
        this.rbRed = new RadioButton("color", "R:");
        this.rbRed.addClickListener((ClickListener)this);
        this.rbGreen = new RadioButton("color", "G:");
        this.rbGreen.addClickListener((ClickListener)this);
        this.rbBlue = new RadioButton("color", "B:");
        this.rbBlue.addClickListener((ClickListener)this);
        this.tbHue = new TextBox();
        this.tbHue.setText(new Integer(this.hue).toString());
        this.tbHue.setMaxLength(3);
        this.tbHue.setVisibleLength(4);
        this.tbHue.addKeyboardListener((KeyboardListener)this);
        this.tbHue.addChangeListener((ChangeListener)this);
        this.tbSaturation = new TextBox();
        this.tbSaturation.setText(new Integer(this.saturation).toString());
        this.tbSaturation.setMaxLength(3);
        this.tbSaturation.setVisibleLength(4);
        this.tbSaturation.addKeyboardListener((KeyboardListener)this);
        this.tbSaturation.addChangeListener((ChangeListener)this);
        this.tbBrightness = new TextBox();
        this.tbBrightness.setText(new Integer(this.brightness).toString());
        this.tbBrightness.setMaxLength(3);
        this.tbBrightness.setVisibleLength(4);
        this.tbBrightness.addKeyboardListener((KeyboardListener)this);
        this.tbBrightness.addChangeListener((ChangeListener)this);
        this.tbRed = new TextBox();
        this.tbRed.setText(new Integer(this.red).toString());
        this.tbRed.setMaxLength(3);
        this.tbRed.setVisibleLength(4);
        this.tbRed.addKeyboardListener((KeyboardListener)this);
        this.tbRed.addChangeListener((ChangeListener)this);
        this.tbGreen = new TextBox();
        this.tbGreen.setText(new Integer(this.green).toString());
        this.tbGreen.setMaxLength(3);
        this.tbGreen.setVisibleLength(4);
        this.tbGreen.addKeyboardListener((KeyboardListener)this);
        this.tbGreen.addChangeListener((ChangeListener)this);
        this.tbBlue = new TextBox();
        this.tbBlue.setText(new Integer(this.blue).toString());
        this.tbBlue.setMaxLength(3);
        this.tbBlue.setVisibleLength(4);
        this.tbBlue.addKeyboardListener((KeyboardListener)this);
        this.tbBlue.addChangeListener((ChangeListener)this);
        this.tbHexColor = new TextBox();
        this.tbHexColor.setText("ff0000");
        this.tbHexColor.setMaxLength(6);
        this.tbHexColor.setVisibleLength(6);
        this.tbHexColor.addKeyboardListener((KeyboardListener)this);
        this.tbHexColor.addChangeListener((ChangeListener)this);
        table.setWidget(0, 0, (Widget)this.colorpreview);
        table.getFlexCellFormatter().setColSpan(0, 0, 3);
        table.setWidget(1, 0, (Widget)this.rbHue);
        table.setWidget(1, 1, (Widget)this.tbHue);
        table.setWidget(1, 2, (Widget)new HTML("&deg;"));
        table.setWidget(2, 0, (Widget)this.rbSaturation);
        table.setWidget(2, 1, (Widget)this.tbSaturation);
        table.setText(2, 2, "%");
        table.setWidget(3, 0, (Widget)this.rbBrightness);
        table.setWidget(3, 1, (Widget)this.tbBrightness);
        table.setText(3, 2, "%");
        table.setWidget(4, 0, (Widget)this.rbRed);
        table.setWidget(4, 1, (Widget)this.tbRed);
        table.setWidget(5, 0, (Widget)this.rbGreen);
        table.setWidget(5, 1, (Widget)this.tbGreen);
        table.setWidget(6, 0, (Widget)this.rbBlue);
        table.setWidget(6, 1, (Widget)this.tbBlue);
        table.setText(7, 0, "#:");
        table.setWidget(7, 1, (Widget)this.tbHexColor);
        table.getFlexCellFormatter().setColSpan(7, 1, 2);
        panel.add((Widget)table);
        this.rbSaturation.setChecked(true);
        this.setPreview("ff0000");
        DOM.setStyleAttribute((Element)this.colorpreview.getElement(), (String)"cursor", (String)"default");
        this.onClick((Widget)this.rbSaturation);
        this.initWidget((Widget)panel);
    }

    public void onAttach() {
        super.onAttach();
        this.colorMode = -1;
        this.updateSliders();
    }

    private void setPreview(String hex) {
        DOM.setStyleAttribute((Element)this.colorpreview.getElement(), (String)"backgroundColor", (String)("#" + hex));
    }

    public void onMapSelected(int x, int y) {
        switch (this.colorMode) {
            case 3: {
                this.saturation = this.percentOf(x, 100);
                this.brightness = 100 - this.percentOf(y, 100);
                this.tbSaturation.setText(Integer.toString(this.saturation));
                this.tbBrightness.setText(Integer.toString(this.brightness));
                this.onChange((Widget)this.tbHue);
                break;
            }
            case 1: {
                this.hue = this.percentOf(x, 360);
                this.brightness = 100 - this.percentOf(y, 100);
                this.tbHue.setText(Integer.toString(this.hue));
                this.tbBrightness.setText(Integer.toString(this.brightness));
                this.onChange((Widget)this.tbSaturation);
                break;
            }
            case 2: {
                this.hue = this.percentOf(x, 360);
                this.saturation = 100 - this.percentOf(y, 100);
                this.tbHue.setText(Integer.toString(this.hue));
                this.tbSaturation.setText(Integer.toString(this.saturation));
                this.onChange((Widget)this.tbBrightness);
                break;
            }
            case 4: {
                this.blue = x;
                this.green = 256 - y;
                this.tbBlue.setText(Integer.toString(this.blue));
                this.tbGreen.setText(Integer.toString(this.green));
                this.onChange((Widget)this.tbRed);
                break;
            }
            case 5: {
                this.blue = x;
                this.red = 256 - y;
                this.tbBlue.setText(Integer.toString(this.blue));
                this.tbRed.setText(Integer.toString(this.red));
                this.onChange((Widget)this.tbGreen);
                break;
            }
            case 6: {
                this.red = x;
                this.green = 256 - y;
                this.tbRed.setText(Integer.toString(this.red));
                this.tbGreen.setText(Integer.toString(this.green));
                this.onChange((Widget)this.tbBlue);
            }
        }
    }

    public void onBarSelected(int y) {
        switch (this.colorMode) {
            case 3: {
                this.hue = 360 - this.percentOf(y, 360);
                this.tbHue.setText(Integer.toString(this.hue));
                this.onChange((Widget)this.tbHue);
                break;
            }
            case 1: {
                this.saturation = 100 - this.percentOf(y, 100);
                this.tbSaturation.setText(Integer.toString(this.saturation));
                this.onChange((Widget)this.tbSaturation);
                break;
            }
            case 2: {
                this.brightness = 100 - this.percentOf(y, 100);
                this.tbBrightness.setText(Integer.toString(this.brightness));
                this.onChange((Widget)this.tbBrightness);
                break;
            }
            case 4: {
                this.red = 255 - y;
                this.tbRed.setText(Integer.toString(this.red));
                this.onChange((Widget)this.tbRed);
                break;
            }
            case 5: {
                this.green = 255 - y;
                this.tbGreen.setText(Integer.toString(this.green));
                this.onChange((Widget)this.tbGreen);
                break;
            }
            case 6: {
                this.blue = 255 - y;
                this.tbBlue.setText(Integer.toString(this.blue));
                this.onChange((Widget)this.tbBlue);
            }
        }
    }

    public void onClick(Widget sender) {
        Color color;
        if (sender == this.rbHue) {
            if (this.colorMode != 3) {
                this.colorMode = 3;
                this.slidermap.setColorSelectMode(3);
                this.sliderbar.setColorSelectMode(3);
                this.slidermap.setOverlayOpacity(100);
                this.sliderbar.setLayerOpacity(100, 4);
            }
            try {
                color = new Color();
                color.setHSV(this.hue, 100, 100);
                this.slidermap.setOverlayColor("#" + color.getHex());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.sliderbar.setSliderPosition(256 - (int)(new Integer(this.hue).floatValue() / 360.0f * 256.0f));
            this.slidermap.setSliderPosition((int)(new Integer(this.saturation).floatValue() / 100.0f * 256.0f), 256 - (int)(new Integer(this.brightness).floatValue() / 100.0f * 256.0f));
        } else if (sender == this.rbSaturation) {
            if (this.colorMode != 1) {
                this.colorMode = 1;
                this.slidermap.setColorSelectMode(1);
                this.sliderbar.setColorSelectMode(1);
                this.slidermap.setOverlayColor("transparent");
                this.sliderbar.setLayerColor("#ffffff", 3);
                this.sliderbar.setLayerOpacity(100, 4);
            }
            this.slidermap.setOverlayOpacity(100 - this.saturation);
            this.sliderbar.setLayerColor(this.tbHexColor.getText(), 4);
            this.sliderbar.setSliderPosition(256 - (int)(new Integer(this.saturation).floatValue() / 100.0f * 256.0f));
            this.slidermap.setSliderPosition((int)(new Integer(this.hue).floatValue() / 360.0f * 256.0f), 256 - (int)(new Integer(this.brightness).floatValue() / 100.0f * 256.0f));
        } else if (sender == this.rbBrightness) {
            if (this.colorMode != 2) {
                this.colorMode = 2;
                this.slidermap.setColorSelectMode(2);
                this.sliderbar.setColorSelectMode(2);
                this.slidermap.setUnderlayColor("#000000");
                this.slidermap.setOverlayColor("transparent");
                this.sliderbar.setLayerOpacity(100, 4);
            }
            try {
                color = new Color();
                color.setHSV(this.hue, this.saturation, 100);
                this.sliderbar.setLayerColor("#" + color.getHex(), 4);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.slidermap.setOverlayOpacity(this.brightness);
            this.sliderbar.setSliderPosition(256 - (int)(new Integer(this.brightness).floatValue() / 100.0f * 256.0f));
            this.slidermap.setSliderPosition((int)(new Integer(this.hue).floatValue() / 360.0f * 256.0f), 256 - (int)(new Integer(this.saturation).floatValue() / 100.0f * 256.0f));
        } else if (sender == this.rbRed) {
            if (this.colorMode != 4) {
                this.colorMode = 4;
                this.slidermap.setColorSelectMode(4);
                this.sliderbar.setColorSelectMode(4);
            }
            this.slidermap.setOverlayOpacity(this.percentOf(this.red, 100));
            this.sliderbar.setSliderPosition(256 - this.red);
            this.slidermap.setSliderPosition(this.blue, 256 - this.green);
        } else if (sender == this.rbGreen) {
            if (this.colorMode != 5) {
                this.colorMode = 5;
                this.slidermap.setColorSelectMode(5);
                this.sliderbar.setColorSelectMode(5);
            }
            this.slidermap.setOverlayOpacity(this.percentOf(this.green, 100));
            this.sliderbar.setSliderPosition(256 - this.green);
            this.slidermap.setSliderPosition(this.blue, 256 - this.red);
        } else if (sender == this.rbBlue) {
            if (this.colorMode != 6) {
                this.colorMode = 6;
                this.slidermap.setColorSelectMode(6);
                this.sliderbar.setColorSelectMode(6);
            }
            this.slidermap.setOverlayOpacity(this.percentOf(this.blue, 100));
            this.sliderbar.setSliderPosition(256 - this.blue);
            this.slidermap.setSliderPosition(this.red, 256 - this.green);
        }
        if (this.colorMode == 4 || this.colorMode == 5 || this.colorMode == 6) {
            int x = 0;
            int y = 0;
            if (this.colorMode == 4) {
                x = this.blue;
                y = this.green;
            }
            if (this.colorMode == 5) {
                x = this.blue;
                y = this.red;
            }
            if (this.colorMode == 6) {
                x = this.red;
                y = this.green;
            }
            int horzPer = (int)(new Float(x).floatValue() / 256.0f * 100.0f);
            int vertPer = (int)(new Float(y).floatValue() / 256.0f * 100.0f);
            int horzPerRev = (int)((256.0f - new Float(x).floatValue()) / 256.0f * 100.0f);
            int vertPerRev = (int)((256.0f - new Float(y).floatValue()) / 256.0f * 100.0f);
            if (vertPerRev > horzPerRev) {
                this.sliderbar.setLayerOpacity(horzPerRev, 4);
            } else {
                this.sliderbar.setLayerOpacity(vertPerRev, 4);
            }
            if (vertPerRev > horzPer) {
                this.sliderbar.setLayerOpacity(horzPer, 3);
            } else {
                this.sliderbar.setLayerOpacity(vertPerRev, 3);
            }
            if (vertPer > horzPer) {
                this.sliderbar.setLayerOpacity(horzPer, 2);
            } else {
                this.sliderbar.setLayerOpacity(vertPer, 2);
            }
            if (vertPer > horzPerRev) {
                this.sliderbar.setLayerOpacity(horzPerRev, 1);
            } else {
                this.sliderbar.setLayerOpacity(vertPer, 1);
            }
        }
    }

    public void onChange(Widget sender) {
        Color color;
        if (sender == this.tbHexColor) {
            try {
                color = new Color();
                color.setHex(this.tbHexColor.getText());
                this.tbHue.setText(Integer.toString(color.getHue()));
                this.tbSaturation.setText(Integer.toString(color.getSaturation()));
                this.tbBrightness.setText(Integer.toString(color.getValue()));
                this.tbRed.setText(Integer.toString(color.getRed()));
                this.tbGreen.setText(Integer.toString(color.getGreen()));
                this.tbBlue.setText(Integer.toString(color.getBlue()));
                this.tbHexColor.setText(color.getHex());
                this.setPreview(color.getHex());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (sender == this.tbRed || sender == this.tbGreen || sender == this.tbBlue) {
            try {
                if (Integer.parseInt(((TextBox)sender).getText()) > 255) {
                    ((TextBox)sender).setText("255");
                }
                if (Integer.parseInt(((TextBox)sender).getText()) < 0) {
                    ((TextBox)sender).setText("0");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.red = Integer.parseInt(this.tbRed.getText());
            this.green = Integer.parseInt(this.tbGreen.getText());
            this.blue = Integer.parseInt(this.tbBlue.getText());
            this.hue = Integer.parseInt(this.tbHue.getText());
            this.saturation = Integer.parseInt(this.tbSaturation.getText());
            this.brightness = Integer.parseInt(this.tbBrightness.getText());
            try {
                color = new Color();
                color.setRGB(this.red, this.green, this.blue);
                this.tbHue.setText(Integer.toString(color.getHue()));
                this.tbSaturation.setText(Integer.toString(color.getSaturation()));
                this.tbBrightness.setText(Integer.toString(color.getValue()));
                this.tbHexColor.setText(color.getHex());
                this.setPreview(color.getHex());
            }
            catch (Exception e) {}
        } else if (sender == this.tbHue || sender == this.tbSaturation || sender == this.tbBrightness) {
            try {
                if (Integer.parseInt(this.tbHue.getText()) > 359) {
                    this.tbHue.setText("359");
                }
                if (Integer.parseInt(this.tbSaturation.getText()) > 100) {
                    this.tbSaturation.setText("100");
                }
                if (Integer.parseInt(this.tbBrightness.getText()) > 100) {
                    this.tbBrightness.setText("100");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.red = Integer.parseInt(this.tbRed.getText());
            this.green = Integer.parseInt(this.tbGreen.getText());
            this.blue = Integer.parseInt(this.tbBlue.getText());
            this.hue = Integer.parseInt(this.tbHue.getText());
            this.saturation = Integer.parseInt(this.tbSaturation.getText());
            this.brightness = Integer.parseInt(this.tbBrightness.getText());
            try {
                color = new Color();
                color.setHSV(this.hue, this.saturation, this.brightness);
                this.tbRed.setText(Integer.toString(color.getRed()));
                this.tbGreen.setText(Integer.toString(color.getGreen()));
                this.tbBlue.setText(Integer.toString(color.getBlue()));
                this.tbHexColor.setText(color.getHex());
                this.setPreview(color.getHex());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.updateSliders();
    }

    public void onKeyPress(Widget sender, char keyCode, int modifiers) {
        if (sender == this.tbHexColor) {
            if (!Character.isDigit(keyCode) && keyCode != 'A' && keyCode != 'a' && keyCode != 'B' && keyCode != 'b' && keyCode != 'C' && keyCode != 'c' && keyCode != 'D' && keyCode != 'd' && keyCode != 'E' && keyCode != 'e' && keyCode != 'F' && keyCode != 'f' && keyCode != '\t' && keyCode != '\b' && keyCode != '.' && keyCode != '\r' && keyCode != '$' && keyCode != '#' && keyCode != '%' && keyCode != '&' && keyCode != '\'' && keyCode != '(') {
                ((TextBox)sender).cancelKey();
            }
        } else if (!Character.isDigit(keyCode) && keyCode != '\t' && keyCode != '\b' && keyCode != '.' && keyCode != '\r' && keyCode != '$' && keyCode != '#' && keyCode != '%' && keyCode != '&' && keyCode != '\'' && keyCode != '(') {
            ((TextBox)sender).cancelKey();
        }
    }

    public void onKeyUp(Widget sender, char keyCode, int modifiers) {
        this.onChange(sender);
    }

    public void onKeyDown(Widget sender, char keyCode, int modifiers) {
    }

    public void setRGB(int red, int green, int blue) throws Exception {
        Color color = new Color();
        color.setRGB(red, green, blue);
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.hue = color.getHue();
        this.saturation = color.getSaturation();
        this.brightness = color.getValue();
        this.tbRed.setText(Integer.toString(this.red));
        this.tbGreen.setText(Integer.toString(this.green));
        this.tbBlue.setText(Integer.toString(this.blue));
        this.tbHue.setText(Integer.toString(this.hue));
        this.tbSaturation.setText(Integer.toString(this.saturation));
        this.tbBrightness.setText(Integer.toString(this.brightness));
        this.tbHexColor.setText(color.getHex());
        this.setPreview(color.getHex());
        this.updateSliders();
    }

    public void setHSV(int hue, int saturation, int value) throws Exception {
        Color color = new Color();
        color.setHSV(hue, saturation, value);
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = value;
        this.tbRed.setText(Integer.toString(this.red));
        this.tbGreen.setText(Integer.toString(this.green));
        this.tbBlue.setText(Integer.toString(this.blue));
        this.tbHue.setText(Integer.toString(this.hue));
        this.tbSaturation.setText(Integer.toString(this.saturation));
        this.tbBrightness.setText(Integer.toString(this.brightness));
        this.tbHexColor.setText(color.getHex());
        this.setPreview(color.getHex());
        this.updateSliders();
    }

    public void setHex(String hex) throws Exception {
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        Color color = new Color();
        color.setHex(hex);
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
        this.hue = color.getHue();
        this.saturation = color.getSaturation();
        this.brightness = color.getValue();
        this.tbRed.setText(Integer.toString(this.red));
        this.tbGreen.setText(Integer.toString(this.green));
        this.tbBlue.setText(Integer.toString(this.blue));
        this.tbHue.setText(Integer.toString(this.hue));
        this.tbSaturation.setText(Integer.toString(this.saturation));
        this.tbBrightness.setText(Integer.toString(this.brightness));
        this.tbHexColor.setText(color.getHex());
        this.setPreview(color.getHex());
        this.updateSliders();
    }

    public String getHexColor() {
        return this.tbHexColor.getText();
    }

    private int percentOf(int val1, int val2) {
        return (int)(new Float(val1).floatValue() / 256.0f * (float)val2);
    }

    private void updateSliders() {
        if (this.rbHue.isChecked()) {
            this.onClick((Widget)this.rbHue);
        }
        if (this.rbSaturation.isChecked()) {
            this.onClick((Widget)this.rbSaturation);
        }
        if (this.rbBrightness.isChecked()) {
            this.onClick((Widget)this.rbBrightness);
        }
        if (this.rbRed.isChecked()) {
            this.onClick((Widget)this.rbRed);
        }
        if (this.rbGreen.isChecked()) {
            this.onClick((Widget)this.rbGreen);
        }
        if (this.rbBlue.isChecked()) {
            this.onClick((Widget)this.rbBlue);
        }
    }
}

