/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.colorpicker;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventPreview;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import org.pentaho.gwt.widgets.client.colorpicker.ColorPicker;
import org.pentaho.gwt.widgets.client.colorpicker.TransparencyImpl;
import org.pentaho.gwt.widgets.client.colorpicker.images.ColorPickerImageBundle;

public final class SliderBar
extends HTML
implements EventPreview {
    private ColorPickerImageBundle cpImageBundle;
    private Image colorA;
    private Image colorB;
    private Image colorC;
    private Image colorD;
    private Image slider;
    private ColorPicker parent = null;
    private boolean captureMouse = false;
    public static final int Saturation = 1;
    public static final int Brightness = 2;
    public static final int Hue = 3;
    public static final int Red = 4;
    public static final int Green = 5;
    public static final int Blue = 6;
    public static final int BarA = 1;
    public static final int BarB = 2;
    public static final int BarC = 3;
    public static final int BarD = 4;

    public SliderBar(ColorPicker parent) {
        this.parent = parent;
        this.setWidth("40px");
        this.setHeight("256px");
        this.cpImageBundle = (ColorPickerImageBundle)GWT.create(ColorPickerImageBundle.class);
        this.colorA = this.cpImageBundle.bar_white().createImage();
        this.colorB = this.cpImageBundle.bar_white().createImage();
        this.colorC = this.cpImageBundle.bar_white().createImage();
        this.colorD = this.cpImageBundle.bar_saturation().createImage();
        this.slider = this.cpImageBundle.rangearrows().createImage();
        DOM.appendChild((Element)this.getElement(), (Element)this.colorA.getElement());
        DOM.appendChild((Element)this.getElement(), (Element)this.colorB.getElement());
        DOM.appendChild((Element)this.getElement(), (Element)this.colorC.getElement());
        DOM.appendChild((Element)this.getElement(), (Element)this.colorD.getElement());
        DOM.appendChild((Element)this.getElement(), (Element)this.slider.getElement());
        DOM.setStyleAttribute((Element)this.getElement(), (String)"position", (String)"absolute");
        DOM.setStyleAttribute((Element)this.colorA.getElement(), (String)"border", (String)"1px solid black");
        DOM.setStyleAttribute((Element)this.colorB.getElement(), (String)"border", (String)"1px solid black");
        DOM.setStyleAttribute((Element)this.colorC.getElement(), (String)"border", (String)"1px solid black");
        DOM.setStyleAttribute((Element)this.colorD.getElement(), (String)"border", (String)"1px solid black");
    }

    public void onAttach() {
        super.onAttach();
        DOM.setStyleAttribute((Element)this.colorA.getElement(), (String)"position", (String)"absolute");
        DOM.setStyleAttribute((Element)this.colorA.getElement(), (String)"left", (String)"10px");
        DOM.setStyleAttribute((Element)this.colorA.getElement(), (String)"top", (String)"0px");
        DOM.setStyleAttribute((Element)this.colorB.getElement(), (String)"position", (String)"absolute");
        DOM.setStyleAttribute((Element)this.colorB.getElement(), (String)"left", (String)"10px");
        DOM.setStyleAttribute((Element)this.colorB.getElement(), (String)"top", (String)"0px");
        DOM.setStyleAttribute((Element)this.colorC.getElement(), (String)"position", (String)"absolute");
        DOM.setStyleAttribute((Element)this.colorC.getElement(), (String)"left", (String)"10px");
        DOM.setStyleAttribute((Element)this.colorC.getElement(), (String)"top", (String)"0px");
        DOM.setStyleAttribute((Element)this.colorD.getElement(), (String)"position", (String)"absolute");
        DOM.setStyleAttribute((Element)this.colorD.getElement(), (String)"left", (String)"10px");
        DOM.setStyleAttribute((Element)this.colorD.getElement(), (String)"top", (String)"0px");
        DOM.setStyleAttribute((Element)this.slider.getElement(), (String)"position", (String)"absolute");
        DOM.setStyleAttribute((Element)this.slider.getElement(), (String)"left", (String)"0px");
        DOM.setStyleAttribute((Element)this.slider.getElement(), (String)"top", (String)"0px");
    }

    public void setLayerOpacity(int alpha, int layer) {
        if (alpha >= 0 && alpha <= 100 && this.isAttached()) {
            Element colorbar;
            switch (layer) {
                case 1: {
                    colorbar = this.colorA.getElement();
                    break;
                }
                case 2: {
                    colorbar = this.colorB.getElement();
                    break;
                }
                case 3: {
                    colorbar = this.colorC.getElement();
                    break;
                }
                case 4: {
                    colorbar = this.colorD.getElement();
                    break;
                }
                default: {
                    return;
                }
            }
            TransparencyImpl.setTransparency(colorbar, alpha);
        }
    }

    public void setLayerColor(String color, int layer) {
        Element colorbar;
        switch (layer) {
            case 1: {
                colorbar = this.colorA.getElement();
                break;
            }
            case 2: {
                colorbar = this.colorB.getElement();
                break;
            }
            case 3: {
                colorbar = this.colorC.getElement();
                break;
            }
            case 4: {
                colorbar = this.colorD.getElement();
                break;
            }
            default: {
                return;
            }
        }
        TransparencyImpl.setBackgroundColor(colorbar, color);
    }

    public void setSliderPosition(int y) {
        if (y < 0) {
            y = 0;
        }
        if (y > 256) {
            y = 256;
        }
        DOM.setStyleAttribute((Element)this.slider.getElement(), (String)"top", (String)(y - 4 + "px"));
    }

    public void setColorSelectMode(int mode) {
        if (!this.isAttached()) {
            return;
        }
        switch (mode) {
            case 1: {
                this.cpImageBundle.bar_white().applyTo(this.colorA);
                this.cpImageBundle.bar_white().applyTo(this.colorB);
                this.cpImageBundle.bar_white().applyTo(this.colorC);
                this.cpImageBundle.bar_saturation().applyTo(this.colorD);
                break;
            }
            case 2: {
                this.cpImageBundle.bar_white().applyTo(this.colorA);
                this.cpImageBundle.bar_white().applyTo(this.colorB);
                this.cpImageBundle.bar_white().applyTo(this.colorC);
                this.cpImageBundle.bar_brightness().applyTo(this.colorD);
                break;
            }
            case 3: {
                this.cpImageBundle.bar_white().applyTo(this.colorA);
                this.cpImageBundle.bar_white().applyTo(this.colorB);
                this.cpImageBundle.bar_white().applyTo(this.colorC);
                this.cpImageBundle.bar_hue().applyTo(this.colorD);
                break;
            }
            case 4: {
                this.cpImageBundle.bar_red_tl().applyTo(this.colorA);
                this.cpImageBundle.bar_red_tr().applyTo(this.colorB);
                this.cpImageBundle.bar_red_br().applyTo(this.colorC);
                this.cpImageBundle.bar_red_bl().applyTo(this.colorD);
                break;
            }
            case 5: {
                this.cpImageBundle.bar_green_tl().applyTo(this.colorA);
                this.cpImageBundle.bar_green_tr().applyTo(this.colorB);
                this.cpImageBundle.bar_green_br().applyTo(this.colorC);
                this.cpImageBundle.bar_green_bl().applyTo(this.colorD);
                break;
            }
            case 6: {
                this.cpImageBundle.bar_blue_tl().applyTo(this.colorA);
                this.cpImageBundle.bar_blue_tr().applyTo(this.colorB);
                this.cpImageBundle.bar_blue_br().applyTo(this.colorC);
                this.cpImageBundle.bar_blue_bl().applyTo(this.colorD);
            }
        }
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType((Event)event)) {
            case 4: {
                this.captureMouse = true;
                DOM.addEventPreview((EventPreview)this);
                this.mouseEvent(event);
            }
        }
    }

    public boolean onEventPreview(Event event) {
        switch (DOM.eventGetType((Event)event)) {
            case 8: {
                this.captureMouse = false;
                DOM.removeEventPreview((EventPreview)this);
                break;
            }
            case 64: {
                if (!this.captureMouse) break;
                this.mouseEvent(event);
                return false;
            }
        }
        return true;
    }

    private void mouseEvent(Event event) {
        DOM.eventPreventDefault((Event)event);
        int y = DOM.eventGetClientY((Event)event) - this.getAbsoluteTop();
        if (y < 0) {
            y = 0;
        }
        if (y > 256) {
            y = 256;
        }
        DOM.setStyleAttribute((Element)this.slider.getElement(), (String)"top", (String)(y - 4 + "px"));
        if (this.parent != null) {
            this.parent.onBarSelected(y);
        }
    }
}

