/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.colorpicker;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventPreview;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import org.pentaho.gwt.widgets.client.colorpicker.ColorPicker;
import org.pentaho.gwt.widgets.client.colorpicker.TransparencyImpl;
import org.pentaho.gwt.widgets.client.colorpicker.images.ColorPickerImageBundle;

public final class SliderMap
extends HTML
implements EventPreview {
    private ColorPickerImageBundle cpImageBundle;
    private Image colorUnderlay;
    private Image colorOverlay;
    private Image slider;
    private ColorPicker parent = null;
    private boolean captureMouse = false;
    public static final int Saturation = 1;
    public static final int Brightness = 2;
    public static final int Hue = 3;
    public static final int Red = 4;
    public static final int Green = 5;
    public static final int Blue = 6;

    public SliderMap(ColorPicker parent) {
        this.parent = parent;
        this.setWidth("256px");
        this.setHeight("256px");
        this.cpImageBundle = (ColorPickerImageBundle)GWT.create(ColorPickerImageBundle.class);
        this.colorUnderlay = this.cpImageBundle.map_saturation().createImage();
        this.colorOverlay = this.cpImageBundle.map_saturation_overlay().createImage();
        this.slider = this.cpImageBundle.mappoint().createImage();
        DOM.appendChild((Element)this.getElement(), (Element)this.colorUnderlay.getElement());
        DOM.appendChild((Element)this.getElement(), (Element)this.colorOverlay.getElement());
        DOM.appendChild((Element)this.getElement(), (Element)this.slider.getElement());
        DOM.setStyleAttribute((Element)this.getElement(), (String)"position", (String)"absolute");
        DOM.setStyleAttribute((Element)this.colorUnderlay.getElement(), (String)"border", (String)"1px solid black");
        DOM.setStyleAttribute((Element)this.colorOverlay.getElement(), (String)"border", (String)"1px solid black");
    }

    public void onAttach() {
        super.onAttach();
        DOM.setStyleAttribute((Element)this.colorUnderlay.getElement(), (String)"position", (String)"absolute");
        DOM.setStyleAttribute((Element)this.colorUnderlay.getElement(), (String)"left", (String)"0px");
        DOM.setStyleAttribute((Element)this.colorUnderlay.getElement(), (String)"top", (String)"0px");
        DOM.setStyleAttribute((Element)this.colorOverlay.getElement(), (String)"position", (String)"absolute");
        DOM.setStyleAttribute((Element)this.colorOverlay.getElement(), (String)"left", (String)"0px");
        DOM.setStyleAttribute((Element)this.colorOverlay.getElement(), (String)"top", (String)"0px");
        DOM.setStyleAttribute((Element)this.slider.getElement(), (String)"position", (String)"absolute");
        DOM.setStyleAttribute((Element)this.slider.getElement(), (String)"left", (String)"0px");
        DOM.setStyleAttribute((Element)this.slider.getElement(), (String)"top", (String)"0px");
        this.setOverlayOpacity(100);
    }

    public void setOverlayOpacity(int alpha) {
        if (alpha >= 0 && alpha <= 100 && this.isAttached()) {
            TransparencyImpl.setTransparency(this.colorOverlay.getElement(), alpha);
        }
    }

    public void setUnderlayColor(String color) {
        DOM.setStyleAttribute((Element)this.colorUnderlay.getElement(), (String)"backgroundColor", (String)color);
    }

    public void setOverlayColor(String color) {
        DOM.setStyleAttribute((Element)this.colorOverlay.getElement(), (String)"backgroundColor", (String)color);
    }

    public void setSliderPosition(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        if (x > 256) {
            x = 256;
        }
        if (y > 256) {
            y = 256;
        }
        DOM.setStyleAttribute((Element)this.slider.getElement(), (String)"left", (String)(x - 7 + "px"));
        DOM.setStyleAttribute((Element)this.slider.getElement(), (String)"top", (String)(y - 7 + "px"));
    }

    public void setColorSelectMode(int mode) {
        if (!this.isAttached()) {
            return;
        }
        switch (mode) {
            case 1: {
                this.cpImageBundle.map_saturation().applyTo(this.colorUnderlay);
                this.cpImageBundle.map_saturation_overlay().applyTo(this.colorOverlay);
                break;
            }
            case 2: {
                this.cpImageBundle.map_white().applyTo(this.colorUnderlay);
                this.cpImageBundle.map_brightness().applyTo(this.colorOverlay);
                break;
            }
            case 3: {
                this.cpImageBundle.map_white().applyTo(this.colorUnderlay);
                this.cpImageBundle.map_hue().applyTo(this.colorOverlay);
                this.setOverlayOpacity(100);
                break;
            }
            case 4: {
                this.cpImageBundle.map_red_max().applyTo(this.colorOverlay);
                this.cpImageBundle.map_red_min().applyTo(this.colorUnderlay);
                break;
            }
            case 5: {
                this.cpImageBundle.map_green_max().applyTo(this.colorOverlay);
                this.cpImageBundle.map_green_min().applyTo(this.colorUnderlay);
                break;
            }
            case 6: {
                this.cpImageBundle.map_blue_max().applyTo(this.colorOverlay);
                this.cpImageBundle.map_blue_min().applyTo(this.colorUnderlay);
            }
        }
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType((Event)event)) {
            case 4: {
                this.captureMouse = true;
                DOM.addEventPreview((EventPreview)this);
                this.mouseEvent(event);
            }
        }
    }

    public boolean onEventPreview(Event event) {
        switch (DOM.eventGetType((Event)event)) {
            case 8: {
                this.captureMouse = false;
                DOM.removeEventPreview((EventPreview)this);
                break;
            }
            case 64: {
                if (!this.captureMouse) break;
                this.mouseEvent(event);
                return false;
            }
        }
        return true;
    }

    private void mouseEvent(Event event) {
        DOM.eventPreventDefault((Event)event);
        int x = DOM.eventGetClientX((Event)event) - this.colorUnderlay.getAbsoluteLeft();
        int y = DOM.eventGetClientY((Event)event) - this.colorUnderlay.getAbsoluteTop();
        if (x < 0) {
            x = 0;
        }
        if (x > 256) {
            x = 256;
        }
        if (y < 0) {
            y = 0;
        }
        if (y > 256) {
            y = 256;
        }
        DOM.setStyleAttribute((Element)this.slider.getElement(), (String)"left", (String)(x - 7 + "px"));
        DOM.setStyleAttribute((Element)this.slider.getElement(), (String)"top", (String)(y - 7 + "px"));
        if (this.parent != null) {
            this.parent.onMapSelected(x, y);
        }
    }
}

