/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.controls;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.gwt.widgets.client.controls.ColorPickerListener;
import org.pentaho.gwt.widgets.client.utils.ElementUtils;
import org.pentaho.gwt.widgets.client.utils.Rectangle;

public class ColorPicker
extends Image {
    private List<ColorPickerListener> listeners = new ArrayList<ColorPickerListener>();
    private ColorPickerDialog picker = new ColorPickerDialog();
    private String selectedColor = "#FFF";

    public ColorPicker() {
        super(GWT.getModuleBaseURL() + "images/color_picker_frame.gif");
        this.getElement().getStyle().setProperty("backgroundColor", "#fff");
        this.getElement().getStyle().setProperty("cursor", "pointer");
        this.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                Rectangle rect = ElementUtils.getSize(ColorPicker.this.getElement());
                ColorPicker.this.picker.setPopupPosition(DOM.getAbsoluteLeft((Element)ColorPicker.this.getElement()), DOM.getAbsoluteTop((Element)ColorPicker.this.getElement()) + rect.height + 2);
                ColorPicker.this.picker.show();
            }
        });
    }

    public String getColor() {
        return this.selectedColor;
    }

    public void setColor(String hex) {
        this.selectedColor = hex;
        this.getElement().getStyle().setProperty("backgroundColor", hex);
        for (ColorPickerListener listener : this.listeners) {
            listener.colorPicked(this);
        }
    }

    public void showPicker() {
        this.picker.center();
    }

    public void addColorPickerListener(ColorPickerListener listener) {
        this.listeners.add(listener);
    }

    private class ColorBox
    extends SimplePanel
    implements HasClickHandlers,
    ClickHandler {
        String color;
        ColorPickerDialog dialog;

        public ColorBox(ColorPickerDialog dialog, String color) {
            this.dialog = dialog;
            this.color = color;
            this.setStyleName("color-swatch");
            SimplePanel panel = new SimplePanel();
            panel.getElement().getStyle().setProperty("border", "1px solid #aaa");
            panel.getElement().getStyle().setProperty("backgroundColor", color);
            this.add((Widget)panel);
            panel.setStyleName("color-swatch-center");
            this.addClickHandler(this);
        }

        public HandlerRegistration addClickHandler(ClickHandler handler) {
            return this.addDomHandler((EventHandler)handler, ClickEvent.getType());
        }

        public void onClick(ClickEvent event) {
            ColorPicker.this.setColor(this.color);
            this.dialog.hide();
        }
    }

    private class ColorPickerDialog
    extends PopupPanel {
        private String[] colors;

        public ColorPickerDialog() {
            super(true);
            this.colors = new String[]{"#000", "#993300", "#333300", "#003300", "#003366", "#000080", "#333399", "#333333", "#800000", "#ff6600", "#808000", "#008000", "#008080", "#0000ff", "#666699", "#808080", "#ff0000", "#ff9900", "#99cc00", "#339966", "#33cccc", "#3366ff", "#800080", "#969696", "#ff00ff", "#ffcc00", "#ffff00", "#00ff00", "#00ffff", "#00ccff", "#993366", "#c0c0c0", "#ff99cc", "#ffcc99", "#ffff99", "#ccffcc", "#ccffff", "#99ccff", "#cc99ff", "#FFF"};
            this.setStyleName("color-picker-popup");
            FlexTable table = new FlexTable();
            table.setCellPadding(0);
            table.setCellSpacing(2);
            int i = 0;
            int row = 0;
            while (i < this.colors.length) {
                for (int y = 0; y < 7 && i < this.colors.length; ++y, ++i) {
                    table.setWidget(row, y, (Widget)new ColorBox(this, this.colors[i]));
                }
                ++i;
                ++row;
            }
            SimplePanel panel = new SimplePanel();
            panel.getElement().getStyle().setProperty("padding", "3px");
            panel.add((Widget)table);
            this.add((Widget)panel);
        }
    }
}

