/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.controls;

import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.datepicker.client.DateBox;
import com.google.gwt.user.datepicker.client.DatePicker;
import java.util.Date;
import org.pentaho.gwt.widgets.client.datepicker.PentahoDatePicker;
import org.pentaho.gwt.widgets.client.ui.ICallback;
import org.pentaho.gwt.widgets.client.ui.IChangeHandler;
import org.pentaho.gwt.widgets.client.utils.TimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatePickerEx
implements IChangeHandler {
    private DateBox.DefaultFormat format = null;
    private DateBox datePicker = null;
    private ICallback<IChangeHandler> onChangeHandler;

    public DatePickerEx() {
        this(new DateBox.DefaultFormat(DateTimeFormat.getShortDateFormat()));
    }

    public DatePickerEx(DateBox.DefaultFormat format) {
        this.datePicker = new DateBox((DatePicker)new PentahoDatePicker(), new Date(), (DateBox.Format)format);
        this.datePicker.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Date>(){

            public void onValueChange(ValueChangeEvent<Date> event) {
                DatePickerEx.this.changeHandler();
            }
        });
        this.configureOnChangeHandler();
    }

    public DateBox getDatePicker() {
        return this.datePicker;
    }

    public Date getSelectedDate() {
        Date d = this.datePicker.getValue();
        if (d != null) {
            return TimeUtil.zeroTimePart(d);
        }
        return null;
    }

    @Override
    public void setOnChangeHandler(ICallback<IChangeHandler> handler) {
        this.onChangeHandler = handler;
    }

    private void changeHandler() {
        if (null != this.onChangeHandler) {
            this.onChangeHandler.onHandle(this);
        }
    }

    private void configureOnChangeHandler() {
    }

    public void synchronizeFromDate() {
        this.changeHandler();
    }

    public DateBox.DefaultFormat getFormat() {
        return this.format;
    }
}

