/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.controls;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import java.util.Date;
import org.pentaho.gwt.widgets.client.controls.DatePickerEx;
import org.pentaho.gwt.widgets.client.controls.ErrorLabel;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessages;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessagesSingleton;
import org.pentaho.gwt.widgets.client.ui.ICallback;
import org.pentaho.gwt.widgets.client.ui.IChangeHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateRangeEditor
extends CaptionPanel
implements IChangeHandler {
    private static final WidgetsLocalizedMessages MSGS = WidgetsLocalizedMessagesSingleton.getInstance().getMessages();
    private static final String SCHEDULE_EDITOR_CAPTION_PANEL = "schedule-editor-caption-panel";
    private static final String END_DATE_RB_GROUP = "end-date-group";
    private static final String END_DATE_PICKER = "end-date-picker";
    private static final String START_DATE_PICKER = "start-date-picker";
    private DatePickerEx startDatePicker = null;
    private EndDatePanel endDatePanel = null;
    private ErrorLabel startLabel = null;
    private ICallback<IChangeHandler> onChangeHandler = null;

    public DateRangeEditor(Date date) {
        super(MSGS.rangeOfRecurrence());
        this.addStyleName(SCHEDULE_EDITOR_CAPTION_PANEL);
        HorizontalPanel outerHP = new HorizontalPanel();
        this.add((Widget)outerHP);
        HorizontalPanel hp = new HorizontalPanel();
        Label l = new Label(MSGS.startLabel());
        l.setStyleName("startLabel");
        hp.add((Widget)l);
        DateBox.DefaultFormat format = new DateBox.DefaultFormat(DateTimeFormat.getShortDateFormat());
        this.startDatePicker = new DatePickerEx(format);
        this.startDatePicker.getDatePicker().setStyleName(START_DATE_PICKER);
        hp.add((Widget)this.startDatePicker.getDatePicker());
        this.startLabel = new ErrorLabel((Widget)hp);
        outerHP.add((Widget)this.startLabel);
        this.endDatePanel = new EndDatePanel(date);
        outerHP.add((Widget)this.endDatePanel);
        this.reset(date);
        this.configureOnChangeHandler();
    }

    public void setStartDateError(String errorMsg) {
        this.startLabel.setErrorMsg(errorMsg);
    }

    public Date getStartDate() {
        return this.startDatePicker.getSelectedDate();
    }

    public void setStartDate(Date d) {
        this.startDatePicker.getDatePicker().setValue(d);
    }

    public Date getEndDate() {
        return this.endDatePanel.getDate();
    }

    public void setEndDate(Date d) {
        this.endDatePanel.setDate(d);
    }

    public void reset(Date d) {
        this.startDatePicker.getDatePicker().setValue(d);
        this.endDatePanel.reset(d);
    }

    public void setNoEndDate() {
        this.endDatePanel.setNoEndDate();
    }

    public boolean isEndBy() {
        return this.endDatePanel.isEndBy();
    }

    public void setEndBy() {
        this.endDatePanel.setEndBy();
    }

    public boolean isNoEndDate() {
        return this.endDatePanel.isNoEndDate();
    }

    public void setEndByError(String errorMsg) {
        this.endDatePanel.setEndByError(errorMsg);
    }

    @Override
    public void setOnChangeHandler(ICallback<IChangeHandler> handler) {
        this.onChangeHandler = handler;
    }

    private void changeHandler() {
        if (null != this.onChangeHandler) {
            this.onChangeHandler.onHandle(this);
        }
    }

    private void configureOnChangeHandler() {
        final DateRangeEditor localThis = this;
        ICallback<IChangeHandler> handler = new ICallback<IChangeHandler>(){

            @Override
            public void onHandle(IChangeHandler o) {
                localThis.changeHandler();
            }
        };
        this.startDatePicker.setOnChangeHandler(handler);
        this.endDatePanel.setOnChangeHandler(handler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EndDatePanel
    extends VerticalPanel
    implements IChangeHandler {
        private DatePickerEx endDatePicker = null;
        private RadioButton noEndDateRb = null;
        private RadioButton endByRb = null;
        private ErrorLabel endByLabel = null;
        private ICallback<IChangeHandler> onChangeHandler = null;

        public EndDatePanel(Date date) {
            final EndDatePanel localThis = this;
            this.noEndDateRb = new RadioButton(DateRangeEditor.END_DATE_RB_GROUP, MSGS.noEndDateLabel());
            this.noEndDateRb.setStyleName("recurrenceRadioButton");
            this.noEndDateRb.setChecked(true);
            this.add((Widget)this.noEndDateRb);
            HorizontalPanel hp = new HorizontalPanel();
            this.add((Widget)hp);
            HorizontalPanel endByPanel = new HorizontalPanel();
            this.endByRb = new RadioButton(DateRangeEditor.END_DATE_RB_GROUP, MSGS.endByLabel());
            this.endByRb.setStyleName("recurrenceRadioButton");
            endByPanel.add((Widget)this.endByRb);
            DateBox.DefaultFormat format = new DateBox.DefaultFormat(DateTimeFormat.getShortDateFormat());
            this.endDatePicker = new DatePickerEx(format);
            this.endDatePicker.getDatePicker().setStyleName(DateRangeEditor.END_DATE_PICKER);
            this.endDatePicker.getDatePicker().setEnabled(false);
            endByPanel.add((Widget)this.endDatePicker.getDatePicker());
            this.endByLabel = new ErrorLabel((Widget)endByPanel);
            hp.add((Widget)this.endByLabel);
            this.noEndDateRb.addClickListener(new ClickListener(){

                public void onClick(Widget sender) {
                    localThis.endDatePicker.getDatePicker().setEnabled(false);
                }
            });
            this.endByRb.addClickListener(new ClickListener(){

                public void onClick(Widget sender) {
                    localThis.endDatePicker.getDatePicker().setEnabled(true);
                }
            });
            this.reset(date);
            this.configureOnChangeHandler();
        }

        public void reset(Date d) {
            this.setNoEndDate();
            this.endDatePicker.getDatePicker().setValue(d);
        }

        public DatePickerEx getEndDatePicker() {
            return this.endDatePicker;
        }

        public void setNoEndDate() {
            this.endByRb.setChecked(false);
            this.noEndDateRb.setChecked(true);
            this.endDatePicker.getDatePicker().setEnabled(false);
        }

        public boolean isEndBy() {
            return this.endByRb.isChecked();
        }

        public void setEndBy() {
            this.noEndDateRb.setChecked(false);
            this.endByRb.setChecked(true);
            this.endDatePicker.getDatePicker().setEnabled(true);
        }

        public boolean isNoEndDate() {
            return this.noEndDateRb.isChecked();
        }

        public Date getDate() {
            return this.isEndBy() ? this.endDatePicker.getSelectedDate() : null;
        }

        public void setDate(Date d) {
            this.endDatePicker.getDatePicker().setValue(d);
        }

        public void setEndByError(String errorMsg) {
            this.endByLabel.setErrorMsg(errorMsg);
        }

        @Override
        public void setOnChangeHandler(ICallback<IChangeHandler> handler) {
            this.onChangeHandler = handler;
        }

        private void changeHandler() {
            if (null != this.onChangeHandler) {
                this.onChangeHandler.onHandle(this);
            }
        }

        private void configureOnChangeHandler() {
            final EndDatePanel localThis = this;
            ICallback<IChangeHandler> handler = new ICallback<IChangeHandler>(){

                @Override
                public void onHandle(IChangeHandler o) {
                    localThis.changeHandler();
                }
            };
            KeyboardListener keyboardListener = new KeyboardListener(){

                public void onKeyDown(Widget sender, char keyCode, int modifiers) {
                }

                public void onKeyPress(Widget sender, char keyCode, int modifiers) {
                }

                public void onKeyUp(Widget sender, char keyCode, int modifiers) {
                    localThis.changeHandler();
                }
            };
            ClickListener clickListener = new ClickListener(){

                public void onClick(Widget sender) {
                    localThis.changeHandler();
                }
            };
            this.endDatePicker.setOnChangeHandler(handler);
            this.noEndDateRb.addClickListener(clickListener);
            this.noEndDateRb.addKeyboardListener(keyboardListener);
            this.endByRb.addClickListener(clickListener);
            this.endByRb.addKeyboardListener(keyboardListener);
        }
    }
}

