/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.controls;

import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.DockPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.buttons.ImageButton;
import org.pentaho.gwt.widgets.client.controls.ErrorLabel;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessages;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessagesSingleton;
import org.pentaho.gwt.widgets.client.ui.ICallback;
import org.pentaho.gwt.widgets.client.utils.ListBoxUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableEditor
extends VerticalPanel {
    private static final WidgetsLocalizedMessages MSGS = WidgetsLocalizedMessagesSingleton.getInstance().getMessages();
    private ImageButton addBtn = new ImageButton("style/images/add.png", "style/images/add_disabled.png", MSGS.addItem(), 15, 15);
    private ImageButton deleteBtn = new ImageButton("style/images/remove.png", "style/images/remove_disabled.png", MSGS.deleteItems(), 15, 15);
    private ListBox actionLb = new ListBox();
    private ErrorLabel errorLabel = null;
    private ICallback<TableEditor> onSelectHandler = null;
    private static int DEFAULT_NUM_VISIBLE_ITEMS = 10;
    private ICallback<TableEditor> onAddHandler = null;
    private ICallback<TableEditor> onDeleteHandler = null;
    private String message = null;

    public TableEditor(String labelText) {
        DockPanel buttonPanel = new DockPanel();
        buttonPanel.add((Widget)this.deleteBtn, DockPanel.EAST);
        VerticalPanel spacer = new VerticalPanel();
        spacer.setWidth("2");
        buttonPanel.add((Widget)spacer, DockPanel.EAST);
        buttonPanel.add((Widget)this.addBtn, DockPanel.EAST);
        this.errorLabel = new ErrorLabel((Widget)new Label(labelText));
        buttonPanel.add((Widget)this.errorLabel, DockPanel.WEST);
        buttonPanel.setCellWidth((Widget)this.errorLabel, "100%");
        this.add((Widget)buttonPanel);
        this.actionLb.setWidth("100%");
        this.actionLb.setHeight("100%");
        this.actionLb.setVisibleItemCount(DEFAULT_NUM_VISIBLE_ITEMS);
        this.actionLb.setMultipleSelect(true);
        final TableEditor localThis = this;
        this.actionLb.addClickListener(new ClickListener(){

            public void onClick(Widget arg0) {
                if (null != TableEditor.this.onSelectHandler) {
                    TableEditor.this.onSelectHandler.onHandle(localThis);
                }
            }
        });
        this.add((Widget)this.actionLb);
        this.setCellHeight((Widget)this.actionLb, "100%");
        this.addBtn.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                localThis.handleAdd();
            }
        });
        this.deleteBtn.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                localThis.handleDeleteSelectedItems();
            }
        });
    }

    private void handleAdd() {
        if (null != this.onAddHandler) {
            this.onAddHandler.onHandle(this);
        }
    }

    private void handleDeleteSelectedItems() {
        this.removeSelectedItems();
        if (null != this.onDeleteHandler) {
            this.onDeleteHandler.onHandle(this);
        }
    }

    public void removeSelectedItems() {
        for (int ii = this.getItemCount() - 1; ii >= 0; --ii) {
            if (!this.actionLb.isItemSelected(ii)) continue;
            this.actionLb.removeItem(ii);
        }
    }

    public void setVisibleItemCount(int numVisibleItems) {
        this.actionLb.setVisibleItemCount(numVisibleItems);
    }

    public int getNumSelectedItems() {
        int count = 0;
        for (int ii = this.getItemCount() - 1; ii >= 0; --ii) {
            if (!this.actionLb.isItemSelected(ii)) continue;
            ++count;
        }
        return count;
    }

    public int getItemCount() {
        return this.actionLb.getItemCount();
    }

    public void removeAll() {
        ListBoxUtils.removeAll(this.actionLb);
    }

    private boolean isExist(String item) {
        boolean returnValue = false;
        for (int ii = 0; ii < this.getItemCount(); ++ii) {
            if (this.actionLb.getItemText(ii) == null || !this.actionLb.getItemText(ii).equals(item)) continue;
            returnValue = true;
            break;
        }
        return returnValue;
    }

    public void addItem(String item, String value) {
        if (!this.isExist(item)) {
            this.actionLb.addItem(item);
            this.actionLb.setValue(this.actionLb.getItemCount() - 1, value);
        }
    }

    public String getItemText(int idx) {
        return this.actionLb.getItemText(idx);
    }

    public String getItemValue(int idx) {
        return this.actionLb.getValue(idx);
    }

    public void setOnAddClickedHandler(ICallback<TableEditor> handler) {
        this.onAddHandler = handler;
    }

    public void setOnDeleteClickedHandler(ICallback<TableEditor> handler) {
        this.onDeleteHandler = handler;
    }

    public void setOnSelectHandler(ICallback<TableEditor> onSelectHandler) {
        this.onSelectHandler = onSelectHandler;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorLabel.setErrorMsg(errorMsg);
    }

    @Deprecated
    public void setFocus() {
    }

    public void setAddBtnEnabled(boolean enabled) {
        this.addBtn.setEnabled(enabled);
    }

    public void setDeleteBtnEnabled(boolean enabled) {
        this.deleteBtn.setEnabled(enabled);
    }

    public void setMessage(String message) {
        this.actionLb.addItem(message);
        this.message = message;
    }

    public void clearMessage() {
        if (null != this.message) {
            for (int ii = 0; ii < this.actionLb.getItemCount(); ++ii) {
                String item = this.actionLb.getItemText(ii);
                if (!this.message.equals(item)) continue;
                this.actionLb.removeItem(ii);
                return;
            }
        }
        this.message = null;
    }
}

