/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.controls;

import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.ui.ICallback;
import org.pentaho.gwt.widgets.client.ui.IChangeHandler;
import org.pentaho.gwt.widgets.client.utils.TimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimePicker
extends HorizontalPanel
implements IChangeHandler {
    private ListBox hourLB = new ListBox();
    private ListBox minuteLB = new ListBox();
    private ListBox timeOfDayLB = new ListBox();
    private ICallback<IChangeHandler> onChangeHandler = null;

    public TimePicker() {
        this.setSpacing(5);
        this.initHourLB();
        this.initMinuteLB();
        this.initAmPmLB();
        this.add((Widget)this.hourLB);
        this.add((Widget)this.minuteLB);
        this.add((Widget)this.timeOfDayLB);
        this.configureOnChangeHandler();
    }

    public void setTime(String time) {
        String[] parts = time.split(":");
        String[] lastParts = parts[2].split("\\s");
        this.setHour(parts[0]);
        this.setMinute(parts[1]);
        TimeUtil.TimeOfDay td = TimeUtil.TimeOfDay.stringToTimeOfDay(lastParts[1]);
        this.setTimeOfDay(td);
    }

    public String getTime() {
        StringBuilder sb = new StringBuilder(this.getHour()).append(":").append(this.getMinute()).append(":").append("00 ").append(this.getTimeOfDay().toString());
        return sb.toString();
    }

    private void initHourLB() {
        this.hourLB.setVisibleItemCount(1);
        for (int ii = 1; ii <= 12; ++ii) {
            String strHrDisplay = Integer.toString(ii);
            strHrDisplay = strHrDisplay.length() == 1 ? "0" + strHrDisplay : strHrDisplay;
            String strHrValue = ii == 12 ? "0" : Integer.toString(ii);
            this.hourLB.addItem(strHrDisplay, strHrValue);
        }
    }

    private void initMinuteLB() {
        this.minuteLB.setVisibleItemCount(1);
        for (int ii = 0; ii < 60; ++ii) {
            String strMinute = Integer.toString(ii);
            strMinute = strMinute.length() == 1 ? "0" + strMinute : strMinute;
            this.minuteLB.addItem(strMinute);
        }
    }

    private void initAmPmLB() {
        this.timeOfDayLB.setVisibleItemCount(1);
        this.timeOfDayLB.addItem(TimeUtil.TimeOfDay.AM.toString());
        this.timeOfDayLB.addItem(TimeUtil.TimeOfDay.PM.toString());
    }

    public String getHour() {
        return this.hourLB.getValue(this.hourLB.getSelectedIndex());
    }

    public void setHour(String hour) {
        this.hourLB.setSelectedIndex(Integer.parseInt(hour) - 1);
    }

    public String getMinute() {
        return this.minuteLB.getValue(this.minuteLB.getSelectedIndex());
    }

    public void setMinute(String minute) {
        this.minuteLB.setSelectedIndex(Integer.parseInt(minute));
    }

    public TimeUtil.TimeOfDay getTimeOfDay() {
        return TimeUtil.TimeOfDay.get(this.timeOfDayLB.getSelectedIndex());
    }

    public void setTimeOfDay(TimeUtil.TimeOfDay timeOfDay) {
        this.timeOfDayLB.setSelectedIndex(timeOfDay.value());
    }

    @Override
    public void setOnChangeHandler(ICallback<IChangeHandler> handler) {
        this.onChangeHandler = handler;
    }

    private void changeHandler() {
        if (null != this.onChangeHandler) {
            this.onChangeHandler.onHandle(this);
        }
    }

    private void configureOnChangeHandler() {
        final TimePicker localThis = this;
        ChangeListener changeListener = new ChangeListener(){

            public void onChange(Widget sender) {
                localThis.changeHandler();
            }
        };
        this.hourLB.addChangeListener(changeListener);
        this.minuteLB.addChangeListener(changeListener);
        this.timeOfDayLB.addChangeListener(changeListener);
    }
}

