/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.controls.schededitor;

import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.gwt.widgets.client.controls.DateRangeEditor;
import org.pentaho.gwt.widgets.client.controls.ErrorLabel;
import org.pentaho.gwt.widgets.client.controls.TimePicker;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessages;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessagesSingleton;
import org.pentaho.gwt.widgets.client.ui.ICallback;
import org.pentaho.gwt.widgets.client.ui.IChangeHandler;
import org.pentaho.gwt.widgets.client.utils.CronParseException;
import org.pentaho.gwt.widgets.client.utils.CronParser;
import org.pentaho.gwt.widgets.client.utils.EnumException;
import org.pentaho.gwt.widgets.client.utils.StringUtils;
import org.pentaho.gwt.widgets.client.utils.TimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecurrenceEditor
extends VerticalPanel
implements IChangeHandler {
    private static final WidgetsLocalizedMessages MSGS = WidgetsLocalizedMessagesSingleton.getInstance().getMessages();
    private static final String SCHEDULE_EDITOR_CAPTION_PANEL = "schedule-editor-caption-panel";
    private static final String DOW_CHECKBOX = "day-of-week-checkbox";
    private TimePicker startTimePicker = null;
    private SecondlyRecurrenceEditor secondlyEditor = null;
    private MinutelyRecurrenceEditor minutelyEditor = null;
    private HourlyRecurrenceEditor hourlyEditor = null;
    private DailyRecurrenceEditor dailyEditor = null;
    private WeeklyRecurrenceEditor weeklyEditor = null;
    private MonthlyRecurrenceEditor monthlyEditor = null;
    private YearlyRecurrenceEditor yearlyEditor = null;
    private DateRangeEditor dateRangeEditor = null;
    private TemporalValue temporalState = null;
    private static final String SPACE = " ";
    private static int VALUE_OF_SUNDAY = 1;
    private ICallback<IChangeHandler> onChangeHandler;
    private Map<TemporalValue, Panel> temporalPanelMap = new HashMap<TemporalValue, Panel>();
    private static final String DAILY_RB_GROUP = "daily-group";
    private static final String MONTHLY_RB_GROUP = "monthly-group";

    public RecurrenceEditor() {
        this.setWidth("100%");
        Widget p = this.createStartTimePanel();
        this.add(p);
        p = this.createRecurrencePanel();
        this.add(p);
        Date now = new Date();
        this.dateRangeEditor = new DateRangeEditor(now);
        this.add((Widget)this.dateRangeEditor);
        this.configureOnChangeHandler();
    }

    public void reset(Date d) {
        this.startTimePicker.setHour("12");
        this.startTimePicker.setMinute("00");
        this.startTimePicker.setTimeOfDay(TimeUtil.TimeOfDay.AM);
        this.dateRangeEditor.reset(d);
        this.secondlyEditor.reset();
        this.minutelyEditor.reset();
        this.hourlyEditor.reset();
        this.dailyEditor.reset();
        this.weeklyEditor.reset();
        this.monthlyEditor.reset();
        this.yearlyEditor.reset();
    }

    public void inititalizeWithRecurrenceString(String recurrenceStr) throws EnumException {
        String[] recurrenceTokens = recurrenceStr.split("\\s");
        this.setStartTime(recurrenceTokens[1], recurrenceTokens[2], recurrenceTokens[3]);
        CronParser.RecurrenceType rt = CronParser.RecurrenceType.stringToScheduleType(recurrenceTokens[0]);
        switch (rt) {
            case EveryWeekday: {
                this.setEveryWeekdayRecurrence(recurrenceTokens);
                break;
            }
            case WeeklyOn: {
                this.setWeeklyOnRecurrence(recurrenceTokens);
                break;
            }
            case DayNOfMonth: {
                this.setDayNOfMonthRecurrence(recurrenceTokens);
                break;
            }
            case NthDayNameOfMonth: {
                this.setNthDayNameOfMonthRecurrence(recurrenceTokens);
                break;
            }
            case LastDayNameOfMonth: {
                this.setLastDayNameOfMonthRecurrence(recurrenceTokens);
                break;
            }
            case EveryMonthNameN: {
                this.setEveryMonthNameNRecurrence(recurrenceTokens);
                break;
            }
            case NthDayNameOfMonthName: {
                this.setNthDayNameOfMonthNameRecurrence(recurrenceTokens);
                break;
            }
            case LastDayNameOfMonthName: {
                this.setLastDayNameOfMonthNameRecurrence(recurrenceTokens);
                break;
            }
        }
    }

    private void setStartTime(String seconds, String minutes, String hours) {
        TimeUtil.TimeOfDay td = TimeUtil.getTimeOfDayBy0To23Hour(hours);
        int intHours = Integer.parseInt(hours);
        int intTwelveHour = TimeUtil.to12HourClock(intHours);
        this.startTimePicker.setHour(Integer.toString(TimeUtil.map0Through11To12Through11(intTwelveHour)));
        this.startTimePicker.setMinute(minutes);
        this.startTimePicker.setTimeOfDay(td);
    }

    private void setEveryWeekdayRecurrence(String[] recurrenceTokens) {
        this.setTemporalState(TemporalValue.DAILY);
        this.dailyEditor.setEveryWeekday();
    }

    private void setWeeklyOnRecurrence(String[] recurrenceTokens) {
        this.setTemporalState(TemporalValue.WEEKLY);
        String days = recurrenceTokens[4];
        this.weeklyEditor.setCheckedDaysAsString(days, VALUE_OF_SUNDAY);
    }

    private void setDayNOfMonthRecurrence(String[] recurrenceTokens) {
        this.setTemporalState(TemporalValue.MONTHLY);
        this.monthlyEditor.setDayNOfMonth();
        String dayNOfMonth = recurrenceTokens[4];
        this.monthlyEditor.setDayOfMonth(dayNOfMonth);
    }

    private void setNthDayNameOfMonthRecurrence(String[] recurrenceTokens) {
        this.setTemporalState(TemporalValue.MONTHLY);
        this.monthlyEditor.setNthDayNameOfMonth();
        this.monthlyEditor.setWeekOfMonth(TimeUtil.WeekOfMonth.get(Integer.parseInt(recurrenceTokens[5]) - 1));
        this.monthlyEditor.setDayOfWeek(TimeUtil.DayOfWeek.get(Integer.parseInt(recurrenceTokens[4]) - 1));
    }

    private void setLastDayNameOfMonthRecurrence(String[] recurrenceTokens) {
        this.setTemporalState(TemporalValue.MONTHLY);
        this.monthlyEditor.setNthDayNameOfMonth();
        this.monthlyEditor.setWeekOfMonth(TimeUtil.WeekOfMonth.LAST);
        this.monthlyEditor.setDayOfWeek(TimeUtil.DayOfWeek.get(Integer.parseInt(recurrenceTokens[4]) - 1));
    }

    private void setEveryMonthNameNRecurrence(String[] recurrenceTokens) {
        this.setTemporalState(TemporalValue.YEARLY);
        this.yearlyEditor.setEveryMonthOnNthDay();
        this.yearlyEditor.setDayOfMonth(recurrenceTokens[4]);
        this.yearlyEditor.setMonthOfYear0(TimeUtil.MonthOfYear.get(Integer.parseInt(recurrenceTokens[5]) - 1));
    }

    private void setNthDayNameOfMonthNameRecurrence(String[] recurrenceTokens) {
        this.setTemporalState(TemporalValue.YEARLY);
        this.yearlyEditor.setNthDayNameOfMonthName();
        this.yearlyEditor.setMonthOfYear1(TimeUtil.MonthOfYear.get(Integer.parseInt(recurrenceTokens[6]) - 1));
        this.yearlyEditor.setWeekOfMonth(TimeUtil.WeekOfMonth.get(Integer.parseInt(recurrenceTokens[5]) - 1));
        this.yearlyEditor.setDayOfWeek(TimeUtil.DayOfWeek.get(Integer.parseInt(recurrenceTokens[4]) - 1));
    }

    private void setLastDayNameOfMonthNameRecurrence(String[] recurrenceTokens) {
        this.setTemporalState(TemporalValue.YEARLY);
        this.yearlyEditor.setNthDayNameOfMonthName();
        this.yearlyEditor.setMonthOfYear1(TimeUtil.MonthOfYear.get(Integer.parseInt(recurrenceTokens[5]) - 1));
        this.yearlyEditor.setWeekOfMonth(TimeUtil.WeekOfMonth.LAST);
        this.yearlyEditor.setDayOfWeek(TimeUtil.DayOfWeek.get(Integer.parseInt(recurrenceTokens[4]) - 1));
    }

    public void inititalizeWithRepeatInSecs(int repeatInSecs) {
        TemporalValue currentVal;
        if (TimeUtil.isSecondsWholeDay(repeatInSecs)) {
            long repeatTime = TimeUtil.secsToDays(repeatInSecs);
            currentVal = TemporalValue.DAILY;
            this.dailyEditor.setRepeatValue(Long.toString(repeatTime));
        } else {
            long repeatTime;
            SimpleRecurrencePanel p = null;
            if (TimeUtil.isSecondsWholeHour(repeatInSecs)) {
                repeatTime = TimeUtil.secsToHours(repeatInSecs);
                currentVal = TemporalValue.HOURS;
            } else if (TimeUtil.isSecondsWholeMinute(repeatInSecs)) {
                repeatTime = TimeUtil.secsToMinutes(repeatInSecs);
                currentVal = TemporalValue.MINUTES;
            } else {
                repeatTime = repeatInSecs;
                currentVal = TemporalValue.SECONDS;
            }
            p = (SimpleRecurrencePanel)this.temporalPanelMap.get((Object)currentVal);
            p.setValue(Long.toString(repeatTime));
        }
        this.setTemporalState(currentVal);
    }

    private Widget createStartTimePanel() {
        CaptionPanel startTimeGB = new CaptionPanel(MSGS.startTime());
        startTimeGB.setStyleName(SCHEDULE_EDITOR_CAPTION_PANEL);
        this.startTimePicker = new TimePicker();
        startTimeGB.add((Widget)this.startTimePicker);
        return startTimeGB;
    }

    private Widget createRecurrencePanel() {
        CaptionPanel recurrenceGB = new CaptionPanel(MSGS.recurrencePattern());
        recurrenceGB.setStyleName(SCHEDULE_EDITOR_CAPTION_PANEL);
        VerticalPanel p = new VerticalPanel();
        recurrenceGB.add((Widget)p);
        this.secondlyEditor = new SecondlyRecurrenceEditor();
        this.secondlyEditor.setVisible(true);
        this.minutelyEditor = new MinutelyRecurrenceEditor();
        this.hourlyEditor = new HourlyRecurrenceEditor();
        this.dailyEditor = new DailyRecurrenceEditor();
        this.weeklyEditor = new WeeklyRecurrenceEditor();
        this.monthlyEditor = new MonthlyRecurrenceEditor();
        this.yearlyEditor = new YearlyRecurrenceEditor();
        this.createTemporalMap();
        p.add((Widget)this.secondlyEditor);
        p.add((Widget)this.minutelyEditor);
        p.add((Widget)this.hourlyEditor);
        p.add((Widget)this.dailyEditor);
        p.add((Widget)this.weeklyEditor);
        p.add((Widget)this.monthlyEditor);
        p.add((Widget)this.yearlyEditor);
        return recurrenceGB;
    }

    private void createTemporalMap() {
        assert (this.dailyEditor != null) : "Temporal panels must be initialized before calling createTemporalCombo.";
        this.temporalPanelMap.put(TemporalValue.SECONDS, (Panel)this.secondlyEditor);
        this.temporalPanelMap.put(TemporalValue.MINUTES, (Panel)this.minutelyEditor);
        this.temporalPanelMap.put(TemporalValue.HOURS, (Panel)this.hourlyEditor);
        this.temporalPanelMap.put(TemporalValue.DAILY, (Panel)this.dailyEditor);
        this.temporalPanelMap.put(TemporalValue.WEEKLY, (Panel)this.weeklyEditor);
        this.temporalPanelMap.put(TemporalValue.MONTHLY, (Panel)this.monthlyEditor);
        this.temporalPanelMap.put(TemporalValue.YEARLY, (Panel)this.yearlyEditor);
    }

    private ListBox createDayOfWeekListBox() {
        ListBox l = new ListBox();
        for (int ii = 0; ii < TimeUtil.DayOfWeek.length(); ++ii) {
            TimeUtil.DayOfWeek day = TimeUtil.DayOfWeek.get(ii);
            l.addItem(day.toString());
        }
        return l;
    }

    private ListBox createMonthOfYearListBox() {
        ListBox l = new ListBox();
        for (int ii = 0; ii < TimeUtil.MonthOfYear.length(); ++ii) {
            TimeUtil.MonthOfYear month = TimeUtil.MonthOfYear.get(ii);
            l.addItem(month.toString());
        }
        return l;
    }

    private ListBox createWhichWeekListBox() {
        ListBox l = new ListBox();
        for (TimeUtil.WeekOfMonth week : EnumSet.range(TimeUtil.WeekOfMonth.FIRST, TimeUtil.WeekOfMonth.LAST)) {
            l.addItem(week.toString());
        }
        return l;
    }

    private void selectTemporalPanel(TemporalValue selectedTemporalValue) {
        for (Map.Entry<TemporalValue, Panel> me : this.temporalPanelMap.entrySet()) {
            boolean bShow = me.getKey().equals((Object)selectedTemporalValue);
            me.getValue().setVisible(bShow);
        }
    }

    public Long getRepeatInSecs() throws RuntimeException {
        switch (this.temporalState) {
            case WEEKLY: 
            case MONTHLY: 
            case YEARLY: {
                return null;
            }
            case SECONDS: {
                return Long.parseLong(this.secondlyEditor.getValue());
            }
            case MINUTES: {
                return TimeUtil.minutesToSecs(Long.parseLong(this.minutelyEditor.getValue()));
            }
            case HOURS: {
                return TimeUtil.hoursToSecs(Long.parseLong(this.hourlyEditor.getValue()));
            }
            case DAILY: {
                return TimeUtil.daysToSecs(Long.parseLong(this.dailyEditor.getRepeatValue()));
            }
        }
        throw new RuntimeException(MSGS.invalidTemporalValueInGetRepeatInSecs(this.temporalState.toString()));
    }

    public String getCronString() throws RuntimeException {
        switch (this.temporalState) {
            case SECONDS: 
            case MINUTES: 
            case HOURS: {
                return null;
            }
            case DAILY: {
                return this.getDailyCronString();
            }
            case WEEKLY: {
                return this.getWeeklyCronString();
            }
            case MONTHLY: {
                return this.getMonthlyCronString();
            }
            case YEARLY: {
                return this.getYearlyCronString();
            }
        }
        throw new RuntimeException(MSGS.invalidTemporalValueInGetCronString(this.temporalState.toString()));
    }

    private String getDailyCronString() throws RuntimeException {
        String cronStr;
        StringBuilder recurrenceSb = new StringBuilder();
        if (this.dailyEditor.isEveryNDays()) {
            return null;
        }
        recurrenceSb.append((Object)CronParser.RecurrenceType.EveryWeekday).append(SPACE).append((CharSequence)this.getTimeOfRecurrence());
        try {
            cronStr = CronParser.recurrenceStringToCronString(recurrenceSb.toString());
        }
        catch (CronParseException e) {
            throw new RuntimeException(MSGS.invalidRecurrenceString(recurrenceSb.toString()));
        }
        return cronStr;
    }

    private String getWeeklyCronString() throws RuntimeException {
        String cronStr;
        StringBuilder recurrenceSb = new StringBuilder();
        recurrenceSb.append((Object)CronParser.RecurrenceType.WeeklyOn).append(SPACE).append((CharSequence)this.getTimeOfRecurrence()).append(SPACE).append(this.weeklyEditor.getCheckedDaysAsString(VALUE_OF_SUNDAY));
        try {
            cronStr = CronParser.recurrenceStringToCronString(recurrenceSb.toString());
        }
        catch (CronParseException e) {
            throw new RuntimeException(MSGS.invalidRecurrenceString(recurrenceSb.toString()));
        }
        return cronStr;
    }

    private String getMonthlyCronString() throws RuntimeException {
        String cronStr;
        StringBuilder recurrenceSb = new StringBuilder();
        if (this.monthlyEditor.isDayNOfMonth()) {
            recurrenceSb.append((Object)CronParser.RecurrenceType.DayNOfMonth).append(SPACE).append((CharSequence)this.getTimeOfRecurrence()).append(SPACE).append(this.monthlyEditor.getDayOfMonth());
        } else if (this.monthlyEditor.isNthDayNameOfMonth()) {
            if (this.monthlyEditor.getWeekOfMonth() != TimeUtil.WeekOfMonth.LAST) {
                String weekOfMonth = Integer.toString(this.monthlyEditor.getWeekOfMonth().value() + 1);
                String dayOfWeek = Integer.toString(this.monthlyEditor.getDayOfWeek().value() + 1);
                recurrenceSb.append((Object)CronParser.RecurrenceType.NthDayNameOfMonth).append(SPACE).append((CharSequence)this.getTimeOfRecurrence()).append(SPACE).append(dayOfWeek).append(SPACE).append(weekOfMonth);
            } else {
                String dayOfWeek = Integer.toString(this.monthlyEditor.getDayOfWeek().value() + 1);
                recurrenceSb.append((Object)CronParser.RecurrenceType.LastDayNameOfMonth).append(SPACE).append((CharSequence)this.getTimeOfRecurrence()).append(SPACE).append(dayOfWeek);
            }
        } else {
            throw new RuntimeException(MSGS.noRadioBtnsSelected());
        }
        try {
            cronStr = CronParser.recurrenceStringToCronString(recurrenceSb.toString());
        }
        catch (CronParseException e) {
            throw new RuntimeException(MSGS.invalidRecurrenceString(recurrenceSb.toString()));
        }
        return cronStr;
    }

    private String getYearlyCronString() throws RuntimeException {
        String cronStr;
        StringBuilder recurrenceSb = new StringBuilder();
        if (this.yearlyEditor.isEveryMonthOnNthDay()) {
            String monthOfYear = Integer.toString(this.yearlyEditor.getMonthOfYear0().value() + 1);
            recurrenceSb.append((Object)CronParser.RecurrenceType.EveryMonthNameN).append(SPACE).append((CharSequence)this.getTimeOfRecurrence()).append(SPACE).append(this.yearlyEditor.getDayOfMonth()).append(SPACE).append(monthOfYear);
        } else if (this.yearlyEditor.isNthDayNameOfMonthName()) {
            if (this.yearlyEditor.getWeekOfMonth() != TimeUtil.WeekOfMonth.LAST) {
                String monthOfYear = Integer.toString(this.yearlyEditor.getMonthOfYear1().value() + 1);
                String dayOfWeek = Integer.toString(this.yearlyEditor.getDayOfWeek().value() + 1);
                String weekOfMonth = Integer.toString(this.yearlyEditor.getWeekOfMonth().value() + 1);
                recurrenceSb.append((Object)CronParser.RecurrenceType.NthDayNameOfMonthName).append(SPACE).append((CharSequence)this.getTimeOfRecurrence()).append(SPACE).append(dayOfWeek).append(SPACE).append(weekOfMonth).append(SPACE).append(monthOfYear);
            } else {
                String monthOfYear = Integer.toString(this.yearlyEditor.getMonthOfYear1().value() + 1);
                String dayOfWeek = Integer.toString(this.yearlyEditor.getDayOfWeek().value() + 1);
                recurrenceSb.append((Object)CronParser.RecurrenceType.LastDayNameOfMonthName).append(SPACE).append((CharSequence)this.getTimeOfRecurrence()).append(SPACE).append(dayOfWeek).append(SPACE).append(monthOfYear);
            }
        } else {
            throw new RuntimeException(MSGS.noRadioBtnsSelected());
        }
        try {
            cronStr = CronParser.recurrenceStringToCronString(recurrenceSb.toString());
        }
        catch (CronParseException e) {
            throw new RuntimeException(MSGS.invalidRecurrenceString(recurrenceSb.toString()));
        }
        return cronStr;
    }

    private StringBuilder getTimeOfRecurrence() {
        int timeOfDayAdjust = this.startTimePicker.getTimeOfDay().equals((Object)TimeUtil.TimeOfDay.AM) ? 0 : 12;
        String strHour = StringUtils.addStringToInt(this.startTimePicker.getHour(), timeOfDayAdjust);
        return new StringBuilder().append("00").append(SPACE).append(this.startTimePicker.getMinute()).append(SPACE).append(strHour);
    }

    public void setStartTime(String startTime) {
        this.startTimePicker.setTime(startTime);
    }

    public String getStartTime() {
        return this.startTimePicker.getTime();
    }

    public void setStartDate(Date startDate) {
        this.dateRangeEditor.setStartDate(startDate);
    }

    public Date getStartDate() {
        return this.dateRangeEditor.getStartDate();
    }

    public void setEndDate(Date endDate) {
        this.dateRangeEditor.setEndDate(endDate);
    }

    public Date getEndDate() {
        return this.dateRangeEditor.getEndDate();
    }

    public void setNoEndDate() {
        this.dateRangeEditor.setNoEndDate();
    }

    public void setEndBy() {
        this.dateRangeEditor.setEndBy();
    }

    public TemporalValue getTemporalState() {
        return this.temporalState;
    }

    public void setTemporalState(TemporalValue temporalState) {
        this.temporalState = temporalState;
        this.selectTemporalPanel(temporalState);
    }

    public DateRangeEditor getDateRangeEditor() {
        return this.dateRangeEditor;
    }

    public SecondlyRecurrenceEditor getSecondlyEditor() {
        return this.secondlyEditor;
    }

    public MinutelyRecurrenceEditor getMinutelyEditor() {
        return this.minutelyEditor;
    }

    public HourlyRecurrenceEditor getHourlyEditor() {
        return this.hourlyEditor;
    }

    public DailyRecurrenceEditor getDailyEditor() {
        return this.dailyEditor;
    }

    public WeeklyRecurrenceEditor getWeeklyEditor() {
        return this.weeklyEditor;
    }

    public MonthlyRecurrenceEditor getMonthlyEditor() {
        return this.monthlyEditor;
    }

    public YearlyRecurrenceEditor getYearlyEditor() {
        return this.yearlyEditor;
    }

    @Override
    public void setOnChangeHandler(ICallback<IChangeHandler> handler) {
        this.onChangeHandler = handler;
    }

    private void changeHandler() {
        if (null != this.onChangeHandler) {
            this.onChangeHandler.onHandle(this);
        }
    }

    private void configureOnChangeHandler() {
        final RecurrenceEditor localThis = this;
        ICallback<IChangeHandler> handler = new ICallback<IChangeHandler>(){

            @Override
            public void onHandle(IChangeHandler o) {
                localThis.changeHandler();
            }
        };
        this.startTimePicker.setOnChangeHandler(handler);
        this.dateRangeEditor.setOnChangeHandler(handler);
        this.secondlyEditor.setOnChangeHandler((ICallback)handler);
        this.minutelyEditor.setOnChangeHandler((ICallback)handler);
        this.hourlyEditor.setOnChangeHandler((ICallback)handler);
        this.dailyEditor.setOnChangeHandler(handler);
        this.weeklyEditor.setOnChangeHandler(handler);
        this.monthlyEditor.setOnChangeHandler(handler);
        this.yearlyEditor.setOnChangeHandler(handler);
    }

    static /* synthetic */ ListBox access$400(RecurrenceEditor x0) {
        return x0.createWhichWeekListBox();
    }

    static /* synthetic */ ListBox access$500(RecurrenceEditor x0) {
        return x0.createDayOfWeekListBox();
    }

    static /* synthetic */ ListBox access$700(RecurrenceEditor x0) {
        return x0.createMonthOfYearListBox();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class YearlyRecurrenceEditor
    extends VerticalPanel
    implements IChangeHandler {
        private RadioButton everyMonthOnNthDayRb = new RadioButton("yearly-group", RecurrenceEditor.access$000().every());
        private RadioButton nthDayNameOfMonthNameRb = new RadioButton("yearly-group", RecurrenceEditor.access$000().the());
        private TextBox dayOfMonthTb = new TextBox();
        private ListBox monthOfYearLb0 = RecurrenceEditor.access$700(RecurrenceEditor.this);
        private ListBox monthOfYearLb1 = RecurrenceEditor.access$700(RecurrenceEditor.this);
        private ListBox whichWeekLb = RecurrenceEditor.access$400(RecurrenceEditor.this);
        private ListBox dayOfWeekLb = RecurrenceEditor.access$500(RecurrenceEditor.this);
        private ErrorLabel dayOfMonthLabel = null;
        private ICallback<IChangeHandler> onChangeHandler;
        private static final String YEARLY_RB_GROUP = "yearly-group";

        public YearlyRecurrenceEditor() {
            this.setVisible(false);
            this.setSpacing(6);
            HorizontalPanel p = new HorizontalPanel();
            this.everyMonthOnNthDayRb.setStyleName("recurrenceRadioButton");
            this.everyMonthOnNthDayRb.setChecked(true);
            p.add((Widget)this.everyMonthOnNthDayRb);
            p.add((Widget)this.monthOfYearLb0);
            this.dayOfMonthTb.setStylePrimaryName("DAY_OF_MONTH_TB");
            this.dayOfMonthTb.setWidth("3em");
            p.add((Widget)this.dayOfMonthTb);
            this.dayOfMonthLabel = new ErrorLabel((Widget)p);
            this.add((Widget)this.dayOfMonthLabel);
            p = new HorizontalPanel();
            this.nthDayNameOfMonthNameRb.setStyleName("recurrenceRadioButton");
            p.add((Widget)this.nthDayNameOfMonthNameRb);
            p.add((Widget)this.whichWeekLb);
            p.add((Widget)this.dayOfWeekLb);
            Label l = new Label(MSGS.of());
            l.setStyleName("middleLabel");
            p.add((Widget)l);
            p.add((Widget)this.monthOfYearLb1);
            this.add((Widget)p);
            this.configureOnChangeHandler();
        }

        public void reset() {
            this.setEveryMonthOnNthDay();
            this.setMonthOfYear0(TimeUtil.MonthOfYear.JAN);
            this.setDayOfMonth("");
            this.setWeekOfMonth(TimeUtil.WeekOfMonth.FIRST);
            this.setDayOfWeek(TimeUtil.DayOfWeek.SUN);
            this.setMonthOfYear1(TimeUtil.MonthOfYear.JAN);
        }

        public boolean isEveryMonthOnNthDay() {
            return this.everyMonthOnNthDayRb.isChecked();
        }

        public void setEveryMonthOnNthDay() {
            this.everyMonthOnNthDayRb.setChecked(true);
            this.nthDayNameOfMonthNameRb.setChecked(false);
        }

        public boolean isNthDayNameOfMonthName() {
            return this.nthDayNameOfMonthNameRb.isChecked();
        }

        public void setNthDayNameOfMonthName() {
            this.nthDayNameOfMonthNameRb.setChecked(true);
            this.everyMonthOnNthDayRb.setChecked(false);
        }

        public String getDayOfMonth() {
            return this.dayOfMonthTb.getText();
        }

        public void setDayOfMonth(String dayOfMonth) {
            this.dayOfMonthTb.setText(dayOfMonth);
        }

        public TimeUtil.WeekOfMonth getWeekOfMonth() {
            return TimeUtil.WeekOfMonth.get(this.whichWeekLb.getSelectedIndex());
        }

        public void setWeekOfMonth(TimeUtil.WeekOfMonth week) {
            this.whichWeekLb.setSelectedIndex(week.value());
        }

        public TimeUtil.DayOfWeek getDayOfWeek() {
            return TimeUtil.DayOfWeek.get(this.dayOfWeekLb.getSelectedIndex());
        }

        public void setDayOfWeek(TimeUtil.DayOfWeek day) {
            this.dayOfWeekLb.setSelectedIndex(day.value());
        }

        public TimeUtil.MonthOfYear getMonthOfYear0() {
            return TimeUtil.MonthOfYear.get(this.monthOfYearLb0.getSelectedIndex());
        }

        public void setMonthOfYear0(TimeUtil.MonthOfYear month) {
            this.monthOfYearLb0.setSelectedIndex(month.value());
        }

        public TimeUtil.MonthOfYear getMonthOfYear1() {
            return TimeUtil.MonthOfYear.get(this.monthOfYearLb1.getSelectedIndex());
        }

        public void setMonthOfYear1(TimeUtil.MonthOfYear month) {
            this.monthOfYearLb1.setSelectedIndex(month.value());
        }

        public void setDayOfMonthError(String errorMsg) {
            this.dayOfMonthLabel.setErrorMsg(errorMsg);
        }

        @Override
        public void setOnChangeHandler(ICallback<IChangeHandler> handler) {
            this.onChangeHandler = handler;
        }

        private void changeHandler() {
            if (null != this.onChangeHandler) {
                this.onChangeHandler.onHandle(this);
            }
        }

        private void configureOnChangeHandler() {
            final YearlyRecurrenceEditor localThis = this;
            KeyboardListener keyboardListener = new KeyboardListener(){

                public void onKeyDown(Widget sender, char keyCode, int modifiers) {
                }

                public void onKeyPress(Widget sender, char keyCode, int modifiers) {
                }

                public void onKeyUp(Widget sender, char keyCode, int modifiers) {
                    localThis.changeHandler();
                }
            };
            ClickListener clickListener = new ClickListener(){

                public void onClick(Widget sender) {
                    localThis.changeHandler();
                }
            };
            ChangeListener changeListener = new ChangeListener(){

                public void onChange(Widget sender) {
                    localThis.changeHandler();
                }
            };
            this.everyMonthOnNthDayRb.addClickListener(clickListener);
            this.everyMonthOnNthDayRb.addKeyboardListener(keyboardListener);
            this.nthDayNameOfMonthNameRb.addClickListener(clickListener);
            this.nthDayNameOfMonthNameRb.addKeyboardListener(keyboardListener);
            this.dayOfMonthTb.addKeyboardListener(keyboardListener);
            this.monthOfYearLb0.addChangeListener(changeListener);
            this.monthOfYearLb1.addChangeListener(changeListener);
            this.whichWeekLb.addChangeListener(changeListener);
            this.dayOfWeekLb.addChangeListener(changeListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MonthlyRecurrenceEditor
    extends VerticalPanel
    implements IChangeHandler {
        private RadioButton dayNOfMonthRb = new RadioButton("monthly-group", RecurrenceEditor.access$000().day());
        private RadioButton nthDayNameOfMonthRb = new RadioButton("monthly-group", RecurrenceEditor.access$000().the());
        private TextBox dayOfMonthTb = new TextBox();
        private ListBox whichWeekLb = RecurrenceEditor.access$400(RecurrenceEditor.this);
        private ListBox dayOfWeekLb = RecurrenceEditor.access$500(RecurrenceEditor.this);
        private ErrorLabel dayNOfMonthLabel = null;
        private ICallback<IChangeHandler> onChangeHandler;

        public MonthlyRecurrenceEditor() {
            this.setVisible(false);
            this.setSpacing(6);
            HorizontalPanel hp = new HorizontalPanel();
            this.dayNOfMonthRb.setStyleName("recurrenceRadioButton");
            this.dayNOfMonthRb.setChecked(true);
            hp.add((Widget)this.dayNOfMonthRb);
            this.dayOfMonthTb.setWidth("3em");
            hp.add((Widget)this.dayOfMonthTb);
            Label l = new Label(MSGS.ofEveryMonth());
            l.setStyleName("endLabel");
            hp.add((Widget)l);
            this.dayNOfMonthLabel = new ErrorLabel((Widget)hp);
            this.add((Widget)this.dayNOfMonthLabel);
            hp = new HorizontalPanel();
            this.nthDayNameOfMonthRb.setStyleName("recurrenceRadioButton");
            hp.add((Widget)this.nthDayNameOfMonthRb);
            hp.add((Widget)this.whichWeekLb);
            hp.add((Widget)this.dayOfWeekLb);
            l = new Label(MSGS.ofEveryMonth());
            l.setStyleName("endLabel");
            hp.add((Widget)l);
            this.add((Widget)hp);
            this.configureOnChangeHandler();
        }

        public void reset() {
            this.setDayNOfMonth();
            this.setDayOfMonth("");
            this.setWeekOfMonth(TimeUtil.WeekOfMonth.FIRST);
            this.setDayOfWeek(TimeUtil.DayOfWeek.SUN);
        }

        public void setDayNOfMonth() {
            this.dayNOfMonthRb.setChecked(true);
            this.nthDayNameOfMonthRb.setChecked(false);
        }

        public boolean isDayNOfMonth() {
            return this.dayNOfMonthRb.isChecked();
        }

        public void setNthDayNameOfMonth() {
            this.nthDayNameOfMonthRb.setChecked(true);
            this.dayNOfMonthRb.setChecked(false);
        }

        public boolean isNthDayNameOfMonth() {
            return this.nthDayNameOfMonthRb.isChecked();
        }

        public String getDayOfMonth() {
            return this.dayOfMonthTb.getText();
        }

        public void setDayOfMonth(String dayOfMonth) {
            this.dayOfMonthTb.setText(dayOfMonth);
        }

        public TimeUtil.WeekOfMonth getWeekOfMonth() {
            return TimeUtil.WeekOfMonth.get(this.whichWeekLb.getSelectedIndex());
        }

        public void setWeekOfMonth(TimeUtil.WeekOfMonth week) {
            this.whichWeekLb.setSelectedIndex(week.value());
        }

        public TimeUtil.DayOfWeek getDayOfWeek() {
            return TimeUtil.DayOfWeek.get(this.dayOfWeekLb.getSelectedIndex());
        }

        public void setDayOfWeek(TimeUtil.DayOfWeek day) {
            this.dayOfWeekLb.setSelectedIndex(day.value());
        }

        public void setDayNOfMonthError(String errorMsg) {
            this.dayNOfMonthLabel.setErrorMsg(errorMsg);
        }

        @Override
        public void setOnChangeHandler(ICallback<IChangeHandler> handler) {
            this.onChangeHandler = handler;
        }

        private void changeHandler() {
            if (null != this.onChangeHandler) {
                this.onChangeHandler.onHandle(this);
            }
        }

        private void configureOnChangeHandler() {
            final MonthlyRecurrenceEditor localThis = this;
            KeyboardListener keyboardListener = new KeyboardListener(){

                public void onKeyDown(Widget sender, char keyCode, int modifiers) {
                }

                public void onKeyPress(Widget sender, char keyCode, int modifiers) {
                }

                public void onKeyUp(Widget sender, char keyCode, int modifiers) {
                    localThis.changeHandler();
                }
            };
            ClickListener clickListener = new ClickListener(){

                public void onClick(Widget sender) {
                    localThis.changeHandler();
                }
            };
            ChangeListener changeListener = new ChangeListener(){

                public void onChange(Widget sender) {
                    localThis.changeHandler();
                }
            };
            this.dayNOfMonthRb.addClickListener(clickListener);
            this.dayNOfMonthRb.addKeyboardListener(keyboardListener);
            this.nthDayNameOfMonthRb.addClickListener(clickListener);
            this.nthDayNameOfMonthRb.addKeyboardListener(keyboardListener);
            this.dayOfMonthTb.addKeyboardListener(keyboardListener);
            this.whichWeekLb.addChangeListener(changeListener);
            this.dayOfWeekLb.addChangeListener(changeListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class WeeklyRecurrenceEditor
    extends VerticalPanel
    implements IChangeHandler {
        private Map<TimeUtil.DayOfWeek, CheckBox> dayToCheckBox = new HashMap<TimeUtil.DayOfWeek, CheckBox>();
        private ErrorLabel everyWeekOnLabel = null;
        private ICallback<IChangeHandler> onChangeHandler;

        public WeeklyRecurrenceEditor() {
            CheckBox cb;
            TimeUtil.DayOfWeek day;
            int ii;
            this.setStyleName("weeklyRecurrencePanel");
            this.setVisible(false);
            Label l = new Label(MSGS.recurEveryWeek());
            this.everyWeekOnLabel = new ErrorLabel((Widget)l);
            l.setStyleName("startLabel");
            this.add((Widget)this.everyWeekOnLabel);
            FlexTable gp = new FlexTable();
            gp.setCellPadding(0);
            gp.setCellSpacing(0);
            int ITEMS_IN_ROW = 4;
            for (ii = 0; ii < 4; ++ii) {
                day = TimeUtil.DayOfWeek.get(ii);
                cb = new CheckBox(day.toString());
                cb.setStylePrimaryName(RecurrenceEditor.DOW_CHECKBOX);
                gp.setWidget(0, ii, (Widget)cb);
                this.dayToCheckBox.put(day, cb);
            }
            for (ii = 4; ii < TimeUtil.DayOfWeek.length(); ++ii) {
                day = TimeUtil.DayOfWeek.get(ii);
                cb = new CheckBox(day.toString());
                cb.setStylePrimaryName(RecurrenceEditor.DOW_CHECKBOX);
                gp.setWidget(1, ii - 4, (Widget)cb);
                this.dayToCheckBox.put(day, cb);
            }
            this.add((Widget)gp);
            this.configureOnChangeHandler();
        }

        public void reset() {
            for (TimeUtil.DayOfWeek d : this.dayToCheckBox.keySet()) {
                CheckBox cb = this.dayToCheckBox.get((Object)d);
                cb.setChecked(false);
            }
        }

        public String getCheckedDaysAsString(int valueOfSunday) {
            StringBuilder sb = new StringBuilder();
            for (TimeUtil.DayOfWeek d : EnumSet.range(TimeUtil.DayOfWeek.SUN, TimeUtil.DayOfWeek.SAT)) {
                CheckBox cb = this.dayToCheckBox.get((Object)d);
                if (!cb.isChecked()) continue;
                sb.append(Integer.toString(d.value() + valueOfSunday)).append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }

        public void setCheckedDaysAsString(String strDays, int valueOfSunday) {
            String[] days;
            for (String day : days = strDays.split(",")) {
                int intDay = Integer.parseInt(day) - valueOfSunday;
                TimeUtil.DayOfWeek dayOfWeek = TimeUtil.DayOfWeek.get(intDay);
                CheckBox cb = this.dayToCheckBox.get((Object)dayOfWeek);
                cb.setChecked(true);
            }
        }

        public int getNumCheckedDays() {
            int numCheckedDays = 0;
            for (Map.Entry<TimeUtil.DayOfWeek, CheckBox> cbEntry : this.dayToCheckBox.entrySet()) {
                if (!cbEntry.getValue().isChecked()) continue;
                ++numCheckedDays;
            }
            return numCheckedDays;
        }

        public void setEveryDayOnError(String errorMsg) {
            this.everyWeekOnLabel.setErrorMsg(errorMsg);
        }

        @Override
        public void setOnChangeHandler(ICallback<IChangeHandler> handler) {
            this.onChangeHandler = handler;
        }

        private void changeHandler() {
            if (null != this.onChangeHandler) {
                this.onChangeHandler.onHandle(this);
            }
        }

        private void configureOnChangeHandler() {
            final WeeklyRecurrenceEditor localThis = this;
            KeyboardListener keyboardListener = new KeyboardListener(){

                public void onKeyDown(Widget sender, char keyCode, int modifiers) {
                }

                public void onKeyPress(Widget sender, char keyCode, int modifiers) {
                }

                public void onKeyUp(Widget sender, char keyCode, int modifiers) {
                    localThis.changeHandler();
                }
            };
            ClickListener clickListener = new ClickListener(){

                public void onClick(Widget sender) {
                    localThis.changeHandler();
                }
            };
            for (TimeUtil.DayOfWeek d : this.dayToCheckBox.keySet()) {
                CheckBox cb = this.dayToCheckBox.get((Object)d);
                cb.addClickListener(clickListener);
                cb.addKeyboardListener(keyboardListener);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DailyRecurrenceEditor
    extends VerticalPanel
    implements IChangeHandler {
        private TextBox repeatValueTb = new TextBox();
        private RadioButton everyNDaysRb = new RadioButton("daily-group", RecurrenceEditor.access$000().every());
        private RadioButton everyWeekdayRb = new RadioButton("daily-group", RecurrenceEditor.access$000().everyWeekDay());
        private ErrorLabel repeatLabel = null;
        private ICallback<IChangeHandler> onChangeHandler;

        public DailyRecurrenceEditor() {
            this.setVisible(false);
            HorizontalPanel hp = new HorizontalPanel();
            this.everyNDaysRb.setStyleName("recurrenceRadioButton");
            this.everyNDaysRb.setChecked(true);
            hp.add((Widget)this.everyNDaysRb);
            this.repeatValueTb.setWidth("3em");
            this.repeatValueTb.setTitle(MSGS.numDaysToRepeat());
            hp.add((Widget)this.repeatValueTb);
            Label l = new Label(MSGS.daysLabel());
            l.setStyleName("endLabel");
            hp.add((Widget)l);
            this.repeatLabel = new ErrorLabel((Widget)hp);
            this.add((Widget)this.repeatLabel);
            this.everyWeekdayRb.setStyleName("recurrenceRadioButton");
            this.add((Widget)this.everyWeekdayRb);
            this.configureOnChangeHandler();
        }

        public void reset() {
            this.setRepeatValue("");
            this.setEveryNDays();
        }

        public String getRepeatValue() {
            return this.repeatValueTb.getText();
        }

        public void setRepeatValue(String repeatValue) {
            this.repeatValueTb.setText(repeatValue);
        }

        public void setEveryNDays() {
            this.everyNDaysRb.setChecked(true);
            this.everyWeekdayRb.setChecked(false);
        }

        public boolean isEveryNDays() {
            return this.everyNDaysRb.isChecked();
        }

        public void setEveryWeekday() {
            this.everyWeekdayRb.setChecked(true);
            this.everyNDaysRb.setChecked(false);
        }

        public boolean isEveryWeekday() {
            return this.everyWeekdayRb.isChecked();
        }

        public void setRepeatError(String errorMsg) {
            this.repeatLabel.setErrorMsg(errorMsg);
        }

        @Override
        public void setOnChangeHandler(ICallback<IChangeHandler> handler) {
            this.onChangeHandler = handler;
        }

        private void changeHandler() {
            if (null != this.onChangeHandler) {
                this.onChangeHandler.onHandle(this);
            }
        }

        private void configureOnChangeHandler() {
            final DailyRecurrenceEditor localThis = this;
            KeyboardListener keyboardListener = new KeyboardListener(){

                public void onKeyDown(Widget sender, char keyCode, int modifiers) {
                }

                public void onKeyPress(Widget sender, char keyCode, int modifiers) {
                }

                public void onKeyUp(Widget sender, char keyCode, int modifiers) {
                    localThis.changeHandler();
                }
            };
            ClickListener clickListener = new ClickListener(){

                public void onClick(Widget sender) {
                    localThis.changeHandler();
                }
            };
            this.repeatValueTb.addKeyboardListener(keyboardListener);
            this.everyNDaysRb.addClickListener(clickListener);
            this.everyNDaysRb.addKeyboardListener(keyboardListener);
            this.everyWeekdayRb.addClickListener(clickListener);
            this.everyWeekdayRb.addKeyboardListener(keyboardListener);
        }
    }

    public class HourlyRecurrenceEditor
    extends SimpleRecurrencePanel {
        public HourlyRecurrenceEditor() {
            super(MSGS.hoursLabel());
        }
    }

    public class MinutelyRecurrenceEditor
    extends SimpleRecurrencePanel {
        public MinutelyRecurrenceEditor() {
            super(MSGS.minutesLabel());
        }
    }

    public class SecondlyRecurrenceEditor
    extends SimpleRecurrencePanel {
        public SecondlyRecurrenceEditor() {
            super(MSGS.seconds());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SimpleRecurrencePanel
    extends VerticalPanel
    implements IChangeHandler {
        private TextBox valueTb = new TextBox();
        private ErrorLabel valueLabel = null;
        private ICallback<IChangeHandler> onChangeHandler;

        public SimpleRecurrencePanel(String strLabel) {
            this.setVisible(false);
            HorizontalPanel hp = new HorizontalPanel();
            Label l = new Label(MSGS.every());
            l.setStyleName("startLabel");
            hp.add((Widget)l);
            this.valueTb.setWidth("3em");
            this.valueTb.setTitle(MSGS.numberOfXToRepeat(strLabel));
            hp.add((Widget)this.valueTb);
            l = new Label(strLabel);
            l.setStyleName("endLabel");
            hp.add((Widget)l);
            this.valueLabel = new ErrorLabel((Widget)hp);
            this.add((Widget)this.valueLabel);
            this.configureOnChangeHandler();
        }

        public String getValue() {
            return this.valueTb.getText();
        }

        public void setValue(String val) {
            this.valueTb.setText(val);
        }

        public void reset() {
            this.setValue("");
        }

        public void setValueError(String errorMsg) {
            this.valueLabel.setErrorMsg(errorMsg);
        }

        @Override
        public void setOnChangeHandler(ICallback<IChangeHandler> handler) {
            this.onChangeHandler = handler;
        }

        private void changeHandler() {
            if (null != this.onChangeHandler) {
                this.onChangeHandler.onHandle(this);
            }
        }

        private void configureOnChangeHandler() {
            final SimpleRecurrencePanel localThis = this;
            KeyboardListener keyboardListener = new KeyboardListener(){

                public void onKeyDown(Widget sender, char keyCode, int modifiers) {
                }

                public void onKeyPress(Widget sender, char keyCode, int modifiers) {
                }

                public void onKeyUp(Widget sender, char keyCode, int modifiers) {
                    localThis.changeHandler();
                }
            };
            this.valueTb.addKeyboardListener(keyboardListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TemporalValue {
        SECONDS(0, RecurrenceEditor.access$000().seconds()),
        MINUTES(1, RecurrenceEditor.access$000().minutes()),
        HOURS(2, RecurrenceEditor.access$000().hours()),
        DAILY(3, RecurrenceEditor.access$000().daily()),
        WEEKLY(4, RecurrenceEditor.access$000().weekly()),
        MONTHLY(5, RecurrenceEditor.access$000().monthly()),
        YEARLY(6, RecurrenceEditor.access$000().yearly());

        private final int value;
        private final String name;
        private static TemporalValue[] temporalValues;

        private TemporalValue(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }

        public static TemporalValue get(int idx) {
            return temporalValues[idx];
        }

        public static int length() {
            return temporalValues.length;
        }

        public static TemporalValue stringToTemporalValue(String temporalValue) throws EnumException {
            for (TemporalValue v : EnumSet.range(SECONDS, YEARLY)) {
                if (!v.toString().equals(temporalValue)) continue;
                return v;
            }
            throw new EnumException(MSGS.invalidTemporalValue(temporalValue));
        }

        static {
            temporalValues = new TemporalValue[]{SECONDS, MINUTES, HOURS, DAILY, WEEKLY, MONTHLY, YEARLY};
        }
    }
}

