/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.controls.schededitor;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.CaptionPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import java.util.Date;
import org.pentaho.gwt.widgets.client.controls.DatePickerEx;
import org.pentaho.gwt.widgets.client.controls.TimePicker;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessages;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessagesSingleton;
import org.pentaho.gwt.widgets.client.ui.ICallback;
import org.pentaho.gwt.widgets.client.ui.IChangeHandler;
import org.pentaho.gwt.widgets.client.utils.TimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunOnceEditor
extends VerticalPanel
implements IChangeHandler {
    private static final WidgetsLocalizedMessages MSGS = WidgetsLocalizedMessagesSingleton.getInstance().getMessages();
    private static final String SCHEDULER_CAPTION_PANEL = "schedule-editor-caption-panel";
    private TimePicker startTimePicker = new TimePicker();
    private DateBox.DefaultFormat format = new DateBox.DefaultFormat(DateTimeFormat.getShortDateFormat());
    private DatePickerEx startDatePicker = new DatePickerEx(this.format);
    private static final String DEFAULT_START_HOUR = "12";
    private static final String DEFAULT_START_MINUTE = "00";
    private static final TimeUtil.TimeOfDay DEFAULT_TIME_OF_DAY = TimeUtil.TimeOfDay.AM;
    private ICallback<IChangeHandler> onChangeHandler = null;

    public RunOnceEditor() {
        this.setWidth("100%");
        CaptionPanel startTimeCaptionPanel = new CaptionPanel(MSGS.startTime());
        startTimeCaptionPanel.setStyleName(SCHEDULER_CAPTION_PANEL);
        startTimeCaptionPanel.add((Widget)this.startTimePicker);
        this.add((Widget)startTimeCaptionPanel);
        CaptionPanel startDateCaptionPanel = new CaptionPanel(MSGS.startDate());
        startDateCaptionPanel.setStyleName(SCHEDULER_CAPTION_PANEL);
        startDateCaptionPanel.add((Widget)this.startDatePicker.getDatePicker());
        this.add((Widget)startDateCaptionPanel);
        this.configureOnChangeHandler();
    }

    public Date getStartDate() {
        return this.startDatePicker.getSelectedDate();
    }

    public void setStartDate(Date d) {
        this.startDatePicker.getDatePicker().setValue(d);
    }

    public String getStartTime() {
        return this.startTimePicker.getTime();
    }

    public void setStartTime(String strTime) {
        this.startTimePicker.setTime(strTime);
    }

    public void reset(Date d) {
        this.startTimePicker.setHour(DEFAULT_START_HOUR);
        this.startTimePicker.setMinute(DEFAULT_START_MINUTE);
        this.startTimePicker.setTimeOfDay(DEFAULT_TIME_OF_DAY);
        this.startDatePicker.getDatePicker().setValue(d);
    }

    public void setStartDateError(String errorMsg) {
    }

    @Override
    public void setOnChangeHandler(ICallback<IChangeHandler> handler) {
        this.onChangeHandler = handler;
    }

    private void changeHandler() {
        if (null != this.onChangeHandler) {
            this.onChangeHandler.onHandle(this);
        }
    }

    private void configureOnChangeHandler() {
        final RunOnceEditor localThis = this;
        ICallback<IChangeHandler> handler = new ICallback<IChangeHandler>(){

            @Override
            public void onHandle(IChangeHandler o) {
                localThis.changeHandler();
            }
        };
        this.startTimePicker.setOnChangeHandler(handler);
        this.startDatePicker.setOnChangeHandler(handler);
    }
}

