/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.controls.schededitor;

import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.gwt.widgets.client.controls.ErrorLabel;
import org.pentaho.gwt.widgets.client.controls.schededitor.CronEditor;
import org.pentaho.gwt.widgets.client.controls.schededitor.RecurrenceEditor;
import org.pentaho.gwt.widgets.client.controls.schededitor.RunOnceEditor;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessages;
import org.pentaho.gwt.widgets.client.i18n.WidgetsLocalizedMessagesSingleton;
import org.pentaho.gwt.widgets.client.ui.ICallback;
import org.pentaho.gwt.widgets.client.ui.IChangeHandler;
import org.pentaho.gwt.widgets.client.utils.CronExpression;
import org.pentaho.gwt.widgets.client.utils.CronParseException;
import org.pentaho.gwt.widgets.client.utils.CronParser;
import org.pentaho.gwt.widgets.client.utils.EnumException;
import org.pentaho.gwt.widgets.client.utils.TimeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleEditor
extends VerticalPanel
implements IChangeHandler {
    private static final WidgetsLocalizedMessages MSGS = WidgetsLocalizedMessagesSingleton.getInstance().getMessages();
    private static final String SCHEDULE_LABEL = "schedule-label";
    private RunOnceEditor runOnceEditor = null;
    private RecurrenceEditor recurrenceEditor = null;
    private CronEditor cronEditor = null;
    private Map<ScheduleType, Panel> scheduleTypeMap = new HashMap<ScheduleType, Panel>();
    private static Map<RecurrenceEditor.TemporalValue, ScheduleType> temporalValueToScheduleTypeMap = ScheduleEditor.createTemporalValueToScheduleTypeMap();
    private static Map<ScheduleType, RecurrenceEditor.TemporalValue> scheduleTypeToTemporalValueMap = ScheduleEditor.createScheduleTypeMapToTemporalValue();
    private TextBox nameTb = new TextBox();
    private TextBox groupNameTb = new TextBox();
    private TextBox descriptionTb = new TextBox();
    private ListBox scheduleCombo = null;
    private ErrorLabel nameLabel;
    private ErrorLabel groupNameLabel;
    private ErrorLabel descriptionLabel;
    private static final String DEFAULT_NAME = "";
    private static final String DEFAULT_GROUP_NAME = "";
    private static final String DEFAULT_DESCRIPTION = "";
    private ICallback<IChangeHandler> onChangeHandler = null;

    public ScheduleEditor() {
        this.setStylePrimaryName("scheduleEditor");
        int rowNum = 0;
        this.nameLabel = new ErrorLabel((Widget)new Label(MSGS.nameColon()));
        this.nameLabel.setStyleName(SCHEDULE_LABEL);
        this.add((Widget)this.nameLabel);
        this.add((Widget)this.nameTb);
        this.nameTb.setWidth("70%");
        ++rowNum;
        this.groupNameLabel = new ErrorLabel((Widget)new Label(MSGS.groupColon()));
        this.groupNameLabel.setStyleName(SCHEDULE_LABEL);
        this.add((Widget)this.groupNameLabel);
        this.add((Widget)this.groupNameTb);
        this.groupNameTb.setWidth("70%");
        ++rowNum;
        this.descriptionLabel = new ErrorLabel((Widget)new Label(MSGS.descriptionColon()));
        this.descriptionLabel.setStyleName(SCHEDULE_LABEL);
        this.add((Widget)this.descriptionLabel);
        this.descriptionTb.setStyleName("scheduleDescription");
        this.add((Widget)this.descriptionTb);
        ++rowNum;
        this.scheduleCombo = this.createScheduleCombo();
        Label l = new Label(MSGS.recurrenceColon());
        l.setStyleName(SCHEDULE_LABEL);
        this.add((Widget)l);
        this.add((Widget)this.scheduleCombo);
        ++rowNum;
        VerticalPanel vp = new VerticalPanel();
        vp.setWidth("100%");
        this.add((Widget)vp);
        this.setCellHeight((Widget)vp, "100%");
        this.runOnceEditor = new RunOnceEditor();
        vp.add((Widget)this.runOnceEditor);
        this.scheduleTypeMap.put(ScheduleType.RUN_ONCE, (Panel)this.runOnceEditor);
        this.runOnceEditor.setVisible(true);
        this.recurrenceEditor = new RecurrenceEditor();
        vp.add((Widget)this.recurrenceEditor);
        this.scheduleTypeMap.put(ScheduleType.SECONDS, (Panel)this.recurrenceEditor);
        this.scheduleTypeMap.put(ScheduleType.MINUTES, (Panel)this.recurrenceEditor);
        this.scheduleTypeMap.put(ScheduleType.HOURS, (Panel)this.recurrenceEditor);
        this.scheduleTypeMap.put(ScheduleType.DAILY, (Panel)this.recurrenceEditor);
        this.scheduleTypeMap.put(ScheduleType.WEEKLY, (Panel)this.recurrenceEditor);
        this.scheduleTypeMap.put(ScheduleType.MONTHLY, (Panel)this.recurrenceEditor);
        this.scheduleTypeMap.put(ScheduleType.YEARLY, (Panel)this.recurrenceEditor);
        this.recurrenceEditor.setVisible(false);
        this.cronEditor = new CronEditor();
        vp.add((Widget)this.cronEditor);
        this.scheduleTypeMap.put(ScheduleType.CRON, (Panel)this.cronEditor);
        this.cronEditor.setVisible(false);
        this.configureOnChangeHandler();
    }

    public void reset(Date now) {
        this.setName("");
        this.setGroupName("");
        this.setDescription("");
        this.runOnceEditor.reset(now);
        this.recurrenceEditor.reset(now);
        this.cronEditor.reset(now);
        this.setScheduleType(ScheduleType.RUN_ONCE);
    }

    public String getName() {
        return this.nameTb.getText();
    }

    public void setName(String name) {
        this.nameTb.setText(name);
    }

    public String getGroupName() {
        return this.groupNameTb.getText();
    }

    public void setGroupName(String groupName) {
        this.groupNameTb.setText(groupName);
    }

    public String getDescription() {
        return this.descriptionTb.getText();
    }

    public void setDescription(String description) {
        this.descriptionTb.setText(description);
    }

    public String getCronString() {
        switch (this.getScheduleType()) {
            case RUN_ONCE: {
                return null;
            }
            case SECONDS: 
            case MINUTES: 
            case HOURS: 
            case DAILY: 
            case WEEKLY: 
            case MONTHLY: 
            case YEARLY: {
                return this.recurrenceEditor.getCronString();
            }
            case CRON: {
                return this.cronEditor.getCronString();
            }
        }
        throw new RuntimeException(MSGS.invalidRunType(this.getScheduleType().toString()));
    }

    public void setCronString(String cronStr) throws CronParseException {
        CronParser cp = new CronParser(cronStr);
        String recurrenceStr = null;
        try {
            recurrenceStr = cp.parseToRecurrenceString();
        }
        catch (CronParseException e) {
            if (!CronExpression.isValidExpression(cronStr)) {
                throw e;
            }
            recurrenceStr = null;
        }
        if (null != recurrenceStr) {
            this.recurrenceEditor.inititalizeWithRecurrenceString(recurrenceStr);
            RecurrenceEditor.TemporalValue tv = this.recurrenceEditor.getTemporalState();
            ScheduleType rt = ScheduleEditor.temporalValueToScheduleType(tv);
            this.setScheduleType(rt);
        } else {
            this.setScheduleType(ScheduleType.CRON);
        }
        this.cronEditor.setCronString(cronStr);
    }

    public Long getRepeatInSecs() throws RuntimeException {
        return this.recurrenceEditor.getRepeatInSecs();
    }

    public void setRepeatInSecs(Integer repeatInSecs) {
        this.recurrenceEditor.inititalizeWithRepeatInSecs(repeatInSecs);
        RecurrenceEditor.TemporalValue tv = this.recurrenceEditor.getTemporalState();
        ScheduleType rt = ScheduleEditor.temporalValueToScheduleType(tv);
        this.setScheduleType(rt);
    }

    private ListBox createScheduleCombo() {
        final ScheduleEditor localThis = this;
        ListBox lb = new ListBox();
        lb.setVisibleItemCount(1);
        lb.addChangeListener(new ChangeListener(){

            public void onChange(Widget sender) {
                localThis.handleScheduleChange();
            }
        });
        for (ScheduleType schedType : EnumSet.range(ScheduleType.RUN_ONCE, ScheduleType.CRON)) {
            lb.addItem(schedType.toString());
        }
        lb.setItemSelected(0, true);
        return lb;
    }

    public ScheduleType getScheduleType() {
        String selectedValue = this.scheduleCombo.getValue(this.scheduleCombo.getSelectedIndex());
        return ScheduleType.stringToScheduleType(selectedValue);
    }

    public void setScheduleType(ScheduleType scheduleType) {
        this.scheduleCombo.setSelectedIndex(scheduleType.value());
        this.selectScheduleTypeEditor(scheduleType);
    }

    public RecurrenceEditor getRecurrenceEditor() {
        return this.recurrenceEditor;
    }

    public CronEditor getCronEditor() {
        return this.cronEditor;
    }

    public RunOnceEditor getRunOnceEditor() {
        return this.runOnceEditor;
    }

    public void setStartTime(String startTime) {
        this.runOnceEditor.setStartTime(startTime);
        this.recurrenceEditor.setStartTime(startTime);
    }

    public String getStartTime() {
        switch (this.getScheduleType()) {
            case RUN_ONCE: {
                return this.runOnceEditor.getStartTime();
            }
            case SECONDS: 
            case MINUTES: 
            case HOURS: 
            case DAILY: 
            case WEEKLY: 
            case MONTHLY: 
            case YEARLY: {
                return this.recurrenceEditor.getStartTime();
            }
            case CRON: {
                return this.cronEditor.getStartTime();
            }
        }
        throw new RuntimeException(MSGS.invalidRunType(this.getScheduleType().toString()));
    }

    public void setStartDate(Date startDate) {
        this.runOnceEditor.setStartDate(startDate);
        this.recurrenceEditor.setStartDate(startDate);
        this.cronEditor.setStartDate(startDate);
    }

    public Date getStartDate() {
        switch (this.getScheduleType()) {
            case RUN_ONCE: {
                Date startDate = this.runOnceEditor.getStartDate();
                String startTime = this.runOnceEditor.getStartTime();
                Date startDateTime = TimeUtil.getDateTime(startTime, startDate);
                return startDateTime;
            }
            case SECONDS: 
            case MINUTES: 
            case HOURS: 
            case DAILY: 
            case WEEKLY: 
            case MONTHLY: 
            case YEARLY: {
                return this.recurrenceEditor.getStartDate();
            }
            case CRON: {
                return this.cronEditor.getStartDate();
            }
        }
        throw new RuntimeException(MSGS.invalidRunType(this.getScheduleType().toString()));
    }

    public void setEndDate(Date endDate) {
        this.recurrenceEditor.setEndDate(endDate);
        this.cronEditor.setEndDate(endDate);
    }

    public Date getEndDate() {
        switch (this.getScheduleType()) {
            case RUN_ONCE: {
                return null;
            }
            case SECONDS: 
            case MINUTES: 
            case HOURS: 
            case DAILY: 
            case WEEKLY: 
            case MONTHLY: 
            case YEARLY: {
                return this.recurrenceEditor.getEndDate();
            }
            case CRON: {
                return this.cronEditor.getEndDate();
            }
        }
        throw new RuntimeException(MSGS.invalidRunType(this.getScheduleType().toString()));
    }

    public void setNoEndDate() {
        this.recurrenceEditor.setNoEndDate();
        this.cronEditor.setNoEndDate();
    }

    public void setEndBy() {
        this.recurrenceEditor.setEndBy();
        this.cronEditor.setEndBy();
    }

    private void handleScheduleChange() throws EnumException {
        ScheduleType schedType = this.getScheduleType();
        this.selectScheduleTypeEditor(schedType);
    }

    private void selectScheduleTypeEditor(ScheduleType scheduleType) {
        for (Map.Entry<ScheduleType, Panel> me : this.scheduleTypeMap.entrySet()) {
            me.getValue().setVisible(false);
        }
        Panel p = this.scheduleTypeMap.get((Object)scheduleType);
        p.setVisible(true);
        RecurrenceEditor.TemporalValue tv = ScheduleEditor.scheduleTypeToTemporalValue(scheduleType);
        if (null != tv) {
            this.recurrenceEditor.setTemporalState(tv);
        }
    }

    public void setNameError(String errorMsg) {
        this.nameLabel.setErrorMsg(errorMsg);
    }

    public void setGroupNameError(String errorMsg) {
        this.groupNameLabel.setErrorMsg(errorMsg);
    }

    public void setDescriptionError(String errorMsg) {
        this.descriptionLabel.setErrorMsg(errorMsg);
    }

    private static Map<RecurrenceEditor.TemporalValue, ScheduleType> createTemporalValueToScheduleTypeMap() {
        HashMap<RecurrenceEditor.TemporalValue, ScheduleType> m = new HashMap<RecurrenceEditor.TemporalValue, ScheduleType>();
        m.put(RecurrenceEditor.TemporalValue.SECONDS, ScheduleType.SECONDS);
        m.put(RecurrenceEditor.TemporalValue.MINUTES, ScheduleType.MINUTES);
        m.put(RecurrenceEditor.TemporalValue.HOURS, ScheduleType.HOURS);
        m.put(RecurrenceEditor.TemporalValue.DAILY, ScheduleType.DAILY);
        m.put(RecurrenceEditor.TemporalValue.WEEKLY, ScheduleType.WEEKLY);
        m.put(RecurrenceEditor.TemporalValue.MONTHLY, ScheduleType.MONTHLY);
        m.put(RecurrenceEditor.TemporalValue.YEARLY, ScheduleType.YEARLY);
        return m;
    }

    private static Map<ScheduleType, RecurrenceEditor.TemporalValue> createScheduleTypeMapToTemporalValue() {
        HashMap<ScheduleType, RecurrenceEditor.TemporalValue> m = new HashMap<ScheduleType, RecurrenceEditor.TemporalValue>();
        m.put(ScheduleType.SECONDS, RecurrenceEditor.TemporalValue.SECONDS);
        m.put(ScheduleType.MINUTES, RecurrenceEditor.TemporalValue.MINUTES);
        m.put(ScheduleType.HOURS, RecurrenceEditor.TemporalValue.HOURS);
        m.put(ScheduleType.DAILY, RecurrenceEditor.TemporalValue.DAILY);
        m.put(ScheduleType.WEEKLY, RecurrenceEditor.TemporalValue.WEEKLY);
        m.put(ScheduleType.MONTHLY, RecurrenceEditor.TemporalValue.MONTHLY);
        m.put(ScheduleType.YEARLY, RecurrenceEditor.TemporalValue.YEARLY);
        return m;
    }

    private static ScheduleType temporalValueToScheduleType(RecurrenceEditor.TemporalValue tv) {
        return temporalValueToScheduleTypeMap.get((Object)tv);
    }

    private static RecurrenceEditor.TemporalValue scheduleTypeToTemporalValue(ScheduleType st) {
        return scheduleTypeToTemporalValueMap.get((Object)st);
    }

    public void setFocus() {
        this.nameTb.setFocus(true);
        this.nameTb.setSelectionRange(0, this.nameTb.getText().length());
    }

    @Override
    public void setOnChangeHandler(ICallback<IChangeHandler> handler) {
        this.onChangeHandler = handler;
    }

    private void changeHandler() {
        if (null != this.onChangeHandler) {
            this.onChangeHandler.onHandle(this);
        }
    }

    private void configureOnChangeHandler() {
        final ScheduleEditor localThis = this;
        KeyboardListener keyboardListener = new KeyboardListener(){

            public void onKeyDown(Widget sender, char keyCode, int modifiers) {
            }

            public void onKeyPress(Widget sender, char keyCode, int modifiers) {
            }

            public void onKeyUp(Widget sender, char keyCode, int modifiers) {
                localThis.changeHandler();
            }
        };
        ChangeListener changeListener = new ChangeListener(){

            public void onChange(Widget sender) {
                localThis.changeHandler();
            }
        };
        ICallback<IChangeHandler> handler = new ICallback<IChangeHandler>(){

            @Override
            public void onHandle(IChangeHandler o) {
                localThis.changeHandler();
            }
        };
        this.nameTb.addKeyboardListener(keyboardListener);
        this.groupNameTb.addKeyboardListener(keyboardListener);
        this.descriptionTb.addKeyboardListener(keyboardListener);
        this.scheduleCombo.addChangeListener(changeListener);
        this.runOnceEditor.setOnChangeHandler(handler);
        this.recurrenceEditor.setOnChangeHandler(handler);
        this.cronEditor.setOnChangeHandler(handler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScheduleType {
        RUN_ONCE(0, ScheduleEditor.access$000().runOnce()),
        SECONDS(1, ScheduleEditor.access$000().seconds()),
        MINUTES(2, ScheduleEditor.access$000().minutes()),
        HOURS(3, ScheduleEditor.access$000().hours()),
        DAILY(4, ScheduleEditor.access$000().daily()),
        WEEKLY(5, ScheduleEditor.access$000().weekly()),
        MONTHLY(6, ScheduleEditor.access$000().monthly()),
        YEARLY(7, ScheduleEditor.access$000().yearly()),
        CRON(8, ScheduleEditor.access$000().cron());

        private final int value;
        private final String name;
        private static ScheduleType[] scheduleValue;

        private ScheduleType(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int value() {
            return this.value;
        }

        public String toString() {
            return this.name;
        }

        public static ScheduleType get(int idx) {
            return scheduleValue[idx];
        }

        public static int length() {
            return scheduleValue.length;
        }

        public static ScheduleType stringToScheduleType(String strSchedule) throws EnumException {
            for (ScheduleType v : EnumSet.range(RUN_ONCE, CRON)) {
                if (!v.toString().equals(strSchedule)) continue;
                return v;
            }
            throw new EnumException(MSGS.invalidTemporalValue(scheduleValue.toString()));
        }

        static {
            scheduleValue = new ScheduleType[]{RUN_ONCE, SECONDS, MINUTES, HOURS, DAILY, WEEKLY, MONTHLY, YEARLY, CRON};
        }
    }
}

