/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.dialogs;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.PopupListener;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.dialogs.GlassPane;
import org.pentaho.gwt.widgets.client.utils.FrameUtils;

public class DialogBox
extends com.google.gwt.user.client.ui.DialogBox
implements PopupListener {
    private static FocusPanel pageBackground = null;
    private static int clickCount = 0;
    private static int dialogDepthCount = 0;
    private FocusWidget focusWidget = null;
    boolean autoHide = false;
    boolean modal = true;
    boolean centerCalled = false;

    public DialogBox(boolean autoHide, boolean modal) {
        super(autoHide, modal);
        this.autoHide = autoHide;
        this.modal = modal;
        this.addPopupListener(this);
        this.setStylePrimaryName("pentaho-dialog");
    }

    public boolean onKeyDownPreview(char key, int modifiers) {
        switch (key) {
            case '\r': 
            case '\u001b': {
                this.hide();
            }
        }
        return true;
    }

    public void center() {
        if (pageBackground == null) {
            pageBackground = new FocusPanel();
            pageBackground.setStyleName("glasspane");
            pageBackground.addClickListener(new ClickListener(){

                public void onClick(Widget sender) {
                    clickCount++;
                    if (clickCount > 2) {
                        clickCount = 0;
                        pageBackground.setVisible(false);
                        pageBackground.getElement().getStyle().setDisplay(Style.Display.NONE);
                    }
                }
            });
            RootPanel.get().add((Widget)pageBackground, 0, 0);
        }
        super.center();
        if (this.modal && !this.centerCalled) {
            pageBackground.setSize("100%", Window.getClientHeight() + Window.getScrollTop() + "px");
            pageBackground.setVisible(true);
            pageBackground.getElement().getStyle().setDisplay(Style.Display.BLOCK);
            ++dialogDepthCount;
            this.centerCalled = true;
        }
        if (this.focusWidget != null) {
            this.focusWidget.setFocus(true);
        }
        FrameUtils.toggleEmbedVisibility(false);
        GlassPane.getInstance().show();
    }

    public void show() {
        super.show();
        if (this.focusWidget != null) {
            this.focusWidget.setFocus(true);
        }
    }

    public void setFocusWidget(FocusWidget widget) {
        this.focusWidget = widget;
        if (this.focusWidget != null) {
            this.focusWidget.setFocus(true);
        }
    }

    public void onPopupClosed(PopupPanel sender, boolean autoClosed) {
        if (this.modal) {
            this.centerCalled = false;
            if (--dialogDepthCount <= 0) {
                pageBackground.setVisible(false);
                if (this.isVisible()) {
                    FrameUtils.toggleEmbedVisibility(true);
                }
                dialogDepthCount = 0;
            }
        }
        GlassPane.getInstance().hide();
    }
}

