/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.gwt.widgets.client.dialogs.GlassPaneListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassPane {
    private static GlassPane instance = new GlassPane();
    private List<GlassPaneListener> listeners = new ArrayList<GlassPaneListener>();
    private boolean shown = false;
    private int dialogCount = 0;

    private GlassPane() {
    }

    public static GlassPane getInstance() {
        return instance;
    }

    public void show() {
        ++this.dialogCount;
        if (!this.shown) {
            this.shown = true;
            ArrayList<GlassPaneListener> listenersToRemove = new ArrayList<GlassPaneListener>();
            for (GlassPaneListener listener : this.listeners) {
                try {
                    listener.glassPaneShown();
                }
                catch (Exception e) {
                    listenersToRemove.add(listener);
                }
            }
            this.removeBadListeners(listenersToRemove);
        }
    }

    private void removeBadListeners(List<GlassPaneListener> removeThese) {
        for (GlassPaneListener listener : removeThese) {
            this.listeners.remove(listener);
        }
    }

    public void hide() {
        --this.dialogCount;
        if (this.dialogCount < 0) {
            this.dialogCount = 0;
        }
        if (this.shown && this.dialogCount == 0) {
            this.shown = false;
            ArrayList<GlassPaneListener> listenersToRemove = new ArrayList<GlassPaneListener>();
            for (GlassPaneListener listener : this.listeners) {
                try {
                    listener.glassPaneHidden();
                }
                catch (Exception e) {
                    listenersToRemove.add(listener);
                }
            }
            this.removeBadListeners(listenersToRemove);
        }
    }

    public void addGlassPaneListener(GlassPaneListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeGlassPaneListener(GlassPaneListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }
}

