/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.gwt.widgets.client.dialogs;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FocusWidget;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.pentaho.gwt.widgets.client.dialogs.DialogBox;
import org.pentaho.gwt.widgets.client.dialogs.IDialogCallback;
import org.pentaho.gwt.widgets.client.dialogs.IDialogValidatorCallback;

public class PromptDialogBox
extends DialogBox {
    IDialogCallback callback;
    IDialogValidatorCallback validatorCallback;
    Widget content;
    final FlexTable dialogContent = new FlexTable();
    protected Button okButton = null;
    protected Button cancelButton = null;

    public PromptDialogBox(String title, String okText, String cancelText, boolean autoHide, boolean modal) {
        super(autoHide, modal);
        this.setText(title);
        this.okButton = new Button(okText);
        this.okButton.setStylePrimaryName("pentaho-button");
        this.okButton.getElement().setAttribute("id", "okButton");
        this.okButton.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                PromptDialogBox.this.onOk();
            }
        });
        HorizontalPanel dialogButtonPanel = new HorizontalPanel();
        dialogButtonPanel.setSpacing(0);
        dialogButtonPanel.add((Widget)this.okButton);
        if (cancelText != null) {
            this.cancelButton = new Button(cancelText);
            this.cancelButton.setStylePrimaryName("pentaho-button");
            this.cancelButton.getElement().setAttribute("id", "cancelButton");
            this.cancelButton.addClickListener(new ClickListener(){

                public void onClick(Widget sender) {
                    PromptDialogBox.this.onCancel();
                }
            });
            dialogButtonPanel.add((Widget)this.cancelButton);
        }
        HorizontalPanel dialogButtonPanelWrapper = new HorizontalPanel();
        if (okText != null && cancelText != null) {
            dialogButtonPanelWrapper.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_RIGHT);
        } else {
            dialogButtonPanelWrapper.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        }
        dialogButtonPanelWrapper.setStyleName("button-panel");
        dialogButtonPanelWrapper.setWidth("100%");
        dialogButtonPanelWrapper.add((Widget)dialogButtonPanel);
        if (this.content instanceof FocusWidget) {
            this.setFocusWidget((FocusWidget)this.content);
        }
        this.dialogContent.setCellPadding(0);
        this.dialogContent.setCellSpacing(0);
        this.dialogContent.getFlexCellFormatter().setHeight(0, 0, "100%");
        this.dialogContent.setWidget(1, 0, (Widget)dialogButtonPanelWrapper);
        this.dialogContent.getCellFormatter().setVerticalAlignment(1, 0, HasVerticalAlignment.ALIGN_BOTTOM);
        this.dialogContent.setWidth("100%");
        this.setWidget((Widget)this.dialogContent);
    }

    public PromptDialogBox(String title, String okText, String cancelText, boolean autoHide, boolean modal, Widget content) {
        this(title, okText, cancelText, autoHide, modal);
        this.setContent(content);
    }

    public boolean onKeyDownPreview(char key, int modifiers) {
        switch (key) {
            case '\r': {
                this.onOk();
                break;
            }
            case '\u001b': {
                this.onCancel();
            }
        }
        return true;
    }

    public IDialogCallback getCallback() {
        return this.callback;
    }

    public void setContent(Widget content) {
        this.content = content;
        if (content != null) {
            this.dialogContent.getFlexCellFormatter().setVerticalAlignment(0, 0, HasVerticalAlignment.ALIGN_MIDDLE);
            this.dialogContent.getFlexCellFormatter().setHorizontalAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER);
            this.dialogContent.setWidget(0, 0, content);
            this.dialogContent.getCellFormatter().setStyleName(0, 0, "dialog-content");
            DOM.setStyleAttribute((Element)this.dialogContent.getCellFormatter().getElement(0, 0), (String)"padding", (String)"5px 10px 10px 10px");
            content.setHeight("100%");
            content.setWidth("100%");
        }
    }

    public Widget getContent() {
        return this.content;
    }

    public void setCallback(IDialogCallback callback) {
        this.callback = callback;
    }

    public IDialogValidatorCallback getValidatorCallback() {
        return this.validatorCallback;
    }

    public void setValidatorCallback(IDialogValidatorCallback validatorCallback) {
        this.validatorCallback = validatorCallback;
    }

    protected void onOk() {
        if (this.validatorCallback == null || this.validatorCallback != null && this.validatorCallback.validate()) {
            try {
                if (this.callback != null) {
                    this.callback.okPressed();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.hide();
        }
    }

    protected void onCancel() {
        try {
            if (this.callback != null) {
                this.callback.cancelPressed();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.hide();
    }
}

